/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.itemgenerator.editor.sockets;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import studio.magemonkey.codex.manager.api.menu.Slot;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.AbstractEditorGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.EditorGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.LoreGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.sockets.SocketListGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.stats.MainStatsGUI;

public class SocketGUI
extends AbstractEditorGUI {
    private final String name;

    public SocketGUI(Player player, AbstractEditorGUI.ItemGeneratorReference itemGenerator, String name) {
        super(player, 1, "Editor/" + EditorGUI.ItemType.SOCKETS.getTitle(), itemGenerator);
        this.name = name;
    }

    public void setContents() {
        final String path = EditorGUI.ItemType.SOCKETS.getPath() + "." + this.name + ".";
        this.setSlot(0, new Slot(SocketGUI.createItem(Material.BROWN_MUSHROOM, "&eMinimum " + this.name + " sockets", "&bCurrent: &a" + this.itemGenerator.getConfig().getInt(path + MainStatsGUI.ItemType.MINIMUM.getPath()), "&6Left-Click: &eSet", "&6Shift-Left-Click: &eDecrease", "&6Shift-Right-Click: &eIncrease", "&6Right-Click: &eSet to default value")){

            public void onShiftLeftClick() {
                SocketGUI.this.itemGenerator.getConfig().set(path + MainStatsGUI.ItemType.MINIMUM.getPath(), (Object)Math.max(0, SocketGUI.this.itemGenerator.getConfig().getInt(path + MainStatsGUI.ItemType.MINIMUM.getPath()) - 1));
                SocketGUI.this.saveAndReopen();
            }

            public void onShiftRightClick() {
                SocketGUI.this.itemGenerator.getConfig().set(path + MainStatsGUI.ItemType.MINIMUM.getPath(), (Object)Math.max(0, SocketGUI.this.itemGenerator.getConfig().getInt(path + MainStatsGUI.ItemType.MINIMUM.getPath()) + 1));
                SocketGUI.this.saveAndReopen();
            }

            public void onLeftClick() {
                SocketGUI.this.sendSetMessage(MainStatsGUI.ItemType.MINIMUM.name().toLowerCase() + " " + SocketGUI.this.name + " sockets", String.valueOf(SocketGUI.this.itemGenerator.getConfig().getInt(path + MainStatsGUI.ItemType.MINIMUM.getPath())), s -> {
                    int value = Integer.parseInt(s);
                    if (value < 0) {
                        throw new IllegalArgumentException();
                    }
                    SocketGUI.this.itemGenerator.getConfig().set(path + MainStatsGUI.ItemType.MINIMUM.getPath(), (Object)value);
                    SocketGUI.this.saveAndReopen();
                });
            }

            public void onRightClick() {
                SocketGUI.this.itemGenerator.getConfig().set(path + MainStatsGUI.ItemType.MINIMUM.getPath(), (Object)0);
                SocketGUI.this.saveAndReopen();
            }
        });
        this.setSlot(1, new Slot(SocketGUI.createItem(Material.RED_MUSHROOM, "&eMaximum " + this.name + " sockets", "&bCurrent: &a" + this.itemGenerator.getConfig().getInt(path + MainStatsGUI.ItemType.MAXIMUM.getPath()), "&6Left-Click: &eSet", "&6Shift-Left-Click: &eDecrease", "&6Shift-Right-Click: &eIncrease", "&6Right-Click: &eSet to default value")){

            public void onShiftLeftClick() {
                SocketGUI.this.itemGenerator.getConfig().set(path + MainStatsGUI.ItemType.MAXIMUM.getPath(), (Object)Math.max(0, SocketGUI.this.itemGenerator.getConfig().getInt(path + MainStatsGUI.ItemType.MAXIMUM.getPath()) - 1));
                SocketGUI.this.saveAndReopen();
            }

            public void onShiftRightClick() {
                SocketGUI.this.itemGenerator.getConfig().set(path + MainStatsGUI.ItemType.MAXIMUM.getPath(), (Object)Math.max(0, SocketGUI.this.itemGenerator.getConfig().getInt(path + MainStatsGUI.ItemType.MAXIMUM.getPath()) + 1));
                SocketGUI.this.saveAndReopen();
            }

            public void onLeftClick() {
                SocketGUI.this.sendSetMessage(MainStatsGUI.ItemType.MAXIMUM.name().toLowerCase() + " " + SocketGUI.this.name + " sockets", String.valueOf(SocketGUI.this.itemGenerator.getConfig().getInt(path + MainStatsGUI.ItemType.MAXIMUM.getPath())), s -> {
                    int value = Integer.parseInt(s);
                    if (value < 0) {
                        throw new IllegalArgumentException();
                    }
                    SocketGUI.this.itemGenerator.getConfig().set(path + MainStatsGUI.ItemType.MAXIMUM.getPath(), (Object)value);
                    SocketGUI.this.saveAndReopen();
                });
            }

            public void onRightClick() {
                SocketGUI.this.itemGenerator.getConfig().set(path + MainStatsGUI.ItemType.MAXIMUM.getPath(), (Object)0);
                SocketGUI.this.saveAndReopen();
            }
        });
        this.setSlot(2, new Slot(SocketGUI.createItem(Material.WRITABLE_BOOK, "&eLore format", (List<String>)StringUT.replace((String)"%current%", (List)this.itemGenerator.getConfig().getStringList(path + MainStatsGUI.ItemType.LORE.getPath()), (String[])new String[]{"&bCurrent:", "&a----------", "&f%current%", "&a----------", "&6Left-Click: &eModify", "&6Right-Click: &eSet to default value"}))){

            public void onLeftClick() {
                SocketGUI.this.openSubMenu(new LoreGUI(SocketGUI.this.player, SocketGUI.this.title + " lore", SocketGUI.this.itemGenerator, path + MainStatsGUI.ItemType.LORE.getPath()));
            }

            public void onDrop() {
                SocketGUI.this.itemGenerator.getConfig().set(path + MainStatsGUI.ItemType.LORE.getPath(), (Object)StringUT.replace((String)"%current%", List.of(SocketGUI.this.name), (String[])new String[]{"&8&m               &f  \u300c %current%S \u300d  &8&m               ", "%SOCKET_%current%_DEFAULT%"}));
                SocketGUI.this.saveAndReopen();
            }
        });
        ArrayList<CallSite> lore = new ArrayList<CallSite>();
        ConfigurationSection listSection = this.itemGenerator.getConfig().getConfigurationSection(path + ".list");
        if (listSection != null) {
            for (String key : listSection.getKeys(false)) {
                lore.add((CallSite)((Object)("&a- " + key + ": &f" + listSection.getDouble(key + ".chance", 0.0))));
            }
        }
        this.setSlot(3, new Slot(SocketGUI.createItem(Material.IRON_SWORD, "&eList of chances per tier", (List<String>)StringUT.replace((String)"%current%", lore, (String[])new String[]{"&bCurrent:", "%current%", "&eModify"}))){

            public void onLeftClick() {
                SocketGUI.this.openSubMenu(new SocketListGUI(SocketGUI.this.player, SocketGUI.this.itemGenerator, SocketGUI.this.name));
            }
        });
    }
}

