/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.itemgenerator.editor.bonuses;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import studio.magemonkey.codex.manager.api.menu.Slot;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.hooks.external.FabledHook;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.AbstractEditorGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.EditorGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.bonuses.BonusCategoryGUI;
import studio.magemonkey.divinity.stats.items.ItemStats;
import studio.magemonkey.divinity.stats.items.attributes.AmmoAttribute;
import studio.magemonkey.divinity.stats.items.attributes.DamageAttribute;
import studio.magemonkey.divinity.stats.items.attributes.DefenseAttribute;
import studio.magemonkey.divinity.stats.items.attributes.FabledAttribute;
import studio.magemonkey.divinity.stats.items.attributes.HandAttribute;
import studio.magemonkey.divinity.stats.items.attributes.api.TypedStat;

public class NewBonusStatGUI
extends AbstractEditorGUI {
    private final String path;
    private final BonusCategoryGUI.ItemType statType;

    public NewBonusStatGUI(Player player, AbstractEditorGUI.ItemGeneratorReference itemGenerator, String path, BonusCategoryGUI.ItemType statType) {
        super(player, 6, "Editor/" + EditorGUI.ItemType.MATERIALS.getTitle(), itemGenerator);
        this.path = path;
        this.statType = statType;
    }

    public void setContents() {
        Material material;
        ArrayList<String> list = new ArrayList<String>();
        ConfigurationSection section = this.itemGenerator.getConfig().getConfigurationSection(this.getPath());
        Set existingKeys = section == null ? new HashSet() : section.getKeys(false);
        switch (this.statType) {
            case DAMAGE: {
                material = Material.IRON_SWORD;
                for (DamageAttribute damageAttribute : ItemStats.getDamages()) {
                    boolean exists = false;
                    for (String existingKey : existingKeys) {
                        if (!existingKey.equalsIgnoreCase(damageAttribute.getId())) continue;
                        exists = true;
                        break;
                    }
                    if (exists) continue;
                    list.add(damageAttribute.getId());
                }
                break;
            }
            case DEFENSE: {
                material = Material.IRON_CHESTPLATE;
                for (DefenseAttribute defenseAttribute : ItemStats.getDefenses()) {
                    boolean exists = false;
                    for (String existingKey : existingKeys) {
                        if (!existingKey.equalsIgnoreCase(defenseAttribute.getId())) continue;
                        exists = true;
                        break;
                    }
                    if (exists) continue;
                    list.add(defenseAttribute.getId());
                }
                break;
            }
            case ITEM_STAT: {
                material = Material.OAK_SIGN;
                for (TypedStat.Type itemStat : TypedStat.Type.values()) {
                    boolean exists = false;
                    for (String existingKey : existingKeys) {
                        if (!existingKey.equalsIgnoreCase(itemStat.name())) continue;
                        exists = true;
                        break;
                    }
                    if (exists) continue;
                    list.add(itemStat.name());
                }
                break;
            }
            case FABLED_ATTRIBUTE: {
                material = Material.BOOK;
                FabledHook fabledHook = (FabledHook)Divinity.getInstance().getHook("Fabled");
                if (fabledHook == null) break;
                for (FabledAttribute fabledAttribute : fabledHook.getAttributes()) {
                    boolean exists = false;
                    for (String existingKey : existingKeys) {
                        if (!existingKey.equalsIgnoreCase(fabledAttribute.getId())) continue;
                        exists = true;
                        break;
                    }
                    if (exists) continue;
                    list.add(fabledAttribute.getId());
                }
                break;
            }
            case HAND: {
                material = Material.STICK;
                for (HandAttribute handAttribute : ItemStats.getHands()) {
                    boolean exists = false;
                    for (String existingKey : existingKeys) {
                        if (!existingKey.equalsIgnoreCase(handAttribute.getId())) continue;
                        exists = true;
                        break;
                    }
                    if (exists) continue;
                    list.add(handAttribute.getId());
                }
                break;
            }
            case AMMO: {
                material = Material.ARROW;
                for (AmmoAttribute ammoAttribute : ItemStats.getAmmos()) {
                    boolean exists = false;
                    for (String existingKey : existingKeys) {
                        if (!existingKey.equalsIgnoreCase(ammoAttribute.getId())) continue;
                        exists = true;
                        break;
                    }
                    if (exists) continue;
                    list.add(ammoAttribute.getId());
                }
                break;
            }
            default: {
                material = Material.STONE;
            }
        }
        int i = 0;
        for (final String stat : list) {
            if (++i % this.inventory.getSize() == 53) {
                this.setSlot(i, this.getNextButton());
                ++i;
            } else if (i % 9 == 8) {
                ++i;
            }
            if (i % this.inventory.getSize() == 45) {
                this.setSlot(i, this.getPrevButton());
                ++i;
            } else if (i % 9 == 0) {
                ++i;
            }
            this.setSlot(i, new Slot(NewBonusStatGUI.createItem(material, "&e" + stat, "&6Left-Click: &eCreate")){

                public void onLeftClick() {
                    NewBonusStatGUI.this.sendSetMessage(stat + " " + NewBonusStatGUI.this.statType.name().replace('_', ' ').toLowerCase() + " value", null, s -> {
                        String[] split = s.split("%", 2);
                        if (split.length == 2 && !split[1].isEmpty()) {
                            throw new IllegalArgumentException();
                        }
                        Double.parseDouble(split[0]);
                        NewBonusStatGUI.this.itemGenerator.getConfig().set(NewBonusStatGUI.this.getPath() + "." + stat, s);
                        NewBonusStatGUI.this.saveAndReopen();
                        NewBonusStatGUI.this.close(2);
                    });
                }
            });
        }
        this.setSlot(this.getPages() * this.inventory.getSize() - 9, this.getPrevButton());
        this.setSlot(this.getPages() * this.inventory.getSize() - 1, this.getNextButton());
    }

    private String getPath() {
        return this.path + "." + this.statType.getPath();
    }
}

