/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.itemgenerator;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.api.armor.ArmorEquipEvent;
import studio.magemonkey.codex.compat.VersionManager;
import studio.magemonkey.codex.manager.IListener;
import studio.magemonkey.codex.manager.api.Loadable;
import studio.magemonkey.codex.util.ItemUT;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.hooks.external.FabledHook;
import studio.magemonkey.divinity.modules.list.itemgenerator.ItemGeneratorManager;
import studio.magemonkey.divinity.stats.items.ItemStats;
import studio.magemonkey.divinity.stats.items.attributes.stats.DurabilityStat;

public class ItemAbilityHandler
extends IListener<Divinity>
implements Loadable {
    private final ItemGeneratorManager itemGen;
    private final List<UUID> noSpam = new ArrayList<UUID>();

    ItemAbilityHandler(@NotNull ItemGeneratorManager itemGen) {
        super((JavaPlugin)((Divinity)itemGen.plugin));
        this.itemGen = itemGen;
    }

    public void setup() {
        this.registerListeners();
    }

    public void shutdown() {
        this.unregisterListeners();
    }

    private boolean registerSentMessage(Player player) {
        if (this.noSpam.contains(player.getUniqueId())) {
            return false;
        }
        this.noSpam.add(player.getUniqueId());
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.noSpam.remove(player.getUniqueId()), 60L);
        return true;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerJoin(PlayerJoinEvent event) {
        FabledHook fabledHook = (FabledHook)((Divinity)this.plugin).getHook("Fabled");
        if (fabledHook != null) {
            fabledHook.updateSkills(event.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void playerDeath(PlayerDeathEvent event) {
        FabledHook fabledHook = (FabledHook)((Divinity)this.plugin).getHook("Fabled");
        if (fabledHook != null) {
            fabledHook.updateSkills(event.getEntity());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void itemSwap(PlayerSwapHandItemsEvent event) {
        FabledHook fabledHook = (FabledHook)((Divinity)this.plugin).getHook("Fabled");
        if (fabledHook != null) {
            fabledHook.updateSkills(event.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onItemHeldEvent(PlayerItemHeldEvent event) {
        FabledHook fabledHook = (FabledHook)((Divinity)this.plugin).getHook("Fabled");
        if (fabledHook != null) {
            fabledHook.updateSkills(event.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onDrop(PlayerDropItemEvent event) {
        FabledHook fabledHook = (FabledHook)((Divinity)this.plugin).getHook("Fabled");
        if (fabledHook != null) {
            fabledHook.updateSkills(event.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onDrop(EntityPickupItemEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        FabledHook fabledHook = (FabledHook)((Divinity)this.plugin).getHook("Fabled");
        if (fabledHook != null) {
            fabledHook.updateSkills(player);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onArmorEquip(ArmorEquipEvent event) {
        FabledHook fabledHook = (FabledHook)((Divinity)this.plugin).getHook("Fabled");
        if (fabledHook != null) {
            fabledHook.updateSkills(event.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent event) {
        this.updateSkills((InventoryEvent)event);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onInventoryDrag(InventoryDragEvent event) {
        this.updateSkills((InventoryEvent)event);
    }

    private void updateSkills(InventoryEvent event) {
        Inventory top = VersionManager.getCompat().getTopInventory(event);
        Inventory bottom = VersionManager.getCompat().getBottomInventory(event);
        for (Inventory inventory : new Inventory[]{top, bottom}) {
            if (!(inventory instanceof PlayerInventory)) continue;
            PlayerInventory playerInventory = (PlayerInventory)inventory;
            HumanEntity humanEntity = playerInventory.getHolder();
            if (!(humanEntity instanceof Player)) {
                return;
            }
            FabledHook fabledHook = (FabledHook)((Divinity)this.plugin).getHook("Fabled");
            if (fabledHook == null) continue;
            fabledHook.updateSkills((Player)humanEntity);
        }
    }

    private boolean useItem(@NotNull Player player, @NotNull ItemStack item) {
        int uses = this.itemGen.getItemCharges(item);
        if (uses == 0) {
            if (this.registerSentMessage(player)) {
                ((Divinity)this.plugin).lang().Module_Item_Usage_NoCharges.replace("%item%", (Object)ItemUT.getItemName((ItemStack)item)).send((CommandSender)player);
            }
            return false;
        }
        if (uses > 0) {
            if (item.getAmount() > 1) {
                item.setAmount(item.getAmount() - 1);
                ItemStack reuse = new ItemStack(item);
                reuse.setAmount(1);
                this.itemGen.takeItemCharge(reuse);
                if (reuse.getType() != Material.AIR) {
                    ItemUT.addItem((Player)player, (ItemStack[])new ItemStack[]{reuse});
                }
            } else {
                this.itemGen.takeItemCharge(item);
            }
        } else {
            DurabilityStat duraStat = ItemStats.getStat(DurabilityStat.class);
            if (duraStat != null) {
                duraStat.reduceDurability((LivingEntity)player, item, 1);
            }
        }
        return true;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onItemConsumeNatural(PlayerItemConsumeEvent e) {
        ItemStack item = new ItemStack(e.getItem());
        ItemGeneratorManager.GeneratorItem aItem = (ItemGeneratorManager.GeneratorItem)this.itemGen.getModuleItem(item);
        if (aItem == null) {
            return;
        }
        Player player = e.getPlayer();
        e.setCancelled(true);
        ItemStack itemMain = player.getInventory().getItemInMainHand();
        if (!ItemUT.isAir((ItemStack)itemMain) && itemMain.isSimilar(item)) {
            this.useItem(player, itemMain);
            return;
        }
        ItemStack itemOff = player.getInventory().getItemInOffHand();
        if (!ItemUT.isAir((ItemStack)itemOff) && itemOff.isSimilar(item)) {
            this.useItem(player, itemOff);
        }
    }
}

