/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.gems;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.citizensnpcs.api.trait.TraitInfo;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.config.api.JYML;
import studio.magemonkey.codex.hooks.external.citizens.CitizensHK;
import studio.magemonkey.codex.util.DataUT;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.modules.SocketItem;
import studio.magemonkey.divinity.modules.api.socketing.ModuleSocket;
import studio.magemonkey.divinity.modules.list.gems.merchant.MerchantTrait;
import studio.magemonkey.divinity.modules.list.itemgenerator.ItemGeneratorManager;
import studio.magemonkey.divinity.modules.list.itemgenerator.generators.AbilityGenerator;
import studio.magemonkey.divinity.stats.bonus.BonusMap;
import studio.magemonkey.divinity.stats.items.ItemStats;

public class GemManager
extends ModuleSocket<Gem> {
    public GemManager(@NotNull Divinity plugin) {
        super(plugin, Gem.class);
    }

    @NotNull
    public String getId() {
        return "gems";
    }

    @NotNull
    public String version() {
        return "1.76";
    }

    public void setup() {
    }

    public void shutdown() {
    }

    @Override
    protected void onPostSetup() {
        super.onPostSetup();
        CitizensHK citizensHook = ((Divinity)this.plugin).getCitizens();
        if (citizensHook != null) {
            TraitInfo trait = TraitInfo.create(MerchantTrait.class);
            citizensHook.registerTrait((CodexPlugin)this.plugin, trait);
        }
    }

    @Override
    @NotNull
    public ItemStack insertSocket(@NotNull ItemStack item, @NotNull ItemStack src) {
        item = super.insertSocket(item, src);
        Gem gem = (Gem)this.getModuleItem(src);
        if (gem == null) {
            return item;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return item;
        }
        int gemLevel = ItemStats.getLevel(src);
        gem.applyAbilities(item, gemLevel);
        return item;
    }

    @Override
    @NotNull
    public List<ItemStack> extractSocket(@NotNull ItemStack target, @NotNull String socketId, int index) {
        List<ItemStack> items = super.extractSocket(target, socketId, index);
        if (items.size() < 2) {
            return items;
        }
        ItemStack gemItem = items.get(1);
        Gem gem = (Gem)this.getModuleItem(gemItem);
        if (gem == null) {
            return items;
        }
        ItemStack result = items.get(0);
        int gemLevel = ItemStats.getLevel(gemItem);
        gem.removeAbilities(result, gemLevel);
        return items;
    }

    public class Gem
    extends SocketItem {
        private final TreeMap<Integer, BonusMap> bonusMap;
        private final Map<Integer, List<AbilityGenerator.Ability>> abilitiesByLevel;

        public Gem(@NotNull Divinity plugin, JYML cfg) {
            super(plugin, cfg, (ModuleSocket<?>)GemManager.this);
            this.bonusMap = new TreeMap();
            this.abilitiesByLevel = new HashMap<Integer, List<AbilityGenerator.Ability>>();
            for (String sLvl : cfg.getSection("bonuses-by-level")) {
                int lvl = StringUT.getInteger((String)sLvl, (int)-1);
                if (lvl < 1) continue;
                String path = "bonuses-by-level." + sLvl + ".";
                BonusMap bMap = new BonusMap();
                bMap.loadStats(cfg, path + "item-stats");
                bMap.loadDamages(cfg, path + "damage-types");
                bMap.loadDefenses(cfg, path + "defense-types");
                this.bonusMap.put(lvl, bMap);
                ConfigurationSection skillsSection = cfg.getConfigurationSection(path + "skills");
                if (skillsSection == null) continue;
                this.loadAbilities(skillsSection, lvl);
            }
        }

        private void loadAbilities(@NotNull ConfigurationSection section, int lvl) {
            List abilities = this.abilitiesByLevel.computeIfAbsent(lvl, k -> new ArrayList());
            for (String skillId : section.getKeys(false)) {
                String path = skillId + ".";
                int skillLevel = section.getInt(path + "level", 1);
                AbilityGenerator.Ability ability = new AbilityGenerator.Ability(skillId, skillLevel, skillLevel, section.getStringList(path + "lore-format"));
                abilities.add(ability);
            }
        }

        private void applyAbilities(ItemStack item, int level) {
            List abilities = this.abilitiesByLevel.computeIfAbsent(level, k -> new ArrayList());
            if (abilities.isEmpty()) {
                return;
            }
            Map<String, AbilityGenerator.AbilityInfo> itemAbilities = AbilityGenerator.getAbilities(item);
            ArrayList<AbilityGenerator.Ability> abilitiesList = new ArrayList<AbilityGenerator.Ability>();
            for (AbilityGenerator.Ability ability : abilities) {
                String abilityId;
                if (ability == null || itemAbilities.containsKey(abilityId = ability.getId())) continue;
                itemAbilities.put(ability.getId(), new AbilityGenerator.AbilityInfo(ability.getId(), ability.getRndLevel(), "gem"));
                abilitiesList.add(ability);
            }
            int i = 0;
            String[] abilityArray = new String[itemAbilities.size()];
            for (Map.Entry<String, AbilityGenerator.AbilityInfo> entry : itemAbilities.entrySet()) {
                abilityArray[i] = entry.getKey() + ":" + entry.getValue().getLevel() + ":" + entry.getValue().getSource();
                ++i;
            }
            DataUT.setData((ItemStack)item, (NamespacedKey)AbilityGenerator.ABILITY_KEY, (Object)abilityArray);
            this.updateItemLore(item, itemAbilities, abilitiesList);
        }

        private void removeAbilities(ItemStack item, int level) {
            List<AbilityGenerator.Ability> abilities = this.abilitiesByLevel.get(level);
            if (abilities == null) {
                return;
            }
            Map<String, AbilityGenerator.AbilityInfo> itemAbilities = AbilityGenerator.getAbilities(item);
            if (itemAbilities.isEmpty()) {
                return;
            }
            ArrayList<AbilityGenerator.Ability> abilitiesList = new ArrayList<AbilityGenerator.Ability>();
            for (AbilityGenerator.Ability ability : abilities) {
                String abilityId;
                if (ability == null || !itemAbilities.containsKey(abilityId = ability.getId()) || !itemAbilities.get(abilityId).getSource().equals("gem")) continue;
                itemAbilities.remove(abilityId);
            }
            int i = 0;
            String[] abilityArray = new String[itemAbilities.size()];
            for (Map.Entry<String, AbilityGenerator.AbilityInfo> entry : itemAbilities.entrySet()) {
                abilityArray[i] = entry.getKey() + ":" + entry.getValue().getLevel() + ":" + entry.getValue().getSource();
                ++i;
            }
            DataUT.setData((ItemStack)item, (NamespacedKey)AbilityGenerator.ABILITY_KEY, (Object)abilityArray);
            this.updateItemLore(item, itemAbilities, abilitiesList);
        }

        private void updateItemLore(ItemStack item, Map<String, AbilityGenerator.AbilityInfo> itemAbilities, List<AbilityGenerator.Ability> abilitiesList) {
            ItemGeneratorManager.GeneratorItem genItem = (ItemGeneratorManager.GeneratorItem)Divinity.getInstance().getModuleCache().getTierManager().getModuleItem(item);
            if (genItem != null) {
                AbilityGenerator generator = new AbilityGenerator(Divinity.getInstance(), genItem, "%GENERATOR_SKILLS%");
                int i = 0;
                for (String s : itemAbilities.keySet()) {
                    AbilityGenerator.Ability ability = generator.getAbility(s);
                    if (ability == null) continue;
                    abilitiesList.add(i++, ability);
                }
            }
            AbilityGenerator.updateLore(item, itemAbilities, abilitiesList);
        }

        @Nullable
        public BonusMap getBonusMap(int lvl) {
            Map.Entry<Integer, BonusMap> e = this.bonusMap.floorEntry(lvl);
            if (e == null) {
                return null;
            }
            return e.getValue();
        }

        @Override
        @NotNull
        protected ItemStack build(int lvl, int uses, int suc) {
            List lore;
            ItemStack item = super.build(lvl, uses, suc);
            ItemMeta meta = item.getItemMeta();
            if (meta == null) {
                return item;
            }
            BonusMap bMap = this.getBonusMap(lvl);
            if (bMap == null) {
                return item;
            }
            if (meta.hasDisplayName()) {
                String name = bMap.replacePlaceholders(meta.getDisplayName());
                meta.setDisplayName(name);
            }
            if ((lore = meta.getLore()) != null) {
                lore.replaceAll(bMap::replacePlaceholders);
                meta.setLore(lore);
            }
            item.setItemMeta(meta);
            return item;
        }
    }
}

