/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.drops.object;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.config.api.JYML;
import studio.magemonkey.codex.hooks.external.WorldGuardHK;
import studio.magemonkey.codex.manager.LoadableItem;
import studio.magemonkey.codex.modules.IModule;
import studio.magemonkey.codex.util.EnumUT;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.codex.util.actions.ActionManipulator;
import studio.magemonkey.codex.util.random.Rnd;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.config.EngineCfg;
import studio.magemonkey.divinity.modules.api.QModuleDrop;
import studio.magemonkey.divinity.modules.list.drops.object.Drop;
import studio.magemonkey.divinity.modules.list.drops.object.DropCalculator;
import studio.magemonkey.divinity.modules.list.drops.object.DropExperience;
import studio.magemonkey.divinity.modules.list.drops.object.DropItem;
import studio.magemonkey.divinity.modules.list.drops.object.DropMoney;
import studio.magemonkey.divinity.modules.list.drops.object.DropNonItem;

public class DropTable
extends LoadableItem
implements DropCalculator {
    private final boolean penaltyLevelEnabled;
    private final int penaltyLevelVariance;
    protected String name;
    protected boolean rollOnce = true;
    protected Set<String> worldsGood;
    protected Set<String> biomesGood;
    protected Set<String> regionsBad;
    protected List<DropItem> dropList;
    protected Set<DropNonItem> nonItemDrops;

    public DropTable(@NotNull Divinity plugin, @NotNull JYML cfg) {
        super((CodexPlugin)plugin, cfg);
        String path;
        this.name = StringUT.color((String)cfg.getString("name", this.getId()));
        this.rollOnce = cfg.getBoolean("roll-once");
        this.penaltyLevelEnabled = cfg.getBoolean("level-penalty.enabled");
        this.penaltyLevelVariance = cfg.getInt("level-penalty.variance");
        this.worldsGood = new HashSet<String>(cfg.getStringList("world-whitelist"));
        this.biomesGood = new HashSet<String>(cfg.getStringList("biome-whitelist"));
        this.regionsBad = new HashSet<String>(cfg.getStringList("region-blacklist"));
        this.dropList = new ArrayList<DropItem>();
        for (String id : cfg.getSection("items")) {
            path = "items." + id + ".";
            float itemChance = (float)cfg.getDouble(path + "chance");
            String moduleId = cfg.getString(path + "module-id", "");
            IModule mod = plugin.getModuleManager().getModule(moduleId);
            if (mod == null || !mod.isLoaded() || !(mod instanceof QModuleDrop)) {
                plugin.error("Invalid module for item " + id + " in drop table " + cfg.getFile().getName());
                continue;
            }
            String itemId = cfg.getString(path + "item-id");
            if (itemId == null) {
                plugin.error("Invalid id for item " + id + " in drop table " + cfg.getFile().getName());
                continue;
            }
            String tier = cfg.getString(path + "tier-id", null);
            QModuleDrop itemModule = (QModuleDrop)mod;
            int amountMin = cfg.getInt(path + "min-amount", 1);
            int amountMax = cfg.getInt(path + "max-amount", 1);
            String levelMin = cfg.getString(path + "min-level", "-1");
            String levelMax = cfg.getString(path + "max-level", "-1");
            List dropConditions = cfg.getStringList(path + "additional-conditions");
            ActionManipulator dropActions = new ActionManipulator((CodexPlugin)plugin, cfg, path + "actions-on-drop");
            DropItem di = new DropItem(itemChance, itemModule, itemId, tier, amountMin, amountMax, levelMin, levelMax, dropConditions, dropActions);
            this.dropList.add(di);
        }
        this.nonItemDrops = new HashSet<DropNonItem>();
        for (String key : cfg.getSection("non-items")) {
            path = "non-items." + key;
            if (key.equalsIgnoreCase("money")) {
                this.nonItemDrops.add(new DropMoney(cfg.getConfigurationSection(path)));
                continue;
            }
            if (!key.equalsIgnoreCase("experience")) continue;
            this.nonItemDrops.add(new DropExperience(cfg.getConfigurationSection(path)));
        }
    }

    protected void save(@NotNull JYML cfg) {
    }

    @NotNull
    public String getGroupName() {
        return this.name;
    }

    public boolean isRollOnce() {
        return this.rollOnce;
    }

    public boolean isLevelPenalty() {
        return this.penaltyLevelEnabled && this.penaltyLevelVariance > 0;
    }

    public int getPenaltyVariance() {
        return this.penaltyLevelVariance;
    }

    @NotNull
    public Set<String> getAllowedWorlds() {
        return this.worldsGood;
    }

    @NotNull
    public Set<String> getAllowedBiomes() {
        return this.biomesGood;
    }

    @NotNull
    public Set<String> getDisallowedRegions() {
        return this.regionsBad;
    }

    @NotNull
    public List<DropItem> getDrop() {
        return this.dropList;
    }

    @NotNull
    public Set<DropNonItem> getNonItemDrops() {
        return this.nonItemDrops;
    }

    protected boolean checkForLocation(@NotNull LivingEntity npc) {
        String world = npc.getWorld().getName();
        if (!this.worldsGood.contains("*") && !this.worldsGood.contains(world)) {
            return false;
        }
        String biome = EnumUT.getName((Object)npc.getLocation().getBlock().getBiome());
        if (!this.biomesGood.contains("*") && !this.biomesGood.contains(biome)) {
            return false;
        }
        WorldGuardHK wg = this.plugin.getWorldGuard();
        if (wg != null) {
            String region = wg.getRegion((Entity)npc);
            return !this.regionsBad.contains("*") && !this.regionsBad.contains(region);
        }
        return true;
    }

    protected boolean canDrop(@NotNull LivingEntity npc) {
        Player p;
        if (!this.checkForLocation(npc)) {
            return false;
        }
        if (this.isLevelPenalty() && (p = npc.getKiller()) != null) {
            int maxDiff = this.getPenaltyVariance();
            double lvlMob = EngineCfg.HOOK_MOB_LEVEL_PLUGIN.getMobLevel((Entity)npc);
            double lvlPlayer = EngineCfg.HOOK_PLAYER_LEVEL_PLUGIN.getLevel(p);
            return !(lvlPlayer > lvlMob) || !(lvlPlayer - lvlMob >= (double)maxDiff);
        }
        return true;
    }

    @Override
    public Set<Drop> dropCalculator(@Nullable Player killer, @NotNull LivingEntity npc, float dropModifier) {
        DropItem dropItem;
        HashSet<Drop> drops = new HashSet<Drop>();
        if (this.dropList.isEmpty() || !this.canDrop(npc)) {
            return drops;
        }
        if (this.rollOnce && (dropItem = (DropItem)Rnd.get(this.dropList)) != null) {
            return dropItem.dropCalculator(killer, npc, dropModifier);
        }
        for (DropItem dropItem2 : this.dropList) {
            drops.addAll(dropItem2.dropCalculator(killer, npc, dropModifier));
        }
        return drops;
    }
}

