/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.classes.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.util.PlayerUT;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.modules.command.MCmd;
import studio.magemonkey.divinity.modules.list.classes.ClassManager;
import studio.magemonkey.divinity.modules.list.classes.api.RPGClass;

public class SetClassCmd
extends MCmd<ClassManager> {
    public SetClassCmd(@NotNull ClassManager module) {
        super(module, new String[]{"setclass"}, "quantumrpg.classes.cmd.setclass");
    }

    @NotNull
    public String description() {
        return ((Divinity)this.plugin).lang().Classes_Cmd_SetClass_Desc.getMsg();
    }

    @NotNull
    public String usage() {
        return ((Divinity)this.plugin).lang().Classes_Cmd_SetClass_Usage.getMsg();
    }

    public boolean playersOnly() {
        return false;
    }

    @NotNull
    public List<String> getTab(@NotNull Player player, int i, @NotNull String[] args) {
        if (i == 1) {
            return PlayerUT.getPlayerNames();
        }
        if (i == 2) {
            return new ArrayList<String>(((ClassManager)this.module).getClassIds());
        }
        if (i == 3) {
            return Arrays.asList("true", "false");
        }
        return super.getTab(player, i, args);
    }

    public void perform(@NotNull CommandSender sender, @NotNull String label, @NotNull String[] args) {
        if (args.length < 3) {
            this.printUsage(sender);
            return;
        }
        Player player = ((Divinity)this.plugin).getServer().getPlayer(args[1]);
        if (player == null) {
            this.errPlayer(sender);
            return;
        }
        RPGClass rpgClass = ((ClassManager)this.module).getClassById(args[2]);
        if (rpgClass == null) {
            ((Divinity)this.plugin).lang().Classes_Cmd_SetClass_Error_NoClass.send(sender);
            return;
        }
        boolean force = true;
        if (args.length >= 4) {
            force = Boolean.parseBoolean(args[3]);
        }
        ((ClassManager)this.module).setPlayerClass(player, rpgClass, force);
        ((Divinity)this.plugin).lang().Classes_Cmd_SetClass_Done.replace("%class%", (Object)rpgClass.getName()).replace("%name%", (Object)player.getName()).send(sender);
    }
}

