/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.manager.profile;

import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.config.api.JYML;
import studio.magemonkey.codex.manager.api.gui.ContentType;
import studio.magemonkey.codex.manager.api.gui.GuiClick;
import studio.magemonkey.codex.manager.api.gui.GuiItem;
import studio.magemonkey.codex.manager.api.gui.NGUI;
import studio.magemonkey.codex.util.CollectionsUT;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.data.api.DivinityUser;
import studio.magemonkey.divinity.data.api.UserEntityNamesMode;
import studio.magemonkey.divinity.data.api.UserProfile;
import studio.magemonkey.divinity.manager.profile.ProfileManager;

public class SettingsGUI
extends NGUI<Divinity> {
    private ProfileManager profileManager;

    public SettingsGUI(@NotNull ProfileManager profileManager, @NotNull JYML cfg) {
        super((CodexPlugin)((Divinity)profileManager.plugin), cfg, "");
        this.profileManager = profileManager;
        GuiClick click = (p, type, e) -> {
            if (type == null) {
                return;
            }
            Class<?> clazz = type.getClass();
            if (clazz.equals(ContentType.class)) {
                ContentType type2 = (ContentType)type;
                switch (type2) {
                    case RETURN: {
                        this.profileManager.getProfileGUI().open(p, 1);
                        break;
                    }
                    case EXIT: {
                        p.closeInventory();
                        break;
                    }
                }
                return;
            }
            if (clazz.equals(ItemType.class)) {
                ItemType type2 = (ItemType)type;
                DivinityUser user = (DivinityUser)((Divinity)this.plugin).getUserManager().getOrLoadUser(p);
                if (user == null) {
                    return;
                }
                UserProfile profile = user.getActiveProfile();
                switch (type2.ordinal()) {
                    case 0: {
                        profile.setNamesMode((UserEntityNamesMode)CollectionsUT.toggleEnum((Enum)profile.getNamesMode()));
                        break;
                    }
                    case 1: {
                        profile.setHideHelmet(!profile.isHideHelmet());
                        break;
                    }
                    default: {
                        return;
                    }
                }
                this.profileManager.getSettingsGUI().open(p, 1);
                return;
            }
        };
        for (String id : cfg.getSection("content")) {
            GuiItem guiItem = cfg.getGuiItem("content." + id, ItemType.class);
            if (guiItem == null) continue;
            if (guiItem.getType() != null) {
                guiItem.setClick(click);
            }
            this.addButton(guiItem);
        }
    }

    protected void onCreate(@NotNull Player player, @NotNull Inventory inv, int page) {
    }

    protected boolean ignoreNullClick() {
        return true;
    }

    protected boolean cancelClick(int slot) {
        return true;
    }

    protected boolean cancelPlayerClick() {
        return true;
    }

    protected void replaceMeta(@NotNull Player player, @NotNull ItemStack item, @NotNull GuiItem guiItem) {
        super.replaceMeta(player, item, guiItem);
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        List lore = meta.getLore();
        if (lore == null) {
            return;
        }
        DivinityUser user = (DivinityUser)((Divinity)this.plugin).getUserManager().getOrLoadUser(player);
        if (user == null) {
            return;
        }
        UserProfile profile = user.getActiveProfile();
        lore.replaceAll(line -> line.replace("%player-helmet%", ((Divinity)this.plugin).lang().getBool(profile.isHideHelmet())).replace("%entity-names%", ((Divinity)this.plugin).lang().getEnum(profile.getNamesMode())));
        meta.setLore(lore);
        item.setItemMeta(meta);
    }

    private static enum ItemType {
        SETTING_ENTITY_NAMES,
        SETTING_PLAYER_HELMET;

    }
}

