/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.hooks.external.mimic;

import java.util.Objects;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;
import ru.endlesscode.mimic.level.ExpLevelConverter;
import ru.endlesscode.mimic.util.ExistingWeakReference;
import studio.magemonkey.divinity.api.DivinityAPI;
import studio.magemonkey.divinity.modules.list.classes.ClassManager;
import studio.magemonkey.divinity.modules.list.classes.api.RPGClass;
import studio.magemonkey.divinity.modules.list.classes.api.UserClassData;

public class DivinityExpLevelConverter
implements ExpLevelConverter {
    private final ExistingWeakReference<Player> playerRef;
    private final ClassManager classManager;

    public DivinityExpLevelConverter(Player player) {
        this.playerRef = new ExistingWeakReference((Object)player);
        this.classManager = DivinityAPI.getModuleManager().getClassManager();
        Objects.requireNonNull(this.classManager);
    }

    public double getExpToReachLevel(int level) {
        if (level <= 0) {
            return 0.0;
        }
        RPGClass playerClass = this.getPlayerClass();
        return playerClass != null ? (double)playerClass.getNeedExpForLevel(level) : -1.0;
    }

    @Nullable
    private RPGClass getPlayerClass() {
        UserClassData userData = this.classManager.getUserData((Player)this.playerRef.get());
        return userData != null ? userData.getPlayerClass() : null;
    }
}

