/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.config;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.bukkit.Bukkit;
import org.bukkit.configuration.InvalidConfigurationException;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.config.api.JYML;
import studio.magemonkey.codex.hooks.NHook;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.hooks.HookClass;
import studio.magemonkey.divinity.hooks.HookLevel;
import studio.magemonkey.divinity.hooks.HookMobLevel;
import studio.magemonkey.divinity.hooks.internal.DefaultHook;
import studio.magemonkey.divinity.hooks.internal.DivinityHook;
import studio.magemonkey.divinity.stats.items.ItemStats;
import studio.magemonkey.divinity.stats.items.attributes.ChargesAttribute;
import studio.magemonkey.divinity.stats.items.requirements.ItemRequirements;
import studio.magemonkey.divinity.stats.items.requirements.item.ItemLevelRequirement;
import studio.magemonkey.divinity.stats.items.requirements.item.ItemModuleRequirement;
import studio.magemonkey.divinity.stats.items.requirements.item.ItemSocketRequirement;
import studio.magemonkey.divinity.stats.items.requirements.item.ItemTierRequirement;
import studio.magemonkey.divinity.stats.items.requirements.item.ItemTypeRequirement;
import studio.magemonkey.divinity.stats.items.requirements.user.BannedClassRequirement;
import studio.magemonkey.divinity.stats.items.requirements.user.ClassRequirement;
import studio.magemonkey.divinity.stats.items.requirements.user.LevelRequirement;
import studio.magemonkey.fabled.dynamic.ComponentRegistry;

public class EngineCfg {
    private Divinity plugin;
    private JYML cfg;
    public static boolean PACKETS_ENABLED;
    public static boolean PACKETS_MOD_GLOW_COLOR;
    public static boolean PACKETS_REDUCE_COMBAT_PARTICLES;
    public static HookLevel HOOK_PLAYER_LEVEL_PLUGIN;
    public static HookClass HOOK_PLAYER_CLASS_PLUGIN;
    public static HookMobLevel HOOK_MOB_LEVEL_PLUGIN;
    public static boolean ATTRIBUTES_EFFECTIVE_FOR_MOBS;
    public static boolean ATTRIBUTES_EFFECTIVE_IN_OFFHAND;
    public static boolean ATTRIBUTES_ALLOW_HOLD_REQUIREMENTS;
    public static boolean ATTRIBUTES_DURABILITY_BREAK_ITEMS;
    public static boolean ATTRIBUTES_DURABILITY_REDUCE_FOR_MOBS;
    public static Set<String> ATTRIBUTES_DURABILITY_REDUCE_FOR_SKILL_API;
    public static double COMBAT_SHIELD_BLOCK_BONUS_RATE;
    public static double COMBAT_SHIELD_BLOCK_BONUS_DAMAGE_MOD;
    public static int COMBAT_SHIELD_BLOCK_COOLDOWN;
    public static boolean LEGACY_COMBAT;
    public static boolean COMBAT_DISABLE_VANILLA_SWEEP;
    public static boolean COMBAT_REDUCE_PLAYER_HEALTH_BAR;
    public static boolean COMBAT_FISHING_HOOK_DO_DAMAGE;
    public static boolean COMBAT_BOWS_DO_FULL_MELEE_DAMAGE;
    public static double COMBAT_DAMAGE_MODIFIER_FOR_COOLDOWN;
    public static double COMBAT_MAX_GET_TARGET_DISTANCE;
    public static String LORE_CHAR_PERCENT;
    public static String LORE_CHAR_NEGATIVE;
    public static String LORE_CHAR_POSITIVE;
    public static String LORE_CHAR_MULTIPLIER;
    public static String LORE_STYLE_SEPAR_VALUE;
    public static String LORE_STYLE_SEPAR_COLOR;
    public static String LORE_STYLE_DAMAGE_FORMAT_SINGLE;
    public static String LORE_STYLE_DAMAGE_FORMAT_RANGE;
    private static String LORE_STYLE_DURA_FORMAT_NAME;
    private static String LORE_STYLE_DURA_FORMAT_UNBREAKABLE;
    private static TreeMap<Integer, String> LORE_STYLE_DURA_FORMAT_MAP;
    public static String LORE_STYLE_ATT_CHARGES_FORMAT_DEFAULT;
    public static String LORE_STYLE_ATT_CHARGES_FORMAT_UNLIMITED;
    public static boolean CHARGES_BREAK_ITEMS_ENABLED;
    public static Set<String> CHARGES_BREAK_ITEMS_STOP_MODULES;
    public static boolean LORE_STYLE_REQ_USER_DYN_UPDATE;
    private static Map<Boolean, String> LORE_STYLE_REQ_USER_DYN_STATE;
    public static String LORE_STYLE_REQ_USER_LVL_FORMAT_SINGLE;
    public static String LORE_STYLE_REQ_USER_LVL_FORMAT_RANGE;
    public static String LORE_STYLE_REQ_USER_CLASS_FORMAT_SEPAR;
    public static String LORE_STYLE_REQ_USER_CLASS_FORMAT_COLOR;
    public static int LORE_STYLE_REQ_USER_CLASS_FORMAT_MAX;
    public static String LORE_STYLE_REQ_USER_CLASS_FORMAT_NEWLINE;
    public static String LORE_STYLE_REQ_USER_BANNED_CLASS_FORMAT_SEPAR;
    public static String LORE_STYLE_REQ_USER_BANNED_CLASS_FORMAT_COLOR;
    public static int LORE_STYLE_REQ_USER_BANNED_CLASS_FORMAT_MAX;
    public static String LORE_STYLE_REQ_USER_BANNED_CLASS_FORMAT_NEWLINE;
    public static String LORE_STYLE_REQ_ITEM_LVL_FORMAT_SINGLE;
    public static String LORE_STYLE_REQ_ITEM_LVL_FORMAT_RANGE;
    public static String LORE_STYLE_REQ_ITEM_TYPE_FORMAT_SEPAR;
    public static String LORE_STYLE_REQ_ITEM_TYPE_FORMAT_COLOR;
    public static String LORE_STYLE_REQ_ITEM_MODULE_FORMAT_SEPAR;
    public static String LORE_STYLE_REQ_ITEM_MODULE_FORMAT_COLOR;
    public static String LORE_STYLE_ENCHANTMENTS_FORMAT_MAIN;
    public static int LORE_STYLE_ENCHANTMENTS_FORMAT_MAX_ROMAN;
    public static String LORE_STYLE_FABLED_ATTRIBUTE_FORMAT;

    public EngineCfg(@NotNull Divinity plugin) throws InvalidConfigurationException {
        this.plugin = plugin;
        this.cfg = JYML.loadOrExtract((CodexPlugin)plugin, (String)"engine.yml");
    }

    public void setup() {
        String rName;
        this.plugin.info("Loading engine configuration...");
        String path = "packets.";
        PACKETS_ENABLED = this.cfg.getBoolean(path + "enabled");
        PACKETS_MOD_GLOW_COLOR = this.cfg.getBoolean(path + "modules.glow-color") && this.plugin.cfg().isModuleEnabled("item_hints");
        PACKETS_REDUCE_COMBAT_PARTICLES = this.cfg.getBoolean(path + "modules.reduce-damage-particles");
        path = "compatibility.";
        DivinityHook internalHook = new DivinityHook(this.plugin);
        DefaultHook defHook = new DefaultHook();
        String pUserLevel = this.cfg.getString(path + "player-level-plugin", this.plugin.getName());
        String pUserClass = this.cfg.getString(path + "player-class-plugin", this.plugin.getName());
        if (pUserLevel.equalsIgnoreCase(this.plugin.getName()) && this.plugin.cfg().isModuleEnabled("classes")) {
            HOOK_PLAYER_LEVEL_PLUGIN = internalHook;
        } else {
            NHook hookLevel = this.plugin.getHook(pUserLevel);
            if (hookLevel instanceof HookLevel) {
                HOOK_PLAYER_LEVEL_PLUGIN = (HookLevel)hookLevel;
                this.plugin.info("Using " + hookLevel.getPlugin() + " as a player level plugin.");
            } else {
                HOOK_PLAYER_LEVEL_PLUGIN = defHook;
                this.plugin.info("Using Vanilla Exp as a player level plugin.");
            }
        }
        if (pUserClass.equalsIgnoreCase(this.plugin.getName()) && this.plugin.cfg().isModuleEnabled("classes")) {
            HOOK_PLAYER_CLASS_PLUGIN = internalHook;
        } else {
            NHook hookClass = this.plugin.getHook(pUserClass);
            if (hookClass instanceof HookClass) {
                HOOK_PLAYER_CLASS_PLUGIN = (HookClass)hookClass;
                this.plugin.info("Using " + hookClass.getPlugin() + " as a player class plugin.");
            } else {
                HOOK_PLAYER_CLASS_PLUGIN = defHook;
                this.plugin.info("Using Vault Permissions as a player class plugin.");
            }
        }
        NHook hookMobLevel = this.plugin.getHook(this.cfg.getString(path + "mob-level-plugin", "null"));
        HOOK_MOB_LEVEL_PLUGIN = hookMobLevel != null && hookMobLevel instanceof HookMobLevel ? (HookMobLevel)hookMobLevel : defHook;
        path = "performance.";
        path = "performance.entity-stats.";
        path = "attributes.";
        ATTRIBUTES_EFFECTIVE_FOR_MOBS = this.cfg.getBoolean(path + "effective-for-mobs");
        ATTRIBUTES_EFFECTIVE_IN_OFFHAND = this.cfg.getBoolean(path + "effective-in-offhand");
        ATTRIBUTES_ALLOW_HOLD_REQUIREMENTS = this.cfg.getBoolean(path + "allow-hold-items-you-cant-use");
        path = "attributes.durability.";
        ATTRIBUTES_DURABILITY_BREAK_ITEMS = this.cfg.getBoolean(path + "break-items-on-zero");
        ATTRIBUTES_DURABILITY_REDUCE_FOR_MOBS = this.cfg.getBoolean(path + "effective-for.mobs");
        Iterator<Object> skills = this.cfg.get(path + "effective-for.skill-api-skills");
        if (skills instanceof Boolean) {
            this.cfg.remove(path + "effective-for.skill-api-skills");
            this.cfg.set(path + "effective-for.skill-api-skills.cast", (Object)skills);
            this.cfg.set(path + "effective-for.skill-api-skills.left_click", (Object)skills);
            this.cfg.set(path + "effective-for.skill-api-skills.right_click", (Object)skills);
        }
        this.cfg.addMissing(path + "effective-for.skill-api-skills.initialize", (Object)false);
        this.cfg.addMissing(path + "effective-for.skill-api-skills.cleanup", (Object)false);
        if (Bukkit.getPluginManager().isPluginEnabled("Fabled")) {
            for (String triggerKey : ComponentRegistry.getTriggers().keySet()) {
                this.cfg.addMissing(path + "effective-for.skill-api-skills." + triggerKey.toLowerCase(), (Object)false);
            }
        }
        ATTRIBUTES_DURABILITY_REDUCE_FOR_SKILL_API = new HashSet<String>();
        for (String key : this.cfg.getSection(path + "effective-for.skill-api-skills")) {
            if (!this.cfg.getBoolean(path + "effective-for.skill-api-skills." + key)) continue;
            ATTRIBUTES_DURABILITY_REDUCE_FOR_SKILL_API.add(key.toLowerCase());
        }
        path = "combat.";
        LEGACY_COMBAT = this.cfg.getBoolean(path + "legacy-combat", false);
        COMBAT_DISABLE_VANILLA_SWEEP = this.cfg.getBoolean(path + "disable-vanilla-sweep-attack");
        COMBAT_REDUCE_PLAYER_HEALTH_BAR = this.cfg.getBoolean(path + "compress-player-health-bar");
        COMBAT_FISHING_HOOK_DO_DAMAGE = this.cfg.getBoolean(path + "fishing-hook-do-damage");
        COMBAT_BOWS_DO_FULL_MELEE_DAMAGE = this.cfg.getBoolean(path + "bows-do-full-melee-damage");
        COMBAT_DAMAGE_MODIFIER_FOR_COOLDOWN = this.cfg.getDouble(path + "damage-modifier-for-cooldown");
        COMBAT_MAX_GET_TARGET_DISTANCE = this.cfg.getDouble(path + "max-get-target-distance", 30.0);
        path = "combat.shield.block.";
        COMBAT_SHIELD_BLOCK_BONUS_RATE = this.cfg.getDouble(path + "block-rate-bonus", 100.0);
        COMBAT_SHIELD_BLOCK_BONUS_DAMAGE_MOD = this.cfg.getDouble(path + "block-damage-bonus", 35.0);
        COMBAT_SHIELD_BLOCK_COOLDOWN = this.cfg.getInt(path + "cooldown", 2);
        path = "lore.chars.";
        LORE_CHAR_PERCENT = StringUT.color((String)this.cfg.getString(path + "percent", "%"));
        LORE_CHAR_POSITIVE = StringUT.color((String)this.cfg.getString(path + "positive", "&a+"));
        LORE_CHAR_NEGATIVE = StringUT.color((String)this.cfg.getString(path + "negative", "&c"));
        LORE_CHAR_MULTIPLIER = StringUT.color((String)this.cfg.getString(path + "multiplier", "x"));
        path = "lore.stats.style.separator.";
        LORE_STYLE_SEPAR_VALUE = StringUT.color((String)this.cfg.getString(path + "value", "&7/"));
        LORE_STYLE_SEPAR_COLOR = StringUT.color((String)this.cfg.getString(path + "color", "&f"));
        path = "lore.stats.style.damage.";
        LORE_STYLE_DAMAGE_FORMAT_SINGLE = StringUT.color((String)this.cfg.getString(path + "format.single", "&f%value%"));
        LORE_STYLE_DAMAGE_FORMAT_RANGE = StringUT.color((String)this.cfg.getString(path + "format.double", "&f%min% &7- &f%max%"));
        path = "lore.stats.style.durability.";
        LORE_STYLE_DURA_FORMAT_MAP = new TreeMap();
        LORE_STYLE_DURA_FORMAT_NAME = this.cfg.getString(path + "format", "default");
        LORE_STYLE_DURA_FORMAT_UNBREAKABLE = StringUT.color((String)this.cfg.getString(path + "unbreakable", "&fUnbreakable"));
        for (String pId : this.cfg.getSection(path + "format-list." + LORE_STYLE_DURA_FORMAT_NAME)) {
            int perc;
            String format = this.cfg.getString(path + "format-list." + LORE_STYLE_DURA_FORMAT_NAME + "." + pId);
            if (format == null || (perc = StringUT.getInteger((String)pId, (int)-1)) < 0) continue;
            LORE_STYLE_DURA_FORMAT_MAP.put(perc, StringUT.color((String)format));
        }
        if (LORE_STYLE_DURA_FORMAT_MAP.isEmpty()) {
            LORE_STYLE_DURA_FORMAT_MAP.put(0, StringUT.color((String)"&f%current%&7/&f%max%"));
            this.plugin.error("Invalid durability format provided. Using default value.");
        }
        path = "lore.stats.style.charges.";
        this.cfg.addMissing(path + "break-items-on-zero.enabled", (Object)true);
        this.cfg.addMissing(path + "break-items-on-zero.excluded-modules", Arrays.asList("item_generator"));
        if (this.cfg.getBoolean(path + "enabled")) {
            String aName = StringUT.color((String)this.cfg.getString(path + "name", "Charges"));
            String aFormat = StringUT.color((String)this.cfg.getString(path + "format.main", "&7%name%: &f%value%"));
            LORE_STYLE_ATT_CHARGES_FORMAT_DEFAULT = StringUT.color((String)this.cfg.getString(path + "format.value.default", "&f%min%&7/&f%max%"));
            LORE_STYLE_ATT_CHARGES_FORMAT_UNLIMITED = StringUT.color((String)this.cfg.getString(path + "format.value.unlimited", "Unlimited"));
            CHARGES_BREAK_ITEMS_ENABLED = this.cfg.getBoolean(path + "break-items-on-zero.enabled", true);
            if (CHARGES_BREAK_ITEMS_ENABLED) {
                CHARGES_BREAK_ITEMS_STOP_MODULES = this.cfg.getStringSet(path + "break-items-on-zero.excluded-modules");
            }
            ChargesAttribute charges = new ChargesAttribute(aName, aFormat);
            ItemStats.registerAttribute(charges);
        }
        if (LORE_STYLE_REQ_USER_DYN_UPDATE = this.cfg.getBoolean((path = "lore.stats.style.requirements.user.dynamic.") + "enabled")) {
            LORE_STYLE_REQ_USER_DYN_STATE = new HashMap<Boolean, String>();
            for (Object b : (String)new boolean[]{true, false}) {
                String reqState = this.cfg.getString(path + "format." + (boolean)b);
                if (reqState == null) {
                    reqState = b != false ? "&a&l\u2713 &r&a" : "&c&l\u2717 &r&c";
                }
                LORE_STYLE_REQ_USER_DYN_STATE.put((boolean)b, StringUT.color((String)reqState));
            }
        }
        if (this.cfg.getBoolean((path = "lore.stats.style.requirements.user.level.") + "enabled")) {
            rName = StringUT.color((String)this.cfg.getString(path + "name", "Player Level"));
            String rFormat = StringUT.color((String)this.cfg.getString(path + "format.main", "%state%%name%: %value%"));
            LORE_STYLE_REQ_USER_LVL_FORMAT_SINGLE = StringUT.color((String)this.cfg.getString(path + "format.value.single", "%value%+"));
            LORE_STYLE_REQ_USER_LVL_FORMAT_RANGE = StringUT.color((String)this.cfg.getString(path + "format.value.range", "%min%-%max%"));
            LevelRequirement reqLvl = new LevelRequirement(rName, rFormat);
            ItemRequirements.registerUserRequirement(reqLvl);
        }
        path = "lore.stats.style.requirements.user.class.";
        this.cfg.addMissing(path + "format.max-classes-per-line", (Object)-1);
        this.cfg.addMissing(path + "format.value.newline", (Object)"&7  ");
        if (this.cfg.getBoolean(path + "enabled")) {
            rName = StringUT.color((String)this.cfg.getString(path + "name", "Player Class"));
            String rFormat = StringUT.color((String)this.cfg.getString(path + "format.main", "%state%%name%: %value%"));
            LORE_STYLE_REQ_USER_CLASS_FORMAT_SEPAR = StringUT.color((String)this.cfg.getString(path + "format.value.separator", "&7/"));
            LORE_STYLE_REQ_USER_CLASS_FORMAT_COLOR = StringUT.color((String)this.cfg.getString(path + "format.value.color", "&f"));
            LORE_STYLE_REQ_USER_CLASS_FORMAT_MAX = this.cfg.getInt(path + "format.max-classes-per-line", -1);
            LORE_STYLE_REQ_USER_CLASS_FORMAT_NEWLINE = StringUT.color((String)this.cfg.getString(path + "format.value.newline", "&7  "));
            ClassRequirement reqClass = new ClassRequirement(rName, rFormat);
            ItemRequirements.registerUserRequirement(reqClass);
        }
        path = "lore.stats.style.requirements.user.banned-class.";
        this.cfg.addMissing(path + "enabled", (Object)true);
        this.cfg.addMissing(path + "name", (Object)"Banned Player Class");
        this.cfg.addMissing(path + "format.main", (Object)"%state%%name%: %value%");
        this.cfg.addMissing(path + "format.value.separator", (Object)"&7/");
        this.cfg.addMissing(path + "format.value.color", (Object)"&f");
        this.cfg.addMissing(path + "format.max-classes-per-line", (Object)-1);
        this.cfg.addMissing(path + "format.value.newline", (Object)"&7  ");
        if (this.cfg.getBoolean(path + "enabled")) {
            rName = StringUT.color((String)this.cfg.getString(path + "name", "Banned Player Class"));
            String rFormat = StringUT.color((String)this.cfg.getString(path + "format.main", "%state%%name%: %value%"));
            LORE_STYLE_REQ_USER_BANNED_CLASS_FORMAT_SEPAR = StringUT.color((String)this.cfg.getString(path + "format.value.separator", "&7/"));
            LORE_STYLE_REQ_USER_BANNED_CLASS_FORMAT_COLOR = StringUT.color((String)this.cfg.getString(path + "format.value.color", "&f"));
            LORE_STYLE_REQ_USER_BANNED_CLASS_FORMAT_MAX = this.cfg.getInt(path + "format.max-classes-per-line", 4);
            LORE_STYLE_REQ_USER_BANNED_CLASS_FORMAT_NEWLINE = StringUT.color((String)this.cfg.getString(path + "format.value.newline", "&7  "));
            BannedClassRequirement bannedClass = new BannedClassRequirement(rName, rFormat);
            ItemRequirements.registerUserRequirement(bannedClass);
        }
        if (this.cfg.getBoolean((path = "lore.stats.style.requirements.item.level.") + "enabled")) {
            rName = StringUT.color((String)this.cfg.getString(path + "name", "Item Level"));
            String rFormat = StringUT.color((String)this.cfg.getString(path + "format.main", "&c\u25b8 %name%: %value%"));
            LORE_STYLE_REQ_ITEM_LVL_FORMAT_SINGLE = StringUT.color((String)this.cfg.getString(path + "format.value.single", "%value%+"));
            LORE_STYLE_REQ_ITEM_LVL_FORMAT_RANGE = StringUT.color((String)this.cfg.getString(path + "format.value.range", "%min%-%max%"));
            ItemLevelRequirement reqLevel = new ItemLevelRequirement(rName, rFormat);
            ItemRequirements.registerItemRequirement(reqLevel);
        }
        if (this.cfg.getBoolean((path = "lore.stats.style.requirements.item.type.") + "enabled")) {
            rName = StringUT.color((String)this.cfg.getString(path + "name", "Item Type"));
            String rFormat = StringUT.color((String)this.cfg.getString(path + "format.main", "&c\u25b8 %name%: %value%"));
            LORE_STYLE_REQ_ITEM_TYPE_FORMAT_SEPAR = StringUT.color((String)this.cfg.getString(path + "format.value.separator", "&7/"));
            LORE_STYLE_REQ_ITEM_TYPE_FORMAT_COLOR = StringUT.color((String)this.cfg.getString(path + "format.value.color", "&f"));
            ItemTypeRequirement reqClass = new ItemTypeRequirement(rName, rFormat);
            ItemRequirements.registerItemRequirement(reqClass);
        }
        if (this.cfg.getBoolean((path = "lore.stats.style.requirements.item.module.") + "enabled")) {
            rName = StringUT.color((String)this.cfg.getString(path + "name", "Item Module"));
            String rFormat = StringUT.color((String)this.cfg.getString(path + "format.main", "&c\u25b8 %name%: %value%"));
            LORE_STYLE_REQ_ITEM_MODULE_FORMAT_SEPAR = StringUT.color((String)this.cfg.getString(path + "format.value.separator", "&7/"));
            LORE_STYLE_REQ_ITEM_MODULE_FORMAT_COLOR = StringUT.color((String)this.cfg.getString(path + "format.value.color", "&f"));
            ItemModuleRequirement reqModule = new ItemModuleRequirement(rName, rFormat);
            ItemRequirements.registerItemRequirement(reqModule);
        }
        path = "lore.stats.style.requirements.item.socket.";
        if (this.plugin.cfg().isModuleEnabled("gems") || this.plugin.cfg().isModuleEnabled("essences") || this.plugin.cfg().isModuleEnabled("runes")) {
            rName = StringUT.color((String)this.cfg.getString(path + "name", "Socket"));
            String rFormat = StringUT.color((String)this.cfg.getString(path + "format.main", "&c\u25b8 %name%: %value%"));
            ItemSocketRequirement reqSOcket = new ItemSocketRequirement(rName, rFormat);
            ItemRequirements.registerItemRequirement(reqSOcket);
        }
        path = "lore.stats.style.requirements.item.tier.";
        this.cfg.addMissing(path + "enabled", (Object)true);
        this.cfg.addMissing(path + "name", (Object)"Tier");
        this.cfg.addMissing(path + "format.main", (Object)"&c\u25b8 %name%: %value%");
        if (this.cfg.getBoolean(path + "enabled")) {
            rName = StringUT.color((String)this.cfg.getString(path + "name", "Tier"));
            String rFormat = StringUT.color((String)this.cfg.getString(path + "format.main", "&c\u25b8 %name%: %value%"));
            ItemTierRequirement tierRequirement = new ItemTierRequirement(rName, rFormat);
            ItemRequirements.registerItemRequirement(tierRequirement);
        }
        path = "lore.stats.style.enchantments.";
        this.cfg.addMissing(path + "format.main", (Object)"&c\u25b8 %name% %value%");
        this.cfg.addMissing(path + "format.max-roman", (Object)10);
        LORE_STYLE_ENCHANTMENTS_FORMAT_MAIN = StringUT.color((String)this.cfg.getString(path + "format.main", "&c\u25b8 %name% %value%"));
        LORE_STYLE_ENCHANTMENTS_FORMAT_MAX_ROMAN = this.cfg.getInt(path + "format.max-roman", 10);
        path = "lore.stats.style.fabled-attribute-format";
        this.cfg.addMissing(path, (Object)"&7%attrPre%&3%name%&7%attrPost%");
        LORE_STYLE_FABLED_ATTRIBUTE_FORMAT = StringUT.color((String)this.cfg.getString(path, "&7%attrPre%&3%name%&7%attrPost%"));
        this.cfg.saveChanges();
    }

    @NotNull
    public static String getDurabilityFormat(int current, int max) {
        if (current < 0) {
            return LORE_STYLE_DURA_FORMAT_UNBREAKABLE;
        }
        int percent = (int)((double)current / (double)max * 100.0);
        String best = LORE_STYLE_DURA_FORMAT_MAP.floorEntry(percent).getValue();
        return best.replace("%max%", String.valueOf(max)).replace("%current%", String.valueOf(current)).replace("%percent%", String.valueOf(percent));
    }

    @NotNull
    public static String getDynamicRequirementState(boolean b) {
        if (!LORE_STYLE_REQ_USER_DYN_UPDATE) {
            throw new IllegalStateException("Dynamic Lore Requirements update is disabled! (#030)");
        }
        return LORE_STYLE_REQ_USER_DYN_STATE.get(b);
    }

    static {
        LORE_STYLE_REQ_USER_DYN_UPDATE = true;
    }
}

