/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.repair;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.citizensnpcs.api.trait.TraitInfo;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.commands.api.ISubCommand;
import studio.magemonkey.codex.config.api.JYML;
import studio.magemonkey.codex.hooks.external.VaultHK;
import studio.magemonkey.codex.hooks.external.citizens.CitizensHK;
import studio.magemonkey.codex.manager.api.ClickType;
import studio.magemonkey.codex.util.ItemUT;
import studio.magemonkey.codex.util.PlayerUT;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.codex.util.actions.ActionManipulator;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.modules.LimitedItem;
import studio.magemonkey.divinity.modules.api.QModuleDrop;
import studio.magemonkey.divinity.modules.list.repair.AnvilGUI;
import studio.magemonkey.divinity.modules.list.repair.RepairTrait;
import studio.magemonkey.divinity.modules.list.repair.command.RepairOpenCmd;
import studio.magemonkey.divinity.stats.items.ItemStats;
import studio.magemonkey.divinity.stats.items.attributes.api.TypedStat;
import studio.magemonkey.divinity.stats.items.attributes.stats.DurabilityStat;

public class RepairManager
extends QModuleDrop<RepairItem> {
    private AnvilGUI gui;
    private ClickType anvilUseAction;
    private boolean materialsIgnoreMeta;
    private Map<String, MaterialGroup> materialGroups;
    private Map<String, MaterialTable> materialTables;
    ActionManipulator actionsComplete;
    ActionManipulator actionsError;
    private VaultHK vaultHook;
    DurabilityStat duraStat;

    public RepairManager(@NotNull Divinity plugin) {
        super(plugin, RepairItem.class);
    }

    @NotNull
    public String getId() {
        return "repair";
    }

    @NotNull
    public String version() {
        return "1.7.0";
    }

    public void setup() {
        this.duraStat = ItemStats.getStat(DurabilityStat.class);
        if (this.duraStat == null) {
            this.interruptLoad();
            this.error("Durability Stat is not registered. Module will be disabled.");
            return;
        }
        this.vaultHook = ((Divinity)this.plugin).getVault();
        this.actionsComplete = new ActionManipulator((CodexPlugin)this.plugin, this.cfg, "repair.actions-complete");
        this.actionsError = new ActionManipulator((CodexPlugin)this.plugin, this.cfg, "repair.actions-error");
        String path = "anvil.";
        if (this.cfg.getBoolean(path + "enabled", true)) {
            try {
                this.anvilUseAction = ClickType.valueOf((String)this.cfg.getString(path + "open-action", "SHIFT_RIGHT"));
            }
            catch (IllegalArgumentException ex) {
                this.anvilUseAction = ClickType.SHIFT_RIGHT;
            }
        }
        for (RepairType repairType : RepairType.values()) {
            if (!this.cfg.getBoolean("repair.types." + repairType.name() + ".enabled")) {
                repairType.setEnabled(false);
                continue;
            }
            if (repairType == RepairType.VAULT && (this.vaultHook == null || this.vaultHook.getEconomy() == null)) continue;
            double typeCost = this.cfg.getDouble("repair.types." + repairType.name() + ".cost-per-unit", 1.0);
            repairType.setEnabled(true);
            repairType.setCost(typeCost);
        }
        if (RepairType.MATERIAL.isEnabled()) {
            path = "repair.materials.";
            this.materialsIgnoreMeta = this.cfg.getBoolean(path + "ignore-items-with-meta");
            this.materialGroups = new HashMap<String, MaterialGroup>();
            for (String id : this.cfg.getSection(path + "materials-group")) {
                String path2 = path + "materials-group." + id;
                HashSet<Material> mats = new HashSet<Material>();
                for (String matName : this.cfg.getStringList(path2)) {
                    Material material = Material.getMaterial((String)matName.toUpperCase());
                    if (material == null) {
                        this.error("Invalid material '" + matName + "' in material group '" + id + "' !");
                        continue;
                    }
                    mats.add(material);
                }
                MaterialGroup mg = new MaterialGroup(id, mats);
                this.materialGroups.put(mg.getId(), mg);
            }
            this.materialTables = new HashMap<String, MaterialTable>();
            for (String id : this.cfg.getSection(path + "materials-table")) {
                String path2 = path + "materials-table." + id + ".";
                if (!this.materialGroups.containsKey(id.toLowerCase())) {
                    this.error("Invalid material group '" + id + "' in materials table!");
                    continue;
                }
                String name = StringUT.color((String)this.cfg.getString(path2 + "name", id));
                HashSet<String> mats = new HashSet<String>(this.cfg.getStringList(path2 + "can-repair"));
                MaterialTable mt = new MaterialTable(id, name, mats);
                this.materialTables.put(mt.getId(), mt);
            }
        }
        this.gui = new AnvilGUI(this);
        this.moduleCommand.addSubCommand((ISubCommand)new RepairOpenCmd(this));
        CitizensHK citi = ((Divinity)this.plugin).getCitizens();
        if (citi != null) {
            TraitInfo trait = TraitInfo.create(RepairTrait.class).withName("repair");
            citi.registerTrait((CodexPlugin)this.plugin, trait);
        }
    }

    public void shutdown() {
        if (this.gui != null) {
            this.gui.shutdown();
            this.gui = null;
        }
        if (this.materialGroups != null) {
            this.materialGroups.clear();
            this.materialGroups = null;
        }
        if (this.materialTables != null) {
            this.materialTables.clear();
            this.materialTables = null;
        }
        this.actionsComplete = null;
        this.actionsError = null;
    }

    public boolean openAnvilGUI(@NotNull Player player, @Nullable ItemStack target, @Nullable ItemStack src, @Nullable RepairType type, boolean isForce) {
        if (!isForce && !player.hasPermission("quantumrpg.repair.gui")) {
            ((Divinity)this.plugin).lang().Error_NoPerm.send((CommandSender)player);
            return false;
        }
        if (target != null && target.getType() != Material.AIR) {
            if (!ItemStats.hasStat(target, null, TypedStat.Type.DURABILITY)) {
                ((Divinity)this.plugin).lang().Repair_Error_NoDurability.replace("%item%", (Object)ItemUT.getItemName((ItemStack)target)).send((CommandSender)player);
                return false;
            }
            if (!this.duraStat.isDamaged(target)) {
                ((Divinity)this.plugin).lang().Repair_Error_NotDamaged.replace("%item%", (Object)ItemUT.getItemName((ItemStack)target)).send((CommandSender)player);
                return false;
            }
            this.splitDragItem(player, null, target);
        }
        this.gui.open(player, target, src, type);
        return true;
    }

    @NotNull
    ItemStack getResult(@NotNull ItemStack target, @NotNull Player player) {
        double[] arr = (double[])this.duraStat.getRaw(target);
        if (arr == null) {
            return target;
        }
        double max = arr[1];
        ItemStack result = new ItemStack(target);
        this.duraStat.add(result, new double[]{max, max}, -1);
        return result;
    }

    @Nullable
    private MaterialGroup getMaterialGroup(@NotNull ItemStack item) {
        String itemType = item.getType().name();
        for (MaterialTable matTable : this.getMaterialTables().values()) {
            Set<String> tableMaterials = matTable.getMaterials();
            for (String tableMaterial : tableMaterials) {
                String materialPrefix;
                if (!(tableMaterial.endsWith("*") ? itemType.startsWith(materialPrefix = tableMaterial.replace("*", "").toUpperCase()) : (tableMaterial.startsWith("*") ? itemType.endsWith(materialPrefix = tableMaterial.replace("*", "").toUpperCase()) : itemType.equalsIgnoreCase(tableMaterial.toUpperCase())))) continue;
                return this.getMaterialGroup(matTable.getId());
            }
        }
        return null;
    }

    @NotNull
    public String getMaterialName(@NotNull ItemStack item) {
        MaterialTable materialTable;
        if (!RepairType.MATERIAL.isEnabled()) {
            return ((Divinity)this.plugin).lang().getEnum((Enum)item.getType());
        }
        MaterialGroup materialGroup = this.getMaterialGroup(item);
        if (materialGroup != null && (materialTable = this.getMaterialTable(materialGroup.getId())) != null) {
            return materialTable.getName();
        }
        return ItemUT.getItemName((ItemStack)item);
    }

    private int getPlayerMaterials(@NotNull Player player, @NotNull MaterialGroup group) {
        int have = 0;
        Set<Material> mats = group.getMaterials();
        for (ItemStack item : player.getInventory().getContents()) {
            if (ItemUT.isAir((ItemStack)item) || this.isMaterialMetaIgnored() && item.hasItemMeta() || !mats.contains(item.getType())) continue;
            have += item.getAmount();
        }
        return have;
    }

    private void takeMaterials(@NotNull Player player, @NotNull MaterialGroup group, int cost) {
        Set<Material> mats = group.getMaterials();
        for (ItemStack item : player.getInventory().getContents()) {
            if (ItemUT.isAir((ItemStack)item) || this.isMaterialMetaIgnored() && item.hasItemMeta() || !mats.contains(item.getType())) continue;
            int a = item.getAmount();
            if (a > cost) {
                item.setAmount(a - cost);
                return;
            }
            item.setAmount(0);
            if ((cost -= a) > 0) continue;
            return;
        }
    }

    public int calcCost(@NotNull ItemStack item, @Nullable RepairType type) {
        int cost = 0;
        if (type == null) {
            return cost;
        }
        double[] arr = (double[])this.duraStat.getRaw(item);
        if (arr == null) {
            return cost;
        }
        double d1 = arr[0];
        double d2 = arr[1];
        double value = type.getCostPerUnit();
        double get = value * (d2 - d1);
        cost = (int)get;
        return Math.max(1, cost);
    }

    boolean payForRepair(@NotNull Player player, @NotNull RepairType type, @NotNull ItemStack item) {
        int pay = this.calcCost(item, type);
        if (this.getPlayerBalance(player, type, item) < pay) {
            return false;
        }
        if (type == RepairType.EXP) {
            PlayerUT.setExp((Player)player, (long)(-pay));
        } else if (type == RepairType.MATERIAL) {
            MaterialGroup mg = this.getMaterialGroup(item);
            if (mg == null) {
                return false;
            }
            this.takeMaterials(player, mg, pay);
        } else if (type == RepairType.VAULT) {
            this.vaultHook.take((OfflinePlayer)player, (double)pay);
        }
        return true;
    }

    public int getPlayerBalance(@NotNull Player player, @Nullable RepairType type, @NotNull ItemStack item) {
        if (type == null || !type.isEnabled()) {
            return 0;
        }
        if (type == RepairType.EXP) {
            return PlayerUT.getTotalExperience((Player)player);
        }
        if (type == RepairType.MATERIAL) {
            MaterialGroup mg = this.getMaterialGroup(item);
            if (mg != null) {
                return this.getPlayerMaterials(player, mg);
            }
        } else if (type == RepairType.VAULT) {
            return (int)this.vaultHook.getBalance((OfflinePlayer)player);
        }
        return 0;
    }

    @Override
    protected boolean onDragDrop(@NotNull Player player, @NotNull ItemStack src, @NotNull ItemStack target, @NotNull RepairItem rTool, @NotNull InventoryClickEvent e) {
        double[] arr = (double[])this.duraStat.getRaw(target);
        if (arr == null || !ItemStats.hasStat(target, null, TypedStat.Type.DURABILITY)) {
            return false;
        }
        if (!this.duraStat.isDamaged(target)) {
            ((Divinity)this.plugin).lang().Repair_Error_NotDamaged.replace("%item%", (Object)ItemUT.getItemName((ItemStack)target)).send((CommandSender)player);
            return false;
        }
        int rLvl = ItemStats.getLevel(src);
        int rPerc = rTool.getRepairPercent(rLvl);
        this.takeChargeClickEvent(player, src, e);
        ItemStack lost = null;
        if (target.getAmount() > 1) {
            lost = new ItemStack(target);
            lost.setAmount(target.getAmount() - 1);
            target.setAmount(1);
        }
        double durMax = arr[1];
        double durNow = arr[0];
        durNow = (int)Math.min(durMax, durNow + durMax * 1.0 * ((double)rPerc * 1.0 / 100.0));
        this.duraStat.add(target, new double[]{durNow, durMax}, -1);
        e.setCurrentItem(target);
        if (lost != null) {
            ItemUT.addItem((Player)player, (ItemStack[])new ItemStack[]{lost});
        }
        return true;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onRepairAnvilUse(PlayerInteractEvent e) {
        Player player;
        if (this.anvilUseAction == null) {
            return;
        }
        if (e.useItemInHand() == Event.Result.DENY) {
            return;
        }
        if (e.useInteractedBlock() == Event.Result.DENY) {
            return;
        }
        if (e.getAction() == Action.PHYSICAL) {
            return;
        }
        Block block = e.getClickedBlock();
        if (block == null || !this.isAnvil(block.getType())) {
            return;
        }
        Action action = e.getAction();
        ClickType type = ClickType.from((Action)action, (boolean)(player = e.getPlayer()).isSneaking());
        if (type == this.anvilUseAction) {
            ItemStack i = player.getInventory().getItemInMainHand();
            e.setUseInteractedBlock(Event.Result.DENY);
            e.setUseItemInHand(Event.Result.DENY);
            e.setCancelled(true);
            if (e.getHand() == EquipmentSlot.OFF_HAND) {
                return;
            }
            this.openAnvilGUI(player, i, new ItemStack(Material.ANVIL), null, false);
        }
    }

    public boolean isAnvil(Material material) {
        switch (material) {
            case ANVIL: 
            case CHIPPED_ANVIL: 
            case DAMAGED_ANVIL: {
                return true;
            }
        }
        return false;
    }

    public boolean isMaterialMetaIgnored() {
        return this.materialsIgnoreMeta;
    }

    @NotNull
    public Map<String, MaterialGroup> getMaterialGroups() {
        return this.materialGroups;
    }

    @NotNull
    public Map<String, MaterialTable> getMaterialTables() {
        return this.materialTables;
    }

    @Nullable
    public MaterialGroup getMaterialGroup(@NotNull String id) {
        return this.materialGroups.get(id.toLowerCase());
    }

    @Nullable
    public MaterialTable getMaterialTable(@NotNull String id) {
        return this.materialTables.get(id.toLowerCase());
    }

    public class RepairItem
    extends LimitedItem {
        private TreeMap<Integer, Integer> repairLvl;

        public RepairItem(@NotNull Divinity plugin, JYML cfg) {
            super(plugin, cfg, RepairManager.this);
            this.repairLvl = new TreeMap();
            for (String sLvl : cfg.getSection("repair-by-level")) {
                int lvl = StringUT.getInteger((String)sLvl, (int)-1);
                if (lvl < 1) continue;
                int amount = cfg.getInt("repair-by-level." + sLvl);
                this.repairLvl.put(lvl, amount);
            }
        }

        @Override
        @NotNull
        protected ItemStack build(int lvl, int uses) {
            List lore;
            ItemStack item = super.build(lvl, uses);
            if (item.getType() == Material.AIR) {
                return item;
            }
            String strRepair = String.valueOf(this.getRepairPercent(lvl));
            ItemMeta meta = item.getItemMeta();
            if (meta == null) {
                return item;
            }
            if (meta.hasDisplayName()) {
                meta.setDisplayName(meta.getDisplayName().replace("%repair%", strRepair));
            }
            if ((lore = meta.getLore()) != null) {
                for (int i = 0; i < lore.size(); ++i) {
                    lore.set(i, ((String)lore.get(i)).replace("%repair%", strRepair));
                }
                meta.setLore(lore);
            }
            item.setItemMeta(meta);
            return item;
        }

        public int getRepairPercent(int toolLvl) {
            Map.Entry<Integer, Integer> e = this.repairLvl.floorEntry(toolLvl);
            if (e == null) {
                return 0;
            }
            return e.getValue();
        }
    }

    public static enum RepairType {
        EXP,
        MATERIAL,
        VAULT;

        private boolean enabled = false;
        private double cost = 0.0;

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setCost(double cost) {
            this.cost = cost;
        }

        public double getCostPerUnit() {
            return this.cost;
        }
    }

    public class MaterialGroup {
        private String id;
        private Set<Material> materials;

        public MaterialGroup(@NotNull String id, Set<Material> mats) {
            this.id = id.toLowerCase();
            this.materials = mats;
        }

        @NotNull
        public String getId() {
            return this.id;
        }

        @NotNull
        public Set<Material> getMaterials() {
            return this.materials;
        }
    }

    public class MaterialTable {
        private String id;
        private String name;
        private Set<String> materials;

        public MaterialTable(@NotNull String id, @NotNull String name, Set<String> mats) {
            this.id = id.toLowerCase();
            this.name = name;
            this.materials = mats;
        }

        @NotNull
        public String getId() {
            return this.id;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public Set<String> getMaterials() {
            return this.materials;
        }
    }
}

