/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.loot;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Rotatable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.compat.VersionManager;
import studio.magemonkey.codex.hooks.Hooks;
import studio.magemonkey.codex.hooks.external.WorldGuardHK;
import studio.magemonkey.codex.manager.api.task.ITask;
import studio.magemonkey.codex.util.EffectUT;
import studio.magemonkey.codex.util.LocUT;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.codex.util.random.Rnd;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.hooks.external.mythicmobs.AbstractMythicMobsHK;
import studio.magemonkey.divinity.modules.api.QModule;
import studio.magemonkey.divinity.modules.list.loot.LootHolder;
import studio.magemonkey.divinity.modules.list.party.PartyManager;
import studio.magemonkey.divinity.modules.list.party.event.PlayerLeavePartyEvent;

public class LootManager
extends QModule {
    private boolean generalProtectDrop;
    private boolean airOnly;
    private int generalTimeToLoot;
    private Set<String> generalEntityBlack;
    private Set<String> generalMythicBlack;
    private Set<String> generalWorldBlack;
    private Set<String> generalRegionBlack;
    private Set<String> generalSpawnReasonBlack;
    private Set<String> generalDeathCauseBlack;
    private String boxSkullHash;
    private String boxParticleStatic;
    private String boxParticleDespawn;
    boolean boxHoloEnabled;
    private List<String> boxHoloText;
    int partyDropRollTime;
    private Map<Location, LootHolder> loots;
    private LootTask taskLoot;
    private AbstractMythicMobsHK mmHook;
    private static final String META_SPAWN_REASON = "QRPG_META_SPAWN_REASON";

    public LootManager(@NotNull Divinity plugin) {
        super(plugin);
    }

    @NotNull
    public String getId() {
        return "loot";
    }

    @NotNull
    public String version() {
        return "1.04";
    }

    public void setup() {
        this.cfg.addMissing("general.death-cause-blacklist", Arrays.asList("LAVA"));
        String path = "general.";
        this.generalProtectDrop = this.cfg.getBoolean(path + "protect-drop");
        this.airOnly = this.cfg.getBoolean(path + "air-only");
        this.generalTimeToLoot = this.cfg.getInt(path + "time-to-loot");
        this.generalEntityBlack = this.cfg.getStringSet(path + "entity-blacklist");
        this.generalMythicBlack = this.cfg.getStringSet(path + "mythic-blacklist");
        this.generalWorldBlack = this.cfg.getStringSet(path + "world-blacklist");
        this.generalRegionBlack = this.cfg.getStringSet(path + "region-blacklist");
        this.generalSpawnReasonBlack = this.cfg.getStringSet(path + "spawn-reason-blacklist");
        this.generalDeathCauseBlack = this.cfg.getStringSet(path + "death-cause-blacklist");
        path = "lootbox.";
        this.boxSkullHash = this.cfg.getString(path + "skull-hash");
        this.boxParticleStatic = this.cfg.getString(path + "particles.static");
        this.boxParticleDespawn = this.cfg.getString(path + "particles.despawn");
        this.boxHoloEnabled = this.cfg.getBoolean(path + "holograms.enabled") && Hooks.hasPlugin((String)"HolographicDisplays");
        this.boxHoloText = StringUT.color((List)this.cfg.getStringList(path + "holograms.text"));
        path = "party.drop-modes.";
        this.partyDropRollTime = this.cfg.getInt(path + "roll-time");
        this.loots = new HashMap<Location, LootHolder>();
        this.taskLoot = new LootTask((Divinity)this.plugin);
        this.taskLoot.start();
        this.mmHook = (AbstractMythicMobsHK)((Divinity)this.plugin).getHook(AbstractMythicMobsHK.class);
        this.cfg.saveChanges();
    }

    public void shutdown() {
        if (this.taskLoot != null) {
            this.taskLoot.stop();
            this.taskLoot = null;
        }
        for (Location l : new HashMap<Location, LootHolder>(this.loots).keySet()) {
            this.despawnLoot(l);
        }
        this.loots.clear();
        this.loots = null;
    }

    public boolean isDropProtect() {
        return this.generalProtectDrop;
    }

    public int getLootTime() {
        return this.generalTimeToLoot;
    }

    @NotNull
    public List<String> getHoloText() {
        return this.boxHoloText;
    }

    public boolean spawnLoot(@Nullable LivingEntity killer, @NotNull LivingEntity dead, @NotNull List<ItemStack> loot) {
        if (!this.isApplicable(dead)) {
            return false;
        }
        Location boxLoc = this.findLocation(dead.getLocation());
        if (boxLoc == null) {
            return false;
        }
        Block block = boxLoc.getBlock();
        block.setType(Material.PLAYER_HEAD);
        ArrayList<BlockFace> faces = new ArrayList<BlockFace>(Arrays.asList(BlockFace.values()));
        faces.remove(BlockFace.DOWN);
        faces.remove(BlockFace.UP);
        faces.remove(BlockFace.SELF);
        BlockData data = block.getBlockData();
        if (data instanceof Rotatable) {
            Rotatable directional = (Rotatable)data;
            BlockFace face = (BlockFace)Rnd.get(faces);
            directional.setRotation(face != null ? face : BlockFace.EAST);
            block.setBlockData((BlockData)directional);
        }
        VersionManager.getNms().changeSkull(block, this.boxSkullHash);
        LootHolder lootHolder = new LootHolder(this, boxLoc, killer, dead, loot);
        this.loots.putIfAbsent(boxLoc, lootHolder);
        return true;
    }

    @Nullable
    private Location findLocation(@NotNull Location from) {
        World world = from.getWorld();
        if (world == null) {
            return null;
        }
        Location loc = LocUT.getFirstGroundBlock((Location)from.clone(), (boolean)this.airOnly);
        Block block = loc.getBlock();
        while (!block.isEmpty() && (this.airOnly && !block.getType().isAir() || !this.airOnly && block.getType().isSolid()) || this.isLootBox(block.getLocation())) {
            loc = Rnd.nextBoolean() ? loc.add(1.0, 0.0, 0.0) : loc.add(0.0, 0.0, 1.0);
            block = loc.getBlock();
            if (block.isEmpty() || !block.getType().isSolid()) continue;
            block = world.getHighestBlockAt(loc);
        }
        return block.getLocation();
    }

    public void despawnLoot(@NotNull Location loc) {
        LootHolder holder = this.loots.remove(loc);
        if (holder == null) {
            return;
        }
        holder.shutdown();
        loc.getBlock().setType(Material.AIR);
        EffectUT.playEffect((Location)LocUT.getCenter((Location)loc, (boolean)false), (String)this.boxParticleDespawn, (double)0.1f, (double)0.1f, (double)0.1f, (double)0.1f, (int)30);
    }

    public boolean isApplicable(@NotNull LivingEntity entity) {
        Set<String> black;
        EntityDamageEvent e2;
        Set<String> black2;
        if (entity.hasMetadata(META_SPAWN_REASON)) {
            return false;
        }
        if (!this.generalWorldBlack.isEmpty()) {
            String worldName = entity.getWorld().getName();
            black2 = this.generalWorldBlack;
            if (black2.contains("*") || black2.contains(worldName)) {
                return false;
            }
        }
        if (!this.generalDeathCauseBlack.isEmpty() && (e2 = entity.getLastDamageCause()) != null) {
            String cause = e2.getCause().name();
            black = this.generalDeathCauseBlack;
            if (black.contains("*") || black.contains(cause)) {
                return false;
            }
        }
        boolean mythic = false;
        if (!this.generalMythicBlack.isEmpty() && this.mmHook != null && this.mmHook.isMythicMob((Entity)entity)) {
            String mobId = this.mmHook.getMythicNameByEntity((Entity)entity);
            black = this.generalMythicBlack;
            if (black.contains("*") || black.contains(mobId)) {
                return false;
            }
            mythic = true;
        }
        if (!mythic && !this.generalEntityBlack.isEmpty() && ((black2 = this.generalEntityBlack).contains("*") || black2.contains(entity.getType().name()))) {
            return false;
        }
        WorldGuardHK wg = ((Divinity)this.plugin).getWorldGuard();
        if (!this.generalRegionBlack.isEmpty() && wg != null) {
            String regionId = wg.getRegion((Entity)entity);
            Set<String> black3 = this.generalRegionBlack;
            if (!regionId.isEmpty() && black3.contains("*") || black3.contains(regionId)) {
                return false;
            }
        }
        return true;
    }

    @Nullable
    public LootHolder.RollTask getPartyRollTask(@NotNull Player player) {
        PartyManager manager = ((Divinity)this.plugin).getModuleCache().getPartyManager();
        if (manager == null) {
            return null;
        }
        PartyManager.PartyMember member = manager.getPartyMember(player);
        if (member == null) {
            return null;
        }
        PartyManager.Party party = member.getParty();
        for (LootHolder loot : this.loots.values()) {
            PartyManager.PartyMember roller;
            LootHolder.RollTask rollTask = loot.getRollTask();
            if (rollTask == null || (roller = manager.getPartyMember(rollTask.roller)) == null || !party.isMember(roller)) continue;
            return rollTask;
        }
        return null;
    }

    public boolean isLootBox(@NotNull Location loc) {
        return this.loots.containsKey(loc) && loc.getBlock().getType() == Material.PLAYER_HEAD;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onLootBreak(BlockBreakEvent e) {
        Block block = e.getBlock();
        Location loc = block.getLocation();
        if (this.isLootBox(loc)) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onLootExplode(EntityExplodeEvent e) {
        e.blockList().removeIf(b -> this.isLootBox(b.getLocation()));
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onLootExplode2(BlockExplodeEvent e) {
        e.blockList().removeIf(b -> this.isLootBox(b.getLocation()));
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onLootLiquid(BlockFromToEvent e) {
        Block block = e.getToBlock();
        if (this.isLootBox(block.getLocation())) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onLootExtend(BlockPistonExtendEvent e) {
        if (e.getBlocks().stream().anyMatch(block -> this.isLootBox(block.getLocation()))) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onLootRetract(BlockPistonRetractEvent e) {
        if (e.getBlocks().stream().anyMatch(block -> this.isLootBox(block.getLocation()))) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onLootCreatureSpawn(CreatureSpawnEvent e) {
        String reason = e.getSpawnReason().name();
        Set<String> black = this.generalSpawnReasonBlack;
        if (black.contains("*") || black.contains(reason)) {
            e.getEntity().setMetadata(META_SPAWN_REASON, (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)"LOOT_NO"));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onLootDeath(EntityDeathEvent e) {
        List loot = e.getDrops();
        if (loot.isEmpty()) {
            return;
        }
        LivingEntity dead = e.getEntity();
        Player killer = dead.getKiller();
        if (this.spawnLoot((LivingEntity)killer, dead, new ArrayList<ItemStack>(loot))) {
            loot.clear();
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onLootClick(PlayerInteractEvent e) {
        if (e.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (e.useInteractedBlock() == Event.Result.DENY) {
            return;
        }
        Action action = e.getAction();
        if (action != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = e.getPlayer();
        Block block = e.getClickedBlock();
        if (block == null) {
            return;
        }
        Location loot = block.getLocation();
        if (this.loots.containsKey(loot)) {
            e.setUseItemInHand(Event.Result.DENY);
            this.loots.get(loot).open(player);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPartyLeave(PlayerLeavePartyEvent e) {
        Player player = e.getPlayer();
        if (player == null) {
            return;
        }
        PartyManager.PartyMember mem = e.getPartyMember();
        PartyManager.Party party = mem.getParty();
        if (party.getOnline() == 1 || this.loots.isEmpty()) {
            return;
        }
        PartyManager.PartyMember transfer = null;
        for (PartyManager.PartyMember pm : party.getMembers()) {
            if (pm.equals(mem)) continue;
            transfer = pm;
            break;
        }
        if (transfer == null) {
            return;
        }
        for (LootHolder loot : this.loots.values()) {
            if (loot.ownerId == null || !loot.ownerId.equals(player.getUniqueId())) continue;
            loot.ownerId = transfer.getUUID();
            loot.ownerName = transfer.getName();
        }
    }

    class LootTask
    extends ITask<Divinity> {
        public LootTask(Divinity plugin) {
            super((CodexPlugin)plugin, 1, false);
        }

        public void action() {
            for (Map.Entry<Location, LootHolder> e : new HashMap<Location, LootHolder>(LootManager.this.loots).entrySet()) {
                LootHolder loot = e.getValue();
                Location loc = e.getKey();
                if (!LootManager.this.isLootBox(loc) || loot.isExpired()) {
                    LootManager.this.despawnLoot(loc);
                    continue;
                }
                loot.updateHolo();
                EffectUT.playEffect((Location)LocUT.getCenter((Location)loc, (boolean)false), (String)LootManager.this.boxParticleStatic, (double)0.1f, (double)0.1f, (double)0.1f, (double)0.1f, (int)30);
            }
        }
    }
}

