/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.itemgenerator.editor.materials;

import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.api.items.exception.CodexItemException;
import studio.magemonkey.codex.api.items.exception.MissingItemException;
import studio.magemonkey.codex.api.items.exception.MissingProviderException;
import studio.magemonkey.codex.api.items.providers.VanillaProvider;
import studio.magemonkey.codex.manager.api.menu.Slot;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.divinity.config.Config;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.AbstractEditorGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.EditorGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.materials.MainModelDataGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.materials.MaterialListGUI;
import studio.magemonkey.divinity.types.ItemGroup;
import studio.magemonkey.divinity.types.ItemSubType;

public class MainMaterialsGUI
extends AbstractEditorGUI {
    public MainMaterialsGUI(Player player, AbstractEditorGUI.ItemGeneratorReference itemGenerator) {
        super(player, 1, "Editor/" + EditorGUI.ItemType.MATERIALS.getTitle(), itemGenerator);
    }

    public void setContents() {
        final boolean reversed = this.itemGenerator.getHandle().isMaterialReversed();
        this.setSlot(0, new Slot(MainMaterialsGUI.createItem(reversed ? Material.STRUCTURE_VOID : Material.BARRIER, "&eIs whitelist/reversed", "&bCurrent: &a" + reversed, "&6Left-Click: &eToggle", "&6Right-Click: &eSet to default value")){

            public void onLeftClick() {
                MainMaterialsGUI.this.itemGenerator.getConfig().set(ItemType.REVERSE.getPath(), (Object)(!reversed ? 1 : 0));
                MainMaterialsGUI.this.saveAndReopen();
            }

            public void onRightClick() {
                MainMaterialsGUI.this.setDefault(ItemType.REVERSE.getPath());
                MainMaterialsGUI.this.saveAndReopen();
            }
        });
        this.setSlot(1, new Slot(MainMaterialsGUI.createItem(Material.BOOK, "&e" + (reversed ? "Whitelist" : "Blacklist"), (List<String>)StringUT.replace((String)"%current%", (List)this.itemGenerator.getConfig().getStringList(ItemType.LIST.getPath()), (String[])new String[]{"&bCurrent:", "&a%current%", "&6Left-Click: &eModify"}))){

            public void onLeftClick() {
                MainMaterialsGUI.this.openSubMenu(new MaterialListGUI(MainMaterialsGUI.this.player, MainMaterialsGUI.this.itemGenerator));
            }
        });
        this.setSlot(2, new Slot(MainMaterialsGUI.createItem(Material.END_CRYSTAL, "&eModel Data", "&6Left-Click: &eModify")){

            public void onLeftClick() {
                MainMaterialsGUI.this.openSubMenu(new MainModelDataGUI(MainMaterialsGUI.this.player, MainMaterialsGUI.this.itemGenerator));
            }
        });
    }

    public static ItemStack getMaterial(String string) {
        try {
            return CodexEngine.get().getItemManager().getItemType(string).create();
        }
        catch (MissingItemException | MissingProviderException throwable) {
            try {
                return new ItemStack(Material.valueOf((String)string.toUpperCase()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String[] split = string.toUpperCase().split("\\*", 2);
                if (split.length == 2) {
                    if (split[0].isEmpty()) {
                        try {
                            return CodexEngine.get().getItemManager().getItemType(split[1]).create();
                        }
                        catch (CodexItemException codexItemException) {
                        }
                    } else if (split[1].isEmpty()) {
                        try {
                            return CodexEngine.get().getItemManager().getItemType(split[0]).create();
                        }
                        catch (CodexItemException codexItemException) {
                            // empty catch block
                        }
                    }
                    for (studio.magemonkey.codex.api.items.ItemType material : Config.getAllRegisteredMaterials()) {
                        String materialName = material.getNamespacedID().toUpperCase();
                        if ((!split[0].isEmpty() || !materialName.endsWith(split[1])) && (!split[1].isEmpty() || !materialName.startsWith(split[0]))) continue;
                        return material.create();
                    }
                }
                return new ItemStack(Material.STONE);
            }
        }
    }

    public static ItemStack getMaterialGroup(String materialGroup) {
        try {
            return CodexEngine.get().getItemManager().getItemType(materialGroup).create();
        }
        catch (MissingItemException | MissingProviderException throwable) {
            ItemSubType subType = Config.getSubTypeById(materialGroup);
            if (subType != null) {
                return ((studio.magemonkey.codex.api.items.ItemType)subType.getMaterials().stream().findAny().orElse(new VanillaProvider.VanillaItemType(Material.STONE))).create();
            }
            try {
                return ((studio.magemonkey.codex.api.items.ItemType)ItemGroup.valueOf(materialGroup.toUpperCase()).getMaterials().stream().findAny().orElse(new VanillaProvider.VanillaItemType(Material.STONE))).create();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return MainMaterialsGUI.getMaterial(materialGroup.toUpperCase());
            }
        }
    }

    public static enum ItemType {
        REVERSE("reverse"),
        LIST("black-list"),
        MODEL_DATA("model-data");

        private final String path;

        private ItemType(String path) {
            this.path = "generator.materials." + path;
        }

        public String getPath() {
            return this.path;
        }
    }
}

