/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.itemgenerator.editor.bonuses;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import studio.magemonkey.codex.config.api.JYML;
import studio.magemonkey.codex.manager.api.menu.Slot;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.hooks.external.FabledHook;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.AbstractEditorGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.EditorGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.bonuses.BonusesGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.bonuses.MainBonusesGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.materials.MainMaterialsGUI;
import studio.magemonkey.divinity.stats.items.ItemStats;
import studio.magemonkey.divinity.stats.items.attributes.DamageAttribute;
import studio.magemonkey.divinity.stats.items.attributes.DefenseAttribute;
import studio.magemonkey.divinity.stats.items.attributes.api.SimpleStat;
import studio.magemonkey.divinity.stats.items.attributes.api.TypedStat;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.manager.FabledAttribute;

public class BonusCategoryGUI
extends AbstractEditorGUI {
    private final MainBonusesGUI.ItemType category;

    public BonusCategoryGUI(Player player, AbstractEditorGUI.ItemGeneratorReference itemGenerator, MainBonusesGUI.ItemType category) {
        super(player, 6, "Editor/" + EditorGUI.ItemType.BONUSES.getTitle(), itemGenerator);
        this.category = category;
    }

    private void loadLore(ConfigurationSection section, List<String> lore, Function<String, String> function) {
        for (String statId : section.getKeys(false)) {
            lore.add(StringUT.color((String)(" " + function.apply(statId).replace("%value%", Objects.requireNonNull(section.getString(statId))))));
        }
    }

    public void setContents() {
        final JYML cfg = this.itemGenerator.getConfig();
        HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
        ArrayList<String> list = new ArrayList<String>();
        ConfigurationSection bonusesSection = cfg.getConfigurationSection(this.category.getPath());
        if (bonusesSection != null) {
            for (String key : bonusesSection.getKeys(false)) {
                Set keys;
                ArrayList<String> lore = new ArrayList<String>();
                ConfigurationSection section = bonusesSection.getConfigurationSection(key + "." + ItemType.DAMAGE.getPath());
                if (section != null && !section.getKeys(false).isEmpty()) {
                    lore.add("&2Damage types:");
                    this.loadLore(section, lore, s -> {
                        DamageAttribute damageAttribute = ItemStats.getDamageById(s);
                        return damageAttribute == null ? s + ": %value%" : damageAttribute.getFormat();
                    });
                }
                if ((section = bonusesSection.getConfigurationSection(key + "." + ItemType.DEFENSE.getPath())) != null && !(keys = section.getKeys(false)).isEmpty()) {
                    lore.add("&2Defense types:");
                    this.loadLore(section, lore, s -> {
                        DefenseAttribute defenseAttribute = ItemStats.getDefenseById(s);
                        return defenseAttribute == null ? s + ": %value%" : defenseAttribute.getFormat();
                    });
                }
                if ((section = bonusesSection.getConfigurationSection(key + "." + ItemType.ITEM_STAT.getPath())) != null && !(keys = section.getKeys(false)).isEmpty()) {
                    lore.add("&2Item Stats:");
                    this.loadLore(section, lore, s -> {
                        TypedStat stat;
                        TypedStat.Type type = TypedStat.Type.getByName(s);
                        if (type != null && (stat = ItemStats.getStat(type)) instanceof SimpleStat) {
                            return ((SimpleStat)stat).getFormat();
                        }
                        return "&f" + s + ": &6%value%";
                    });
                }
                switch (this.category) {
                    case MATERIAL_MODIFIERS: 
                    case MATERIAL: 
                    case RARITY: {
                        section = bonusesSection.getConfigurationSection(key + "." + ItemType.FABLED_ATTRIBUTE.getPath());
                        if (section != null && !(keys = section.getKeys(false)).isEmpty()) {
                            lore.add("&2Fabled Attributes:");
                            this.loadLore(section, lore, s -> {
                                FabledAttribute proAttribute;
                                FabledHook fabledHook = (FabledHook)Divinity.getInstance().getHook("Fabled");
                                if (fabledHook != null && (proAttribute = Fabled.getAttributeManager().getAttribute(s)) != null) {
                                    return proAttribute.getName() + ": &6%value%";
                                }
                                return "&f" + s + ": &6%value%";
                            });
                        }
                        if ((section = bonusesSection.getConfigurationSection(key + "." + ItemType.AMMO.getPath())) != null && !(keys = section.getKeys(false)).isEmpty()) {
                            lore.add("&2Ammo:");
                            this.loadLore(section, lore, s -> "&f" + s + ": &6%value%");
                        }
                        if ((section = bonusesSection.getConfigurationSection(key + "." + ItemType.HAND.getPath())) == null || (keys = section.getKeys(false)).isEmpty()) break;
                        lore.add("&2Hands:");
                        this.loadLore(section, lore, s -> "&f" + s + ": &6%value%");
                    }
                }
                map.put(key, lore);
                list.add(key);
            }
        }
        list.add(null);
        int i = 0;
        for (final String group : list) {
            if (++i % this.inventory.getSize() == 53) {
                this.setSlot(i, this.getNextButton());
                ++i;
            } else if (i % 9 == 8) {
                ++i;
            }
            if (i % this.inventory.getSize() == 45) {
                this.setSlot(i, this.getPrevButton());
                ++i;
            } else if (i % 9 == 0) {
                ++i;
            }
            this.setSlot(i, group == null ? new Slot(BonusCategoryGUI.createItem(Material.REDSTONE, "&eAdd new " + this.category.getDescription(), new String[0])){

                public void onLeftClick() {
                    BonusCategoryGUI.this.sendSetMessage(BonusCategoryGUI.this.category.getDescription(), null, s -> {
                        String path = BonusCategoryGUI.this.category.getPath() + "." + s;
                        cfg.set(path, (Object)cfg.createSection(path));
                        BonusCategoryGUI.this.saveAndReopen();
                    });
                }
            } : new Slot(BonusCategoryGUI.createItem(MainMaterialsGUI.getMaterialGroup(group), "&e" + group, (List<String>)StringUT.replace((String)"%current%", (List)((List)map.get(group)), (String[])new String[]{"&bCurrent:", "&a%current%", "&6Left-Click: &eModify", "&6Right-Click: &eRemove"}))){

                public void onLeftClick() {
                    BonusCategoryGUI.this.openSubMenu(new BonusesGUI(BonusCategoryGUI.this.player, BonusCategoryGUI.this.itemGenerator, BonusCategoryGUI.this.category.getPath() + "." + group));
                }

                public void onRightClick() {
                    cfg.remove(BonusCategoryGUI.this.category.getPath() + "." + group);
                    BonusCategoryGUI.this.saveAndReopen();
                }
            });
        }
        list.remove(list.size() - 1);
        this.setSlot(this.getPages() * this.inventory.getSize() - 9, this.getPrevButton());
        this.setSlot(this.getPages() * this.inventory.getSize() - 1, this.getNextButton());
    }

    public static enum ItemType {
        DAMAGE("damage-types"),
        DEFENSE("defense-types"),
        ITEM_STAT("item-stats"),
        FABLED_ATTRIBUTE("fabled-attributes"),
        HAND("hands"),
        AMMO("ammo");

        private final String path;

        private ItemType(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }
    }
}

