/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.itemgenerator.editor;

import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import studio.magemonkey.codex.config.api.JYML;
import studio.magemonkey.codex.manager.api.menu.Slot;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.AbstractEditorGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.EditorGUI;

public class UsesByLevelGUI
extends AbstractEditorGUI {
    public UsesByLevelGUI(Player player, AbstractEditorGUI.ItemGeneratorReference itemGenerator) {
        super(player, 6, "Editor/" + EditorGUI.ItemType.USES_BY_LEVEL.getTitle(), itemGenerator);
    }

    public void setContents() {
        final Map<Integer, Integer> map = UsesByLevelGUI.getUsesByLevel(this.itemGenerator.getConfig());
        ArrayList<Integer> list = new ArrayList<Integer>(map.keySet());
        list.add(null);
        int i = 0;
        for (final Integer level : list) {
            if (++i % this.inventory.getSize() == 53) {
                this.setSlot(i, this.getNextButton());
                ++i;
            } else if (i % 9 == 8) {
                ++i;
            }
            if (i % this.inventory.getSize() == 45) {
                this.setSlot(i, this.getPrevButton());
                ++i;
            } else if (i % 9 == 0) {
                ++i;
            }
            this.setSlot(i, level == null ? new Slot(UsesByLevelGUI.createItem(Material.REDSTONE, "&eAdd new level", new String[0])){

                public void onLeftClick() {
                    UsesByLevelGUI.this.sendSetMessage("level", null, s -> {
                        final int level = Integer.parseInt(s);
                        new BukkitRunnable(){

                            public void run() {
                                UsesByLevelGUI.this.sendSetMessage(EditorGUI.ItemType.USES_BY_LEVEL.getTitle() + " " + level, String.valueOf(map.get(level)), s1 -> {
                                    map.put(level, Integer.parseInt(s1));
                                    UsesByLevelGUI.this.setUsesByLevel(map);
                                    UsesByLevelGUI.this.saveAndReopen();
                                });
                            }
                        }.runTask((Plugin)Divinity.getInstance());
                    });
                }
            } : new Slot(UsesByLevelGUI.createItem(Material.CAULDRON, "&e" + level, "&bCurrent: &a" + String.valueOf(map.get(level)), "&6Left-Click: &eSet", "&6Right-Click: &eRemove")){

                public void onLeftClick() {
                    UsesByLevelGUI.this.sendSetMessage(EditorGUI.ItemType.USES_BY_LEVEL.getTitle() + " " + level, String.valueOf(map.get(level)), s -> {
                        map.put(level, Integer.parseInt(s));
                        UsesByLevelGUI.this.setUsesByLevel(map);
                        UsesByLevelGUI.this.saveAndReopen();
                    });
                }

                public void onRightClick() {
                    map.remove(level);
                    UsesByLevelGUI.this.setUsesByLevel(map);
                    UsesByLevelGUI.this.saveAndReopen();
                }
            });
        }
        list.remove(list.size() - 1);
        this.setSlot(this.getPages() * this.inventory.getSize() - 9, this.getPrevButton());
        this.setSlot(this.getPages() * this.inventory.getSize() - 1, this.getNextButton());
    }

    public static Map<Integer, Integer> getUsesByLevel(JYML cfg) {
        TreeMap<Integer, Integer> map = new TreeMap<Integer, Integer>();
        ConfigurationSection configurationSection = cfg.getConfigurationSection(EditorGUI.ItemType.USES_BY_LEVEL.getPath());
        if (configurationSection != null) {
            for (String key : configurationSection.getKeys(false)) {
                try {
                    map.put(Integer.parseInt(key), configurationSection.getInt(key));
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        return map;
    }

    protected void setUsesByLevel(Map<Integer, Integer> usesByLevel) {
        JYML cfg = this.itemGenerator.getConfig();
        Object path = EditorGUI.ItemType.USES_BY_LEVEL.getPath();
        cfg.remove(EditorGUI.ItemType.USES_BY_LEVEL.getPath());
        path = (String)path + ".";
        for (Map.Entry<Integer, Integer> entry : usesByLevel.entrySet()) {
            cfg.set((String)path + String.valueOf(entry.getKey()), (Object)entry.getValue());
        }
    }
}

