/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.itemgenerator;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.api.items.ItemType;
import studio.magemonkey.codex.manager.api.Loadable;
import studio.magemonkey.codex.util.FileUT;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.config.Config;
import studio.magemonkey.divinity.modules.list.itemgenerator.ItemGeneratorManager;
import studio.magemonkey.divinity.stats.tiers.Tier;

public class ResourceManager
implements Loadable {
    private ItemGeneratorManager itemGen;
    private Map<ResourceCategory, Map<String, Map<ResourceType, List<String>>>> resources;

    ResourceManager(@NotNull ItemGeneratorManager itemGen) {
        this.itemGen = itemGen;
    }

    public void setup() {
        this.resources = new HashMap<ResourceCategory, Map<String, Map<ResourceType, List<String>>>>();
        this.createMissingResources();
        this.load(ResourceCategory.MATERIAL, Config.getAllRegisteredMaterials().stream().map(ItemType::getNamespacedID).collect(Collectors.toSet()));
        this.load(ResourceCategory.SUBTYPE, Config.getSubTypeIds());
        this.load(ResourceCategory.TIER, Config.getTiers().stream().map(tier -> tier.getId()).collect(Collectors.toSet()));
    }

    public void shutdown() {
        if (this.resources != null) {
            this.resources.clear();
            this.resources = null;
        }
    }

    private void createMissingResources() {
        for (ResourceType rt : ResourceType.values()) {
            String folder = rt.getFolder();
            for (ResourceCategory cat : ResourceCategory.values()) {
                File f;
                String path = this.itemGen.getFullPath() + "resources/names/" + folder + "/" + cat.getFolder();
                ((Divinity)this.itemGen.plugin).getConfigManager().extractFullPath(path, "txt", false);
                if (cat == ResourceCategory.TIER) {
                    for (Tier tier : Config.getTiers()) {
                        String tName = tier.getId() + ".txt";
                        File f2 = new File(path, tName);
                        FileUT.create((File)f2);
                    }
                    continue;
                }
                if (cat == ResourceCategory.MATERIAL) {
                    for (ItemType m : Config.getAllRegisteredMaterials()) {
                        f = new File(path, m.getNamespacedID() + ".txt");
                        FileUT.create((File)f);
                    }
                    continue;
                }
                if (cat != ResourceCategory.SUBTYPE) continue;
                for (String sub : Config.getSubTypeIds()) {
                    f = new File(path, sub.toLowerCase() + ".txt");
                    FileUT.create((File)f);
                }
            }
        }
    }

    private void load(@NotNull ResourceCategory cat, @NotNull Set<String> idList) {
        HashMap mapRes = new HashMap();
        for (String id : idList) {
            HashMap<ResourceType, List<String>> mapType = new HashMap<ResourceType, List<String>>();
            for (ResourceType resourceType : ResourceType.values()) {
                List<String> resList = this.getFileLines(resourceType, cat, id);
                mapType.put(resourceType, resList);
            }
            mapRes.put(id.toLowerCase(), mapType);
        }
        this.resources.put(cat, mapRes);
    }

    @NotNull
    private List<String> getFileLines(@NotNull ResourceType type, @NotNull ResourceCategory cat, @NotNull String file) {
        ArrayList<String> list = new ArrayList<String>();
        String folder = type.getFolder();
        String path = this.itemGen.getFullPath() + "resources/names/" + folder + "/" + cat.getFolder() + "/" + file + ".txt";
        try (BufferedReader br = new BufferedReader(new FileReader(path));){
            String sCurrentLine;
            while ((sCurrentLine = br.readLine()) != null) {
                list.add(sCurrentLine);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list;
    }

    @NotNull
    public List<String> getPrefix(@NotNull ResourceCategory cat, @NotNull String type) {
        return this.get(ResourceType.PREFIX, cat, type);
    }

    @NotNull
    public List<String> getSuffix(@NotNull ResourceCategory cat, @NotNull String type) {
        return this.get(ResourceType.SUFFIX, cat, type);
    }

    @NotNull
    public List<String> get(@NotNull ResourceType type, @NotNull ResourceCategory cat, @NotNull String id) {
        return this.resources.getOrDefault((Object)cat, Collections.emptyMap()).getOrDefault(id.toLowerCase(), Collections.emptyMap()).getOrDefault((Object)type, Collections.emptyList());
    }

    public static enum ResourceCategory {
        MATERIAL("materials"),
        SUBTYPE("types"),
        TIER("tiers");

        private String folder;

        private ResourceCategory(String folder) {
            this.folder = folder;
        }

        @NotNull
        public String getFolder() {
            return this.folder;
        }
    }

    public static enum ResourceType {
        PREFIX("prefixes"),
        SUFFIX("suffixes");

        private String folder;

        private ResourceType(String folder) {
            this.folder = folder;
        }

        @NotNull
        public String getFolder() {
            return this.folder;
        }
    }
}

