/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.fortify;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.commands.api.ISubCommand;
import studio.magemonkey.codex.config.api.JYML;
import studio.magemonkey.codex.modules.IModule;
import studio.magemonkey.codex.util.DataUT;
import studio.magemonkey.codex.util.ItemUT;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.codex.util.random.Rnd;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.config.EngineCfg;
import studio.magemonkey.divinity.modules.LimitedItem;
import studio.magemonkey.divinity.modules.api.QModuleDrop;
import studio.magemonkey.divinity.modules.list.fortify.command.FortifyCmd;
import studio.magemonkey.divinity.modules.list.fortify.command.UnfortifyCmd;
import studio.magemonkey.divinity.stats.items.ItemStats;
import studio.magemonkey.divinity.utils.LoreUT;

public class FortifyManager
extends QModuleDrop<FortifyItem> {
    private static final List<String> LORE_KEY_FORTIFY = List.of("fortify", "qrpg_fortify");
    private static final List<NamespacedKey> META_KEY_FORTIFY = List.of(new NamespacedKey((Plugin)Divinity.getInstance(), "fortify_protection"), Objects.requireNonNull(NamespacedKey.fromString((String)"prorpgitems:fortify_protection")), Objects.requireNonNull(NamespacedKey.fromString((String)"prorpgitems:qrpg_fortify_protection")), Objects.requireNonNull(NamespacedKey.fromString((String)"quantumrpg:qrpg_fortify_protection")));
    private boolean formatNameAsPrefix;
    private String formatNameText;
    private List<String> formatLoreFormat;

    public FortifyManager(@NotNull Divinity plugin) {
        super(plugin, FortifyItem.class);
    }

    @NotNull
    public String getId() {
        return "fortify";
    }

    @NotNull
    public String version() {
        return "1.2.0";
    }

    public void setup() {
        String path = "format.";
        this.formatNameAsPrefix = this.cfg.getBoolean(path + "item-name.as-prefix");
        this.formatNameText = StringUT.color((String)this.cfg.getString(path + "item-name.format", ""));
        this.formatLoreFormat = StringUT.color((List)this.cfg.getStringList(path + "item-lore.format"));
        this.moduleCommand.addSubCommand((ISubCommand)new FortifyCmd(this));
        this.moduleCommand.addSubCommand((ISubCommand)new UnfortifyCmd(this));
    }

    public void shutdown() {
        if (this.formatLoreFormat != null) {
            this.formatLoreFormat.clear();
            this.formatLoreFormat = null;
        }
    }

    public void deformatItemName(@NotNull ItemStack item) {
        if (!this.isFortified(item)) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        String name = this.getNameDeformatted(item, ItemUT.getItemName((ItemStack)item));
        meta.setDisplayName(name);
        item.setItemMeta(meta);
    }

    public void formatItemName(@NotNull ItemStack item) {
        if (!this.isFortified(item)) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        String name = this.getNameFormatted(item, this.getFortifyLevel(item));
        meta.setDisplayName(name);
        item.setItemMeta(meta);
    }

    @NotNull
    public String getNameDeformatted(@NotNull ItemStack item, @NotNull String name) {
        for (String key : LORE_KEY_FORTIFY) {
            String storedName = ItemUT.getNameTag((ItemStack)item, (String)key);
            if (storedName == null) continue;
            return name.replace(storedName, "");
        }
        return name;
    }

    @NotNull
    public String getNameFormatted(@NotNull ItemStack item, int lvl) {
        String name = ItemUT.getItemName((ItemStack)item);
        if (this.formatNameText.isEmpty()) {
            return name;
        }
        String format = this.formatNameText.replace("%fortify-level%", String.valueOf(lvl));
        if (this.formatNameAsPrefix) {
            return StringUT.colorFix((String)(format + name));
        }
        return StringUT.colorFix((String)(name + format));
    }

    @NotNull
    public void fortifyItem(@NotNull ItemStack item, @NotNull FortifyItem stone, int stoneLvl) {
        if (this.isFortified(item)) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        String stoneId = stone.getId();
        String name = meta.getDisplayName();
        String name2 = this.getNameFormatted(item, stoneLvl);
        meta.setDisplayName(name2);
        String sep = EngineCfg.LORE_STYLE_SEPAR_VALUE;
        String sepColor = EngineCfg.LORE_STYLE_SEPAR_COLOR;
        String[] sepModules = new String[stone.protectModules.size()];
        int j = 0;
        for (String modId : stone.protectModules) {
            IModule mod = ((Divinity)this.plugin).getModuleManager().getModule(modId);
            if (mod == null) continue;
            sepModules[j] = mod.name();
        }
        String fModules = LoreUT.getStrSeparated(sepModules, sep, sepColor);
        StringBuilder loreTag = new StringBuilder();
        if (!this.formatLoreFormat.isEmpty()) {
            int fRate = stone.getFortifyRateByLevel(stoneLvl);
            ArrayList<String> lore = new ArrayList<String>();
            for (String formatLine : this.formatLoreFormat) {
                if (formatLine.equalsIgnoreCase("%item-lore%")) {
                    List metaLore = meta.getLore();
                    if (metaLore == null) continue;
                    for (String loreLine : metaLore) {
                        lore.add(loreLine);
                    }
                    continue;
                }
                String line = StringUT.color((String)formatLine.replace("%fortify-modules%", fModules).replace("%fortify-rate%", String.valueOf(fRate))).replace("%fortify-level%", String.valueOf(stoneLvl));
                lore.add(line);
                if (loreTag.length() > 0) {
                    loreTag.append("__x__");
                }
                loreTag.append(line);
            }
            meta.setLore(lore);
        }
        item.setItemMeta(meta);
        String tagValue = stoneId + ":" + stoneLvl;
        DataUT.setData((ItemStack)item, (NamespacedKey)META_KEY_FORTIFY.get(0), (Object)tagValue);
        ItemUT.addLoreTag((ItemStack)item, (String)LORE_KEY_FORTIFY.get(0), (String)loreTag.toString());
        ItemUT.addNameTag((ItemStack)item, (String)LORE_KEY_FORTIFY.get(0), (String)name2.replace(name, ""));
    }

    @NotNull
    public void unfortifyItem(@NotNull ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        String name = this.getNameDeformatted(item, meta.getDisplayName());
        meta.setDisplayName(name);
        item.setItemMeta(meta);
        for (String string : LORE_KEY_FORTIFY) {
            ItemUT.delLore((ItemStack)item, (String)string);
            ItemUT.delNameTag((ItemStack)item, (String)string);
        }
        for (NamespacedKey namespacedKey : META_KEY_FORTIFY) {
            DataUT.removeData((ItemStack)item, (NamespacedKey)namespacedKey);
        }
    }

    public boolean tryFortify(@NotNull ItemStack item) {
        FortifyItem stone = this.getFortifyItem(item);
        if (stone == null) {
            return false;
        }
        int lvl = this.getFortifyLevel(item);
        if (lvl < 0) {
            return false;
        }
        return Rnd.get((boolean)true) < (float)stone.getFortifyRateByLevel(lvl);
    }

    public boolean canFortify(@NotNull ItemStack item, @NotNull QModuleDrop<?> modType) {
        FortifyItem stone = this.getFortifyItem(item);
        return stone != null && stone.isApplicable(modType);
    }

    public boolean isFortified(@NotNull ItemStack item) {
        return this.getFortifyLevel(item) > 0 && this.getFortifyItem(item) != null;
    }

    @Nullable
    public FortifyItem getFortifyItem(@NotNull ItemStack item) {
        String stoneId = this.getFortifyId(item);
        if (stoneId == null) {
            return null;
        }
        return (FortifyItem)this.getItemById(stoneId);
    }

    @Nullable
    public String getFortifyId(@NotNull ItemStack item) {
        for (NamespacedKey key : META_KEY_FORTIFY) {
            String data = DataUT.getStringData((ItemStack)item, (NamespacedKey)key);
            if (data == null) continue;
            return data.split(":")[0];
        }
        return null;
    }

    public int getFortifyLevel(@NotNull ItemStack item) {
        for (NamespacedKey key : META_KEY_FORTIFY) {
            String data = DataUT.getStringData((ItemStack)item, (NamespacedKey)key);
            if (data == null) continue;
            String[] split = data.split(":");
            return split.length < 2 ? -1 : StringUT.getInteger((String)split[1], (int)-1);
        }
        return -1;
    }

    @Override
    protected boolean onDragDrop(@NotNull Player p, @NotNull ItemStack src, @NotNull ItemStack target, @NotNull FortifyItem fItem, @NotNull InventoryClickEvent e) {
        if (this.isFortified(target)) {
            ((Divinity)this.plugin).lang().Fortify_Fortify_Error_Already.send((CommandSender)p);
            return false;
        }
        this.takeChargeClickEvent(p, src, e);
        ItemStack lost = null;
        if (target.getAmount() > 1) {
            lost = new ItemStack(target);
            lost.setAmount(target.getAmount() - 1);
        }
        this.fortifyItem(target, fItem, ItemStats.getLevel(src));
        e.setCurrentItem(target);
        if (lost != null) {
            ItemUT.addItem((Player)p, (ItemStack[])new ItemStack[]{lost});
        }
        ((Divinity)this.plugin).lang().Fortify_Fortify_Done.send((CommandSender)p);
        return true;
    }

    public class FortifyItem
    extends LimitedItem {
        private final Set<String> protectModules;
        private final TreeMap<Integer, Integer> protectChanceMap;

        public FortifyItem(@NotNull Divinity plugin, JYML cfg) {
            super(plugin, cfg, FortifyManager.this);
            this.protectModules = new HashSet<String>();
            for (String sMod : cfg.getStringList("protection.modules")) {
                IModule mod = plugin.getModuleManager().getModule(sMod);
                if (mod == null || !mod.isLoaded() || !(mod instanceof QModuleDrop)) {
                    FortifyManager.this.error("Invalid module provided in '" + cfg.getFile().getName() + "' !");
                    continue;
                }
                this.protectModules.add(sMod.toLowerCase());
            }
            this.protectChanceMap = new TreeMap();
            for (String sLvl : cfg.getSection("protection.chance-by-level")) {
                int lvl = StringUT.getInteger((String)sLvl, (int)-1);
                if (lvl <= 0) continue;
                int chance = cfg.getInt("protection.chance-by-level." + sLvl);
                this.protectChanceMap.put(lvl, chance);
            }
        }

        public boolean isApplicable(@NotNull QModuleDrop<?> e) {
            return this.protectModules.contains(e.getId());
        }

        public int getFortifyRateByLevel(int lvl) {
            Map.Entry<Integer, Integer> e = this.protectChanceMap.floorEntry(lvl);
            if (e == null) {
                return 0;
            }
            return e.getValue();
        }

        @Override
        @NotNull
        protected ItemStack build(int lvl, int uses) {
            List lore;
            ItemStack item = super.build(lvl, uses);
            ItemMeta meta = item.getItemMeta();
            if (meta == null) {
                return item;
            }
            int fRate = this.getFortifyRateByLevel(lvl);
            if (meta.hasDisplayName()) {
                meta.setDisplayName(meta.getDisplayName().replace("%fortify-rate%", String.valueOf(fRate)).replace("%fortify-level%", String.valueOf(lvl)));
            }
            if ((lore = meta.getLore()) != null) {
                lore.replaceAll(str -> str.replace("%fortify-rate%", String.valueOf(fRate)).replace("%fortify-level%", String.valueOf(lvl)));
                meta.setLore(lore);
            }
            item.setItemMeta(meta);
            return item;
        }
    }
}

