/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.classes.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.config.api.JYML;
import studio.magemonkey.codex.manager.LoadableItem;
import studio.magemonkey.codex.util.NumberUT;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.codex.util.actions.ActionManipulator;
import studio.magemonkey.codex.util.eval.Evaluator;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.modules.list.classes.ClassManager;
import studio.magemonkey.divinity.modules.list.classes.object.ClassAspect;
import studio.magemonkey.divinity.modules.list.classes.object.ClassAspectBonus;
import studio.magemonkey.divinity.modules.list.classes.object.ClassAttribute;
import studio.magemonkey.divinity.modules.list.classes.object.ClassAttributeType;
import studio.magemonkey.divinity.stats.bonus.BonusMap;

public class RPGClass
extends LoadableItem {
    private String name;
    private List<String> desc;
    private boolean isPerm;
    private ItemStack icon;
    private ActionManipulator actionsSelect;
    private int lvlStart;
    private int lvlMax;
    private int lvlStartExp;
    private String lvlFormula;
    private int lvlSkillPoints;
    private int lvlAspectPoints;
    private TreeMap<Integer, Integer> lvlExpMap;
    private Map<Integer, ActionManipulator> lvlActions;
    private Set<String> specList;
    private int specLvlSelect;
    private String manaChar;
    private String manaName;
    private TreeMap<Integer, Integer> manaByLevel;
    private double manaRegen;
    private Map<ClassAttributeType, ClassAttribute> attributes;
    private Map<ClassAspect, ClassAspectBonus> aspects;
    private RPGClass cParent;

    public RPGClass(@NotNull Divinity plugin, @NotNull JYML cfg) {
        super((CodexPlugin)plugin, cfg);
        int lvl;
        String name = cfg.getString("name");
        if (name == null) {
            name = cfg.getFile().getName().replace(".yml", "");
        }
        this.name = StringUT.color((String)name);
        this.desc = cfg.getStringList("description");
        this.isPerm = cfg.getBoolean("permission-required");
        this.icon = cfg.getItem("icon");
        this.actionsSelect = new ActionManipulator((CodexPlugin)plugin, cfg, "actions-on-select");
        Object path = "leveling.";
        this.lvlStart = cfg.getInt((String)path + "start-level", 1);
        this.lvlMax = cfg.getInt((String)path + "max-level", 100);
        this.lvlStartExp = cfg.getInt((String)path + "start-exp", 25);
        this.lvlFormula = cfg.getString((String)path + "exp-formula");
        this.lvlSkillPoints = cfg.getInt((String)path + "skill-points");
        this.lvlAspectPoints = cfg.getInt((String)path + "aspect-points");
        this.lvlExpMap = new TreeMap();
        if (this.lvlMax > 0) {
            for (int lvl2 = this.lvlStart; lvl2 < this.lvlMax + 1; ++lvl2) {
                double prevExp = 0.0;
                prevExp = lvl2 <= this.lvlStart ? (double)this.lvlStartExp : (double)this.lvlExpMap.get(lvl2 - 1).intValue();
                String formula = this.getExpFormula().replace("%exp%", NumberUT.format((double)prevExp));
                double expToLevel = Evaluator.eval((String)formula, (int)1);
                this.lvlExpMap.put(lvl2, (int)expToLevel);
            }
        }
        this.lvlActions = new TreeMap<Integer, ActionManipulator>();
        for (String sLvl : cfg.getSection((String)path + "actions-on-level")) {
            lvl = StringUT.getInteger((String)sLvl, (int)-1);
            if (lvl <= this.lvlStart) continue;
            ActionManipulator engine = new ActionManipulator((CodexPlugin)plugin, cfg, (String)path + "actions-on-level." + sLvl);
            this.lvlActions.put(lvl, engine);
        }
        path = "sub-class.";
        this.specList = cfg.getStringSet((String)path + "sub-classes");
        this.specLvlSelect = cfg.getInt((String)path + "level-to-change");
        path = "mana.";
        cfg.addMissing((String)path + "max-value-by-level.1", (Object)50);
        this.manaChar = StringUT.color((String)cfg.getString((String)path + "symbol", "\u2022"));
        this.manaName = StringUT.color((String)cfg.getString((String)path + "name", "Mana"));
        this.manaByLevel = new TreeMap();
        for (String sLvl : cfg.getSection((String)path + "max-value-by-level")) {
            lvl = StringUT.getInteger((String)sLvl, (int)-1);
            if (lvl <= 0) continue;
            this.manaByLevel.put(lvl, cfg.getInt((String)path + "max-value-by-level." + sLvl));
        }
        this.manaRegen = cfg.getDouble((String)path + "regen-of-max", 2.5);
        this.attributes = new HashMap<ClassAttributeType, ClassAttribute>();
        for (ClassAttributeType attributeType : ClassAttributeType.values()) {
            path = "attributes." + attributeType.name() + ".";
            cfg.addMissing((String)path + "start-value", (Object)attributeType.getDefaultValue());
            cfg.addMissing((String)path + "max-value", (Object)-1.0);
            cfg.addMissing((String)path + "per-level-value", (Object)0.0);
            double aStart = cfg.getDouble((String)path + "start-value", attributeType.getDefaultValue());
            double aMax = cfg.getDouble((String)path + "max-value", -1.0);
            double aLvl = cfg.getDouble((String)path + "per-level-value");
            ClassAttribute classAttribute = new ClassAttribute(aStart, aMax, aLvl);
            this.attributes.put(attributeType, classAttribute);
        }
        ClassManager classManager = plugin.getModuleCache().getClassManager();
        this.aspects = new LinkedHashMap<ClassAspect, ClassAspectBonus>();
        for (String aspectId : cfg.getSection("aspects")) {
            ClassAspect aspect;
            path = "aspects." + aspectId + ".";
            ClassAspect classAspect = aspect = classManager == null ? null : classManager.getAspectManager().getAspectById(aspectId);
            if (classManager == null) {
                plugin.error("Class manager is null.");
            }
            if (aspect == null) {
                plugin.error("Invalid aspect '" + aspectId + "' in " + cfg.getFile().getName());
                continue;
            }
            cfg.addMissing((String)path + "max-value", (Object)100);
            int aMax = cfg.getInt((String)path + "max-value", -1);
            HashMap<ClassAttributeType, Double> pointAtt = new HashMap<ClassAttributeType, Double>();
            for (ClassAttributeType qa : ClassAttributeType.values()) {
                String path2 = (String)path + "per-point-values.attributes." + qa.name();
                double val = cfg.getDouble(path2);
                pointAtt.put(qa, val);
            }
            BonusMap bonusMap = new BonusMap();
            bonusMap.loadDamages(cfg, (String)path + "per-point-values.damage-types");
            bonusMap.loadDefenses(cfg, (String)path + "per-point-values.defense-types");
            bonusMap.loadStats(cfg, (String)path + "per-point-values.item-stats");
            ClassAspectBonus aspectBonus = new ClassAspectBonus(aMax, pointAtt, bonusMap);
            this.aspects.put(aspect, aspectBonus);
        }
        for (int i = 0; i < this.desc.size(); ++i) {
            String line = this.desc.get(i);
            for (ClassAttributeType attributeType : ClassAttributeType.values()) {
                ClassAttribute attribute = this.getAttribute(attributeType);
                if (attribute == null) continue;
                line = attribute.replace(attributeType, line, 0.0, 0.0, 1);
            }
            this.desc.set(i, line);
        }
        this.desc = StringUT.color(this.desc);
        cfg.saveChanges();
    }

    protected void save(@NotNull JYML cfg) {
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public List<String> getDescription() {
        return new ArrayList<String>(this.desc);
    }

    public boolean isPermissionRequired() {
        return this.isPerm;
    }

    public boolean hasPermission(@NotNull Player player) {
        if (!this.isPermissionRequired()) {
            return true;
        }
        String node = "quantumrpg.classes.class." + this.getId();
        return player.hasPermission(node);
    }

    @NotNull
    public ItemStack getIcon() {
        List lore;
        ItemStack item = new ItemStack(this.icon);
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return item;
        }
        if (meta.hasDisplayName()) {
            meta.setDisplayName(meta.getDisplayName().replace("%name%", this.getName()));
        }
        if ((lore = meta.getLore()) != null) {
            ArrayList<String> lore2 = new ArrayList<String>();
            for (String line : lore) {
                if (line.contains("%description%")) {
                    for (String desc : this.getDescription()) {
                        lore2.add(desc);
                    }
                    continue;
                }
                lore2.add(line.replace("%name%", this.getName()));
            }
            meta.setLore(lore2);
        }
        item.setItemMeta(meta);
        return item;
    }

    public void executeSelectActions(@NotNull Player exec) {
        this.actionsSelect.process((Entity)exec);
    }

    public void executeLevelActions(@NotNull Player exec, int lvl) {
        if (this.lvlActions.containsKey(lvl)) {
            ActionManipulator engine = this.lvlActions.get(lvl);
            engine.process((Entity)exec);
        }
    }

    public int getStartLevel() {
        return this.lvlStart;
    }

    public int getMaxLevel() {
        return this.lvlMax;
    }

    public int getStartExp() {
        return this.lvlStartExp;
    }

    public int getNeedExpForLevel(int lvl) {
        Map.Entry<Integer, Integer> e = this.lvlExpMap.floorEntry(lvl);
        return e != null ? e.getValue().intValue() : this.getStartExp();
    }

    @NotNull
    public String getExpFormula() {
        return this.lvlFormula;
    }

    public int getSkillPointsPerLevel() {
        return this.lvlSkillPoints;
    }

    public int getAspectPointsPerLevel() {
        return this.lvlAspectPoints;
    }

    public boolean isChildClass() {
        return this.cParent != null;
    }

    public boolean isChildClass(@NotNull RPGClass from) {
        for (RPGClass parent : this.getParents()) {
            if (parent == null || !parent.getChildClasses().contains(this.getId())) continue;
            return true;
        }
        return false;
    }

    public Set<String> getChildClasses() {
        return this.specList;
    }

    public boolean hasChildClass() {
        return !this.getChildClasses().isEmpty();
    }

    public int getLevelToChild() {
        return this.specLvlSelect;
    }

    @NotNull
    public String getManaSymbol() {
        return this.manaChar;
    }

    @NotNull
    public String getManaName() {
        return this.manaName;
    }

    public int getManaMax(int classLevel) {
        Map.Entry<Integer, Integer> entry = this.manaByLevel.floorEntry(classLevel);
        return entry == null ? 0 : entry.getValue();
    }

    public double getManaRegen() {
        return this.manaRegen;
    }

    @NotNull
    public String formatMana(@NotNull String str) {
        str = str.replace("%mana-name%", this.getManaName()).replace("%mana-char%", this.getManaSymbol());
        return str;
    }

    @Nullable
    public ClassAttribute getAttribute(@NotNull ClassAttributeType type) {
        return this.attributes.get((Object)type);
    }

    public double getAttributeValue(@NotNull ClassAttributeType type, int lvl) {
        ClassAttribute a = this.getAttribute(type);
        if (a == null) {
            return 0.0;
        }
        double start = a.getStartValue();
        double per = a.getPerLevelValue();
        double total = start + per * (double)(lvl -= this.lvlStart);
        if (a.getMaxValue() >= 0.0) {
            return Math.min(a.getMaxValue(), total);
        }
        return total;
    }

    @NotNull
    public Map<ClassAspect, ClassAspectBonus> getAspectBonuses() {
        return this.aspects;
    }

    @Nullable
    public ClassAspectBonus getAspectBonus(@NotNull ClassAspect aspect) {
        return this.aspects.get(aspect);
    }

    @Nullable
    public RPGClass getParent() {
        return this.cParent;
    }

    @Nullable
    public RPGClass getFirstParent() {
        RPGClass p;
        for (p = this.cParent; p != null; p = p.getFirstParent()) {
        }
        return p;
    }

    @NotNull
    public Set<RPGClass> getParents() {
        HashSet<RPGClass> set = new HashSet<RPGClass>();
        for (RPGClass p = this.cParent; p != null; p = p.getFirstParent()) {
            set.add(p);
        }
        return set;
    }

    public void setParent(@NotNull RPGClass cParent) {
        this.cParent = cParent;
    }
}

