/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.command;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.api.items.ItemType;
import studio.magemonkey.codex.api.items.exception.MissingItemException;
import studio.magemonkey.codex.api.items.exception.MissingProviderException;
import studio.magemonkey.codex.util.ItemUT;
import studio.magemonkey.codex.util.PlayerUT;
import studio.magemonkey.codex.util.random.Rnd;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.api.DivinityAPI;
import studio.magemonkey.divinity.modules.api.QModuleDrop;
import studio.magemonkey.divinity.modules.command.MCmd;
import studio.magemonkey.divinity.modules.list.itemgenerator.ItemGeneratorManager;

public class MGiveCmd
extends MCmd<QModuleDrop<?>> {
    public MGiveCmd(@NotNull QModuleDrop<?> m) {
        super(m, new String[]{"give"}, "quantumrpg.admin");
    }

    @NotNull
    public String usage() {
        return ((Divinity)this.plugin).lang().Module_Cmd_Give_Usage.getMsg();
    }

    @NotNull
    public String description() {
        return ((Divinity)this.plugin).lang().Module_Cmd_Give_Desc.getMsg();
    }

    public boolean playersOnly() {
        return false;
    }

    @NotNull
    public List<String> getTab(@NotNull Player player, int i, @NotNull String[] args) {
        ItemGeneratorManager itemGeneratorManager;
        ItemGeneratorManager.GeneratorItem generatorItem;
        if (i == 1) {
            return PlayerUT.getPlayerNames();
        }
        if (i == 2) {
            return ((QModuleDrop)this.module).getItemIds();
        }
        if (i == 3) {
            return Arrays.asList("[level]", "-1", "1:5", "1");
        }
        if (i == 4) {
            return Arrays.asList("1", "10");
        }
        if (i == 5 && this.module instanceof ItemGeneratorManager && (generatorItem = (ItemGeneratorManager.GeneratorItem)(itemGeneratorManager = (ItemGeneratorManager)this.module).getItemById(args[2])) != null) {
            List<String> list = generatorItem.getMaterialsList().stream().map(ItemType::getNamespacedID).collect(Collectors.toList());
            return list;
        }
        return super.getTab(player, i, args);
    }

    public void perform(@NotNull CommandSender sender, @NotNull String label, @NotNull String[] args) {
        ItemType material;
        if (args.length < 2) {
            this.printUsage(sender);
            return;
        }
        Player p = ((Divinity)this.plugin).getServer().getPlayer(args[1]);
        if (p == null) {
            this.errPlayer(sender);
            return;
        }
        String id = "random";
        if (args.length >= 3) {
            id = args[2];
        }
        int lMin = -1;
        int lMax = -1;
        int amount = 1;
        if (args.length >= 4) {
            if (args[3].contains(":")) {
                String[] split = args[3].split(":");
                lMin = this.getNumI(sender, split[0], -1, true);
                lMax = this.getNumI(sender, split[1], -1, true);
            } else {
                lMin = lMax = this.getNumI(sender, args[3], -1, true);
            }
        }
        if (args.length >= 5) {
            amount = this.getNumI(sender, args[4], 1);
        }
        ItemStack item = null;
        try {
            material = args.length >= 6 ? CodexEngine.get().getItemManager().getItemType(args[5].toUpperCase()) : null;
        }
        catch (MissingItemException | MissingProviderException e) {
            material = null;
        }
        ItemGeneratorManager itemGenerator = this.module instanceof ItemGeneratorManager ? (ItemGeneratorManager)this.module : null;
        ItemGeneratorManager.GeneratorItem generatorItem = itemGenerator != null ? (ItemGeneratorManager.GeneratorItem)itemGenerator.getItemById(id) : null;
        HashMap<String, Integer> addedItems = new HashMap<String, Integer>();
        for (int i = 0; i < amount; ++i) {
            int iLevel = Rnd.get((int)lMin, (int)lMax);
            item = material != null && generatorItem != null ? generatorItem.create(iLevel, -1, material) : DivinityAPI.getItemByModule((QModuleDrop)this.module, id, iLevel, -1, -1);
            if (item == null) continue;
            ItemUT.addItem((Player)p, (ItemStack[])new ItemStack[]{item});
            String name = ItemUT.getItemName((ItemStack)item);
            addedItems.put(name, addedItems.containsKey(name) ? (Integer)addedItems.get(name) + 1 : 1);
        }
        for (String name : addedItems.keySet()) {
            ((Divinity)this.plugin).lang().Module_Cmd_Give_Done.replace("%player%", (Object)p.getName()).replace("%item%", (Object)name).replace("%amount%", (Object)String.valueOf(addedItems.get(name))).send(sender);
        }
    }
}

