/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.manager.interactions.api;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import lombok.Generated;
import org.bukkit.ChatColor;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.manager.api.task.ITask;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.codex.util.random.Rnd;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.manager.interactions.api.ICustomInteraction;

public class AnimatedSuccessBar
extends ICustomInteraction {
    private final String title;
    private final String barChar;
    private final String barFormat;
    private final ChatColor barColorNeutral;
    private final ChatColor barColorGood;
    private final ChatColor barColorBad;
    private final int barSize;
    private final long fillInterval;
    private final int fillAmount;
    private final double chance;
    private final Function<Boolean, Void> result;
    private int succ;
    private int unsucc;

    private AnimatedSuccessBar(@NotNull Builder builder) {
        super(builder.plugin);
        this.title = builder.barTitle;
        this.barChar = builder.barChar;
        this.barFormat = builder.barFormat;
        this.barColorNeutral = builder.colorNeutral;
        this.barColorGood = builder.colorSuccess;
        this.barColorBad = builder.colorBad;
        this.barSize = builder.barSize;
        this.fillInterval = builder.fillInterval;
        this.fillAmount = builder.fillAmount;
        this.chance = builder.chance;
        this.result = builder.result;
        this.succ = 0;
        this.unsucc = 0;
    }

    @Override
    protected boolean doAction() {
        new Task().start();
        return true;
    }

    private void display() {
        double oneFillSucc = 100.0 / (double)this.barSize;
        StringBuilder barBuilder = new StringBuilder();
        for (int count = 0; count < this.barSize; ++count) {
            if ((double)this.succ >= oneFillSucc * (double)count) {
                barBuilder.append(this.barColorGood);
            } else if ((double)this.unsucc >= (double)(this.barSize - count) * oneFillSucc) {
                barBuilder.append(this.barColorBad);
            } else {
                barBuilder.append(this.barColorNeutral);
            }
            barBuilder.append(this.barChar);
        }
        String bar = this.barFormat.replace("%failure%", String.valueOf(this.unsucc)).replace("%success%", String.valueOf(this.succ)).replace("%bar%", barBuilder.toString());
        boolean isFirst = this.succ + this.unsucc == 0;
        this.player.sendTitle(this.title, bar, isFirst ? 10 : 0, (int)this.fillInterval + 20, 40);
    }

    public static class Builder
    implements Cloneable {
        private final Divinity plugin;
        private final String barTitle;
        private final String barChar;
        private String barFormat;
        private int barSize;
        private ChatColor colorNeutral;
        private ChatColor colorSuccess;
        private ChatColor colorBad;
        private long fillInterval;
        private int fillAmount;
        private double chance;
        private Function<Boolean, Void> result;

        public Builder(@NotNull Divinity plugin, @NotNull String title, @NotNull String barChar) {
            this.plugin = plugin;
            this.barTitle = StringUT.color((String)title);
            this.barChar = StringUT.color((String)barChar);
            this.setBarFormat("%bar%");
            this.setColorNeutral(ChatColor.DARK_GRAY);
            this.setColorSuccess(ChatColor.GREEN);
            this.setColorBad(ChatColor.RED);
            this.setBarSize(20);
            this.setFillInterval(1L);
            this.setFillAmount(1);
            this.setChance(50.0);
            this.setResult(b -> null);
        }

        @NotNull
        public Builder setBarFormat(@NotNull String format) {
            this.barFormat = StringUT.color((String)format);
            return this;
        }

        @NotNull
        public Builder clone() {
            Builder clone = new Builder(this.plugin, this.barTitle, this.barChar);
            clone.barFormat = this.barFormat;
            clone.colorNeutral = this.colorNeutral;
            clone.colorSuccess = this.colorSuccess;
            clone.colorBad = this.colorBad;
            clone.barSize = this.barSize;
            clone.fillInterval = this.fillInterval;
            clone.fillAmount = this.fillAmount;
            clone.chance = this.chance;
            clone.result = this.result;
            return clone;
        }

        @NotNull
        public AnimatedSuccessBar build() {
            return new AnimatedSuccessBar(this);
        }

        @Generated
        public Divinity getPlugin() {
            return this.plugin;
        }

        @Generated
        public String getBarTitle() {
            return this.barTitle;
        }

        @Generated
        public String getBarChar() {
            return this.barChar;
        }

        @Generated
        public String getBarFormat() {
            return this.barFormat;
        }

        @Generated
        public int getBarSize() {
            return this.barSize;
        }

        @Generated
        public ChatColor getColorNeutral() {
            return this.colorNeutral;
        }

        @Generated
        public ChatColor getColorSuccess() {
            return this.colorSuccess;
        }

        @Generated
        public ChatColor getColorBad() {
            return this.colorBad;
        }

        @Generated
        public long getFillInterval() {
            return this.fillInterval;
        }

        @Generated
        public int getFillAmount() {
            return this.fillAmount;
        }

        @Generated
        public double getChance() {
            return this.chance;
        }

        @Generated
        public Function<Boolean, Void> getResult() {
            return this.result;
        }

        @Generated
        public Builder setBarSize(int barSize) {
            this.barSize = barSize;
            return this;
        }

        @Generated
        public Builder setColorNeutral(ChatColor colorNeutral) {
            this.colorNeutral = colorNeutral;
            return this;
        }

        @Generated
        public Builder setColorSuccess(ChatColor colorSuccess) {
            this.colorSuccess = colorSuccess;
            return this;
        }

        @Generated
        public Builder setColorBad(ChatColor colorBad) {
            this.colorBad = colorBad;
            return this;
        }

        @Generated
        public Builder setFillInterval(long fillInterval) {
            this.fillInterval = fillInterval;
            return this;
        }

        @Generated
        public Builder setFillAmount(int fillAmount) {
            this.fillAmount = fillAmount;
            return this;
        }

        @Generated
        public Builder setChance(double chance) {
            this.chance = chance;
            return this;
        }

        @Generated
        public Builder setResult(Function<Boolean, Void> result) {
            this.result = result;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Builder)) {
                return false;
            }
            Builder other = (Builder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getBarSize() != other.getBarSize()) {
                return false;
            }
            if (this.getFillInterval() != other.getFillInterval()) {
                return false;
            }
            if (this.getFillAmount() != other.getFillAmount()) {
                return false;
            }
            if (Double.compare(this.getChance(), other.getChance()) != 0) {
                return false;
            }
            Divinity this$plugin = this.getPlugin();
            Divinity other$plugin = other.getPlugin();
            if (this$plugin == null ? other$plugin != null : !((Object)((Object)this$plugin)).equals((Object)other$plugin)) {
                return false;
            }
            String this$barTitle = this.getBarTitle();
            String other$barTitle = other.getBarTitle();
            if (this$barTitle == null ? other$barTitle != null : !this$barTitle.equals(other$barTitle)) {
                return false;
            }
            String this$barChar = this.getBarChar();
            String other$barChar = other.getBarChar();
            if (this$barChar == null ? other$barChar != null : !this$barChar.equals(other$barChar)) {
                return false;
            }
            String this$barFormat = this.getBarFormat();
            String other$barFormat = other.getBarFormat();
            if (this$barFormat == null ? other$barFormat != null : !this$barFormat.equals(other$barFormat)) {
                return false;
            }
            ChatColor this$colorNeutral = this.getColorNeutral();
            ChatColor other$colorNeutral = other.getColorNeutral();
            if (this$colorNeutral == null ? other$colorNeutral != null : !this$colorNeutral.equals(other$colorNeutral)) {
                return false;
            }
            ChatColor this$colorSuccess = this.getColorSuccess();
            ChatColor other$colorSuccess = other.getColorSuccess();
            if (this$colorSuccess == null ? other$colorSuccess != null : !this$colorSuccess.equals(other$colorSuccess)) {
                return false;
            }
            ChatColor this$colorBad = this.getColorBad();
            ChatColor other$colorBad = other.getColorBad();
            if (this$colorBad == null ? other$colorBad != null : !this$colorBad.equals(other$colorBad)) {
                return false;
            }
            Function<Boolean, Void> this$result = this.getResult();
            Function<Boolean, Void> other$result = other.getResult();
            return !(this$result == null ? other$result != null : !this$result.equals(other$result));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Builder;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getBarSize();
            long $fillInterval = this.getFillInterval();
            result = result * 59 + (int)($fillInterval >>> 32 ^ $fillInterval);
            result = result * 59 + this.getFillAmount();
            long $chance = Double.doubleToLongBits(this.getChance());
            result = result * 59 + (int)($chance >>> 32 ^ $chance);
            Divinity $plugin = this.getPlugin();
            result = result * 59 + ($plugin == null ? 43 : ((Object)((Object)$plugin)).hashCode());
            String $barTitle = this.getBarTitle();
            result = result * 59 + ($barTitle == null ? 43 : $barTitle.hashCode());
            String $barChar = this.getBarChar();
            result = result * 59 + ($barChar == null ? 43 : $barChar.hashCode());
            String $barFormat = this.getBarFormat();
            result = result * 59 + ($barFormat == null ? 43 : $barFormat.hashCode());
            ChatColor $colorNeutral = this.getColorNeutral();
            result = result * 59 + ($colorNeutral == null ? 43 : $colorNeutral.hashCode());
            ChatColor $colorSuccess = this.getColorSuccess();
            result = result * 59 + ($colorSuccess == null ? 43 : $colorSuccess.hashCode());
            ChatColor $colorBad = this.getColorBad();
            result = result * 59 + ($colorBad == null ? 43 : $colorBad.hashCode());
            Function<Boolean, Void> $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AnimatedSuccessBar.Builder(plugin=" + String.valueOf((Object)this.getPlugin()) + ", barTitle=" + this.getBarTitle() + ", barChar=" + this.getBarChar() + ", barFormat=" + this.getBarFormat() + ", barSize=" + this.getBarSize() + ", colorNeutral=" + String.valueOf(this.getColorNeutral()) + ", colorSuccess=" + String.valueOf(this.getColorSuccess()) + ", colorBad=" + String.valueOf(this.getColorBad()) + ", fillInterval=" + this.getFillInterval() + ", fillAmount=" + this.getFillAmount() + ", chance=" + this.getChance() + ", result=" + String.valueOf(this.getResult()) + ")";
        }
    }

    class Task
    extends ITask<Divinity> {
        private final List<Boolean> mappedResult;

        Task() {
            super((CodexPlugin)AnimatedSuccessBar.this.plugin, AnimatedSuccessBar.this.fillInterval, true);
            this.mappedResult = new ArrayList<Boolean>();
            int calculatedResult = Math.round(Rnd.get((boolean)true));
            int iterations = (int)Math.ceil(100.0 / (double)AnimatedSuccessBar.this.fillAmount);
            for (int i = 0; i < iterations; ++i) {
                this.mappedResult.add(i * AnimatedSuccessBar.this.fillAmount < calculatedResult);
            }
        }

        public void action() {
            if (AnimatedSuccessBar.this.player == null || AnimatedSuccessBar.this.player.isDead()) {
                this.stop();
                return;
            }
            AnimatedSuccessBar.this.display();
            if (AnimatedSuccessBar.this.succ + AnimatedSuccessBar.this.unsucc >= 100) {
                ((Divinity)this.plugin).getServer().getScheduler().runTask((Plugin)this.plugin, () -> AnimatedSuccessBar.this.result.apply((double)AnimatedSuccessBar.this.succ >= 100.0 - AnimatedSuccessBar.this.chance));
                AnimatedSuccessBar.this.endAction();
                this.stop();
                return;
            }
            int index = Rnd.get((int)0, (int)(this.mappedResult.size() - 1));
            boolean result = this.mappedResult.get(index);
            this.mappedResult.remove(index);
            if (result) {
                AnimatedSuccessBar.this.succ += AnimatedSuccessBar.this.fillAmount;
            } else {
                AnimatedSuccessBar.this.unsucc += AnimatedSuccessBar.this.fillAmount;
            }
        }
    }
}

