/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.hooks.external;

import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.hooks.HookState;
import studio.magemonkey.codex.hooks.NHook;
import studio.magemonkey.codex.util.NumberUT;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.modules.list.classes.ClassManager;
import studio.magemonkey.divinity.modules.list.classes.api.UserClassData;
import studio.magemonkey.divinity.modules.list.classes.object.ClassAttributeType;
import studio.magemonkey.divinity.stats.EntityStats;
import studio.magemonkey.divinity.stats.items.ItemStats;
import studio.magemonkey.divinity.stats.items.attributes.DamageAttribute;
import studio.magemonkey.divinity.stats.items.attributes.DefenseAttribute;
import studio.magemonkey.divinity.stats.items.attributes.api.TypedStat;

public class PlaceholderAPIHK
extends NHook<Divinity> {
    private QRPGExpansion expansion;

    public PlaceholderAPIHK(@NotNull Divinity plugin) {
        super((CodexPlugin)plugin);
    }

    @NotNull
    public HookState setup() {
        this.expansion = new QRPGExpansion();
        this.expansion.register();
        return HookState.SUCCESS;
    }

    public void shutdown() {
        PlaceholderAPI.unregisterExpansion((PlaceholderExpansion)this.expansion);
    }

    class QRPGExpansion
    extends PlaceholderExpansion {
        private static final String NULL = "null";

        QRPGExpansion() {
        }

        @NotNull
        public String getAuthor() {
            return ((Divinity)PlaceholderAPIHK.this.plugin).getAuthor();
        }

        @NotNull
        public String getIdentifier() {
            return "qrpg";
        }

        @NotNull
        public String getVersion() {
            return ((Divinity)PlaceholderAPIHK.this.plugin).getDescription().getVersion();
        }

        public String onPlaceholderRequest(Player player, String tmp) {
            if (player == null || tmp == null) {
                return null;
            }
            if (tmp.startsWith("itemstat_")) {
                String tt = tmp.replace("itemstat_", "");
                try {
                    TypedStat.Type type = TypedStat.Type.valueOf(tt.toUpperCase());
                    return String.valueOf(NumberUT.round((double)EntityStats.get((LivingEntity)player).getItemStat(type, true)));
                }
                catch (IllegalArgumentException ex) {
                    return NULL;
                }
            }
            if (tmp.startsWith("damage_")) {
                String tt = tmp.replace("damage_", "");
                DamageAttribute dt = ItemStats.getDamageById(tt);
                if (dt == null) {
                    return NULL;
                }
                return String.valueOf(NumberUT.round((double)EntityStats.get((LivingEntity)player).getDamageByType(dt)));
            }
            if (tmp.startsWith("defense_")) {
                String tt = tmp.replace("defense_", "");
                DefenseAttribute dt = ItemStats.getDefenseById(tt);
                if (dt == null) {
                    return NULL;
                }
                return String.valueOf(NumberUT.round((double)EntityStats.get((LivingEntity)player).getDefenseByType(dt)));
            }
            if (tmp.startsWith("class_")) {
                ClassManager classManager = ((Divinity)PlaceholderAPIHK.this.plugin).getModuleCache().getClassManager();
                if (classManager == null) {
                    return NULL;
                }
                UserClassData data = classManager.getUserData(player);
                if (data == null) {
                    return "-";
                }
                String tt = tmp.replace("class_", "");
                if (tt.equalsIgnoreCase("name")) {
                    return data.getPlayerClass().getName();
                }
                if (tt.equalsIgnoreCase("id")) {
                    return data.getPlayerClass().getId();
                }
                if (tt.equalsIgnoreCase("skill_points")) {
                    return String.valueOf(data.getSkillPoints());
                }
                if (tt.equalsIgnoreCase("aspect_points")) {
                    return String.valueOf(data.getAspectPoints());
                }
                if (tt.equalsIgnoreCase("level")) {
                    return String.valueOf(data.getLevel());
                }
                if (tt.equalsIgnoreCase("level-max")) {
                    return String.valueOf(data.getPlayerClass().getMaxLevel());
                }
                if (tt.equalsIgnoreCase("exp")) {
                    return String.valueOf(data.getExp());
                }
                if (tt.equalsIgnoreCase("exp-to-up")) {
                    return String.valueOf(data.getExpToUp(false));
                }
                if (tt.equalsIgnoreCase("exp-max")) {
                    return String.valueOf(data.getExpToUp(true));
                }
                if (tt.startsWith("attribute_")) {
                    String sName = tt.replace("attribute_", "");
                    try {
                        ClassAttributeType stat = ClassAttributeType.valueOf(sName.toUpperCase());
                        return NumberUT.format((double)data.getAttribute(stat));
                    }
                    catch (IllegalArgumentException ex) {
                        return NULL;
                    }
                }
                if (tt.startsWith("aspect_")) {
                    String sName = tt.replace("aspect_", "");
                    return String.valueOf(data.getAspect(sName));
                }
            }
            return null;
        }
    }
}

