/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.util.actions;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.util.actions.params.IParam;
import studio.magemonkey.codex.util.actions.params.IParamResult;
import studio.magemonkey.codex.util.actions.params.IParamValue;

public abstract class Parametized {
    protected final CodexPlugin<?> plugin;
    protected final Set<IParam> params;
    protected final String key;
    protected static final String FLAG_NO_DELAY = "@NODELAY@";
    private static final Map<String, IParamResult> RESULT_CACHE = new HashMap<String, IParamResult>();

    public Parametized(@NotNull CodexPlugin<?> plugin, @NotNull String key) {
        this.plugin = plugin;
        this.params = new HashSet<IParam>();
        this.key = key.toUpperCase();
        this.registerParams();
    }

    @NotNull
    public final String getKey() {
        return this.key;
    }

    public abstract void registerParams();

    @NotNull
    public abstract List<String> getDescription();

    protected final void registerParam(@NotNull String key) {
        IParam param = this.plugin.getActionsManager().getParam(key);
        if (param == null) {
            this.plugin.error("Trying to register invalid param '" + key + "' !");
            return;
        }
        this.params.add(param);
    }

    @NotNull
    public final Set<IParam> getParams() {
        return this.params;
    }

    @NotNull
    protected final IParamResult getParamResult(@NotNull String fullStr) {
        String cache = fullStr.replace(FLAG_NO_DELAY, "");
        if (RESULT_CACHE.containsKey(cache)) {
            return RESULT_CACHE.get(cache);
        }
        HashMap<String, IParamValue> values = new HashMap<String, IParamValue>();
        for (IParam param : this.getParams()) {
            Matcher m;
            String flag = param.getFlag();
            if (!fullStr.contains(flag) || !(m = param.getPattern().matcher(fullStr)).find()) continue;
            String ext = m.group(4).trim();
            IParamValue v = param.getParser().parseValue(ext);
            values.put(param.getKey(), v);
        }
        IParamResult result = new IParamResult(values);
        RESULT_CACHE.put(cache, result);
        return result;
    }

    public static void clearCache() {
        RESULT_CACHE.clear();
    }
}

