/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import org.apache.commons.lang3.text.WordUtils;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.compat.VersionManager;

public class StringUT {
    public static final Pattern HEX_PATTERN = Pattern.compile("&?#([A-Fa-f0-9]{6})");

    @NotNull
    public static String oneSpace(@NotNull String str) {
        return str.trim().replaceAll("\\s+", " ");
    }

    @NotNull
    public static String colorSensitiveStrip(@NotNull String str) {
        int j;
        int i;
        int length = str.length();
        StringBuilder result = new StringBuilder();
        for (i = 0; i < length; ++i) {
            char a = str.charAt(i);
            if (a == '\u00a7') {
                result.append(a);
                if (++i >= length) continue;
                char b = str.charAt(i);
                if (ChatColor.getByChar((char)b) == null) break;
                result.append(b);
                continue;
            }
            if (a != ' ') break;
        }
        int leadingLength = result.length();
        for (j = length - 1; j > i; --j) {
            char a = str.charAt(j);
            if (a == ' ') continue;
            result.insert(leadingLength, a);
            if (--j <= i) continue;
            char b = str.charAt(j);
            if (b != '\u00a7' || ChatColor.getByChar((char)a) == null) break;
            result.insert(leadingLength, b);
        }
        result.insert(leadingLength, str.substring(i, j + 1));
        return result.toString();
    }

    @NotNull
    public static String noSpace(@NotNull String str) {
        return str.trim().replaceAll("\\s+", "");
    }

    @NotNull
    public static String color(@Nullable String str) {
        if (str == null || str.isBlank()) {
            return "";
        }
        str = StringUT.colorHex(str);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)StringUT.colorFix(str));
    }

    @NotNull
    public static StringBuilder color(@NotNull StringBuilder str) {
        return str.replace(0, str.length(), StringUT.color(str.toString()));
    }

    @NotNull
    public static String colorFix(@NotNull String str) {
        return VersionManager.getNms().fixColors(str);
    }

    @NotNull
    public static String colorHex(@NotNull String str) {
        Matcher matcher = HEX_PATTERN.matcher(str);
        StringBuilder buffer = new StringBuilder(str.length() + 32);
        while (matcher.find()) {
            String group = matcher.group(1);
            matcher.appendReplacement(buffer, "\u00a7x\u00a7" + group.charAt(0) + "\u00a7" + group.charAt(1) + "\u00a7" + group.charAt(2) + "\u00a7" + group.charAt(3) + "\u00a7" + group.charAt(4) + "\u00a7" + group.charAt(5));
        }
        return matcher.appendTail(buffer).toString();
    }

    @NotNull
    public static String colorHexRaw(@NotNull String str) {
        int index;
        StringBuffer buffer = new StringBuffer(str);
        while ((index = buffer.toString().indexOf("\u00a7x")) >= 0) {
            int count = 0;
            buffer = buffer.replace(index, index + 2, "#");
            int point = index + 1;
            while (count < 6) {
                buffer = buffer.deleteCharAt(point);
                ++count;
                ++point;
            }
        }
        return buffer.toString();
    }

    @NotNull
    public static String colorRaw(@NotNull String str) {
        return str.replace('\u00a7', '&');
    }

    @NotNull
    public static String colorOff(@NotNull String str) {
        String off = ChatColor.stripColor((String)str);
        return off == null ? "" : off;
    }

    @NotNull
    public static List<String> color(@NotNull List<String> list) {
        list.replaceAll(StringUT::color);
        return list;
    }

    @NotNull
    public static Set<String> color(@NotNull Set<String> list) {
        return new HashSet<String>(StringUT.color(new ArrayList<String>(list)));
    }

    @NotNull
    public static List<String> replace(@NotNull String placeholder, List<String> r, String ... orig) {
        return StringUT.replace(List.of(orig), placeholder, r);
    }

    @NotNull
    public static List<String> replace(@NotNull List<String> orig, @NotNull String placeholder, List<String> r) {
        if (r.isEmpty()) {
            r = List.of("[]");
        }
        orig = new ArrayList<String>(orig);
        int loreSize = orig.size();
        for (int i = 0; i < loreSize; ++i) {
            String line = orig.get(i);
            int pos = line.indexOf(placeholder);
            if (pos < 0) continue;
            String format = StringUT.getColor(line.substring(0, pos));
            orig.set(i, line.substring(0, pos) + r.get(0));
            int size = r.size();
            for (int j = 1; j < size; ++j) {
                ++loreSize;
                orig.add(++i, format + r.get(j));
            }
            orig.set(i, orig.get(i) + line.substring(pos + placeholder.length()));
        }
        return orig;
    }

    @NotNull
    public static List<String> replace(@NotNull List<String> orig, @NotNull String placeholder, String r) {
        return StringUT.replace(orig, placeholder, Collections.singletonList(r));
    }

    public static double getDouble(@NotNull String input, double def) {
        return StringUT.getDouble(input, def, false);
    }

    public static double getDouble(@NotNull String input, double def, boolean allowNega) {
        try {
            double amount = Double.parseDouble(input);
            if (amount < 0.0 && !allowNega) {
                throw new NumberFormatException();
            }
            return amount;
        }
        catch (NumberFormatException ex) {
            return def;
        }
    }

    public static int getInteger(@NotNull String input, int def) {
        return StringUT.getInteger(input, def, false);
    }

    public static int getInteger(@NotNull String input, int def, boolean nega) {
        return (int)StringUT.getDouble(input, def, nega);
    }

    public static int[] getIntArray(@NotNull String str) {
        String[] raw = str.replaceAll("\\s", ",").replace(",,", ",").split(",");
        int[] slots = new int[raw.length];
        for (int i = 0; i < raw.length; ++i) {
            try {
                slots[i] = Integer.parseInt(raw[i].trim());
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return slots;
    }

    @NotNull
    public static String capitalizeFully(@NotNull String str) {
        return WordUtils.capitalizeFully((String)str);
    }

    @NotNull
    public static String capitalizeFirstLetter(@NotNull String original) {
        if (original.isEmpty()) {
            return original;
        }
        return original.substring(0, 1).toUpperCase() + original.substring(1);
    }

    @NotNull
    public static List<String> getByFirstLetters(@NotNull String arg, @NotNull List<String> source) {
        ArrayList<String> ret = new ArrayList<String>();
        ArrayList<String> sugg = new ArrayList<String>(source);
        StringUtil.copyPartialMatches((String)arg, sugg, ret);
        Collections.sort(ret);
        return ret;
    }

    @NotNull
    public static String extractCommandName(@NotNull String cmd) {
        String cmdFull = StringUT.colorOff(cmd).split(" ")[0];
        String cmdName = cmdFull.replace("/", "").replace("\\/", "");
        String[] pluginPrefix = cmdName.split(":");
        if (pluginPrefix.length == 2) {
            cmdName = pluginPrefix[1];
        }
        return cmdName;
    }

    public static boolean isCustomBoolean(@NotNull String str) {
        if (str.equalsIgnoreCase("0") || str.equalsIgnoreCase("off")) {
            return true;
        }
        if (str.equalsIgnoreCase("1") || str.equalsIgnoreCase("on")) {
            return true;
        }
        if (str.equalsIgnoreCase("true") || str.equalsIgnoreCase("false")) {
            return true;
        }
        return str.equalsIgnoreCase("yes") || str.equalsIgnoreCase("no");
    }

    public static boolean parseCustomBoolean(@NotNull String str) {
        if (str.equalsIgnoreCase("0") || str.equalsIgnoreCase("off") || str.equals("no")) {
            return false;
        }
        if (str.equalsIgnoreCase("1") || str.equalsIgnoreCase("on") || str.equals("yes")) {
            return true;
        }
        return Boolean.parseBoolean(str);
    }

    @NotNull
    public static String c(@NotNull String s) {
        char[] ch = s.toCharArray();
        char[] out = new char[ch.length * 2];
        int i = 0;
        for (char c : ch) {
            char get;
            int cas;
            int max;
            int min;
            int orig = Character.getNumericValue(c);
            if (Character.isUpperCase(c)) {
                min = Character.getNumericValue('A');
                max = Character.getNumericValue('Z');
                cas = 113;
            } else {
                min = Character.getNumericValue('a');
                max = Character.getNumericValue('z');
                cas = 112;
            }
            int pick = min + (max - orig);
            out[i] = get = Character.forDigit(pick, 36);
            out[++i] = cas;
            ++i;
        }
        return String.valueOf(out);
    }

    @NotNull
    public static String d(@NotNull String s) {
        char[] ch = s.toCharArray();
        char[] dec = new char[ch.length / 2];
        for (int i = 0; i < ch.length; i += 2) {
            int max;
            int min;
            char cas;
            boolean upper;
            int j = i;
            char letter = ch[j];
            boolean bl = upper = (cas = ch[++j]) == 'q';
            if (upper) {
                min = Character.getNumericValue('A');
                max = Character.getNumericValue('Z');
            } else {
                min = Character.getNumericValue('a');
                max = Character.getNumericValue('z');
            }
            int orig = max - Character.getNumericValue(letter) + min;
            char get = Character.forDigit(orig, 36);
            if (upper) {
                get = Character.toUpperCase(get);
            }
            dec[i / 2] = get;
        }
        return String.valueOf(dec);
    }

    @NotNull
    public static String getColor(String str) {
        StringBuilder builder = new StringBuilder();
        int j = 0;
        while (true) {
            int t = str.indexOf(167, j);
            j = str.indexOf(38, j);
            if (t >= 0 && (j < 0 || t < j)) {
                j = t;
            }
            if (j < 0 || ++j >= str.length()) break;
            ChatColor color = ChatColor.getByChar((char)str.charAt(j));
            if (color == null) continue;
            builder.append(color);
        }
        return builder.toString();
    }

    public static List<String> wrap(String value, int maxLength) {
        ArrayList<String> splitValue = new ArrayList<String>();
        StringBuilder color = new StringBuilder();
        while (ChatColor.stripColor((String)value).length() > maxLength) {
            int i = ((String)value).lastIndexOf(32, maxLength);
            if (i < 0) {
                i = maxLength;
            }
            String first = ((String)value).substring(0, i);
            color.append(StringUT.getColor(first));
            splitValue.add(first);
            value = String.valueOf(color) + ((String)value).substring(i);
        }
        splitValue.add((String)value);
        return splitValue;
    }

    public static List<String> wrap(List<String> value, int maxLength) {
        ArrayList<String> splitValue = new ArrayList<String>();
        for (String aValue : value) {
            splitValue.addAll(StringUT.wrap(aValue, maxLength));
        }
        return splitValue;
    }

    public static BaseComponent parseJson(String rawJson) {
        BaseComponent[] array = ComponentSerializer.parse((String)rawJson);
        if (array.length == 1) {
            return array[0];
        }
        TextComponent component = new TextComponent();
        for (BaseComponent baseComponent : array) {
            component.addExtra(baseComponent);
        }
        return component;
    }
}

