/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.mccore.config.parse;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.yaml.snakeyaml.error.YAMLException;
import studio.magemonkey.codex.mccore.config.parse.DataSection;

public class YAMLParser {
    private static final Pattern LIST_PATTERN = Pattern.compile(" *- .+");
    private static final Pattern MULTILINE_MARKER = Pattern.compile(".+: ([|>]|['\"]?.+).*");
    private List<String> comments = new ArrayList<String>();
    private int i = 0;

    public DataSection parseResource(Plugin plugin, String path) {
        DataSection dataSection;
        block9: {
            InputStream read = plugin.getClass().getResourceAsStream("/" + path);
            try {
                int bytes;
                StringBuilder builder = new StringBuilder();
                byte[] data = new byte[1024];
                do {
                    bytes = read.read(data);
                    builder.append(new String(data, 0, bytes, StandardCharsets.UTF_8));
                } while (bytes == 1024);
                dataSection = this.parseText(builder.toString());
                if (read == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (read != null) {
                        try {
                            read.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    Bukkit.getLogger().info("Failed to parse resource (" + path + ") - " + ex.getMessage());
                    return new DataSection();
                }
            }
            read.close();
        }
        return dataSection;
    }

    public DataSection parseFile(String path) {
        return this.parseFile(new File(path));
    }

    public DataSection parseFile(File file) {
        try {
            if (file.exists()) {
                FileInputStream read = new FileInputStream(file);
                byte[] data = new byte[(int)file.length()];
                read.read(data);
                read.close();
                return this.parseText(new String(data, StandardCharsets.UTF_8));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return new DataSection();
    }

    public DataSection parseText(String text) {
        return this.parseText(text, '\'');
    }

    public DataSection parseText(String text, char quote) {
        if (text == null) {
            return new DataSection();
        }
        text = text.replaceAll("\r\n", "\n").replaceAll("\n *\n", "\n").replaceAll(" +\n", "\n");
        String[] lines = text.split("\n");
        this.i = 0;
        return this.parse(lines, 0, quote);
    }

    private DataSection parse(String[] lines, int indent, char quote) {
        int spaces;
        DataSection data = new DataSection();
        while (this.i < lines.length && ((spaces = this.countSpaces(lines[this.i])) >= indent || lines[this.i].length() == 0 || lines[this.i].charAt(spaces) == '#')) {
            block30: {
                String entry = lines[this.i];
                if (entry.trim().isEmpty()) {
                    ++this.i;
                    continue;
                }
                if (entry.charAt(spaces) == '#') {
                    this.comments.add(entry.substring(spaces + 1));
                    ++this.i;
                    continue;
                }
                while (this.i < lines.length && spaces != indent) {
                    ++this.i;
                }
                if (this.i == lines.length) {
                    return data;
                }
                try {
                    String key = entry.substring(indent, entry.indexOf(58));
                    if (key.charAt(0) == '\'' && key.charAt(key.length() - 1) == '\'' || key.charAt(0) == '\"' && key.charAt(key.length() - 1) == '\"') {
                        key = key.substring(1, key.length() - 1);
                    }
                    data.setComments(key, this.comments);
                    this.comments.clear();
                    if (entry.indexOf(": {}") == entry.length() - 4 && entry.length() >= 4) {
                        data.createSection(key);
                        break block30;
                    }
                    if (this.i < lines.length - 1 && lines[this.i + 1].length() > indent + 1 && LIST_PATTERN.matcher(lines[this.i + 1].substring(indent)).matches() && (this.countSpaces(lines[this.i + 1]) == indent || this.countSpaces(lines[this.i + 1]) == indent + 2)) {
                        int listIndent = this.countSpaces(lines[this.i + 1]);
                        ArrayList<String> stringList = new ArrayList<String>();
                        while (++this.i < lines.length && lines[this.i].length() > listIndent && LIST_PATTERN.matcher(lines[this.i].substring(listIndent)).matches()) {
                            if (this.i + 1 < lines.length && this.countSpaces(lines[this.i + 1]) > listIndent) {
                                stringList.add(this.buildMultiline(lines, listIndent, quote, lines[this.i]));
                                continue;
                            }
                            String str = lines[this.i].substring(listIndent + 2);
                            if (str.length() > 0 && str.charAt(0) == quote) {
                                while (str.length() > 0 && str.charAt(0) == quote) {
                                    str = str.substring(1, str.length() - 1);
                                }
                            } else if (str.length() > 0 && str.charAt(0) == '\"') {
                                while (str.length() > 0 && str.charAt(0) == '\"') {
                                    str = str.substring(1, str.length() - 1);
                                }
                            } else if (str.length() > 0 && str.charAt(0) == '\'') {
                                while (str.length() > 0 && str.charAt(0) == '\'') {
                                    str = str.substring(1, str.length() - 1);
                                }
                            }
                            str = str.replace("\\'", "'").replace("\\\"", "\"");
                            stringList.add(str);
                        }
                        data.set(key, stringList);
                        --this.i;
                        break block30;
                    }
                    if (entry.substring(indent).startsWith(key + ": [") && entry.endsWith("]")) {
                        String value = entry.substring(entry.indexOf(91) + 1, entry.lastIndexOf(93));
                        String[] parts = value.split(", *");
                        ArrayList<String> list = new ArrayList<String>();
                        for (String part : parts) {
                            if (part.startsWith("'") || part.startsWith("\"")) {
                                part = part.substring(1, part.length() - 1);
                            }
                            if ((part = part.replace("\\'", "'").replace("\\\"", "\"")).isBlank()) continue;
                            list.add(part);
                        }
                        data.set(key, list);
                    } else {
                        if (this.i < lines.length - 1 && this.countSpaces(lines[this.i + 1]) > indent) {
                            if (MULTILINE_MARKER.matcher(entry).matches() && StringUtils.isNotBlank((CharSequence)lines[this.i + 1])) {
                                data.set(key, this.buildMultiline(lines, indent, quote, entry));
                                ++this.i;
                                continue;
                            }
                            ++this.i;
                            int newIndent = this.countSpaces(lines[this.i]);
                            DataSection node = this.parse(lines, newIndent, quote);
                            data.set(key, node);
                            continue;
                        }
                        if (entry.indexOf(58) == entry.length() - 1) {
                            data.set(key, new DataSection());
                        } else {
                            String str = entry.substring(entry.indexOf(58) + 2);
                            Object value = str.charAt(0) == quote ? str.substring(1, str.length() - 1) : (str.charAt(0) == '\'' ? str.substring(1, str.length() - 1) : (str.charAt(0) == '\"' ? str.substring(1, str.length() - 1) : str));
                            if ((value = value.toString().replace("\\'", "'").replace("\\\"", "\"")).equals("[]")) {
                                value = new ArrayList();
                            }
                            data.set(key, value);
                        }
                    }
                }
                catch (Exception e) {
                    if (e instanceof YAMLException) {
                        throw (YAMLException)e;
                    }
                    throw new YAMLException("There was a problem parsing the YAML file at line " + (this.i + 1) + " \"" + entry + "\": " + e.getMessage(), (Throwable)e);
                }
            }
            ++this.i;
        }
        return data;
    }

    private String buildMultiline(String[] lines, int indent, char quote, String entry) {
        int spaces;
        StringBuilder multiLine = new StringBuilder();
        String str = LIST_PATTERN.matcher(entry).matches() ? entry.substring(entry.indexOf(45) + 2) : (entry.contains(":") ? entry.substring(entry.indexOf(58) + 2) : entry.substring(indent + 2));
        boolean piped = false;
        boolean folded = false;
        if (str.length() > 0 && str.charAt(0) == '|') {
            piped = true;
        } else if (str.length() > 0 && str.charAt(0) == '>') {
            folded = true;
        }
        if (piped || folded) {
            while (this.i + 1 < lines.length && this.countSpaces(lines[this.i + 1]) > indent) {
                String line;
                if ((line = lines[++this.i].substring(indent + 2)).isBlank()) {
                    multiLine.append('\n');
                    continue;
                }
                if (multiLine.length() > 0) {
                    multiLine.append(piped ? (char)'\n' : ' ');
                }
                multiLine.append(line);
                boolean inList = this.i + 1 < lines.length && this.countSpaces(lines[this.i + 1]) > indent;
                if (inList) continue;
                break;
            }
            return multiLine.toString();
        }
        String quoteChar = "";
        if (str.length() > 0 && str.charAt(0) == quote) {
            quoteChar = String.valueOf(quote);
        } else if (str.length() > 0 && str.charAt(0) == '\'') {
            quoteChar = "'";
        } else if (str.length() > 0 && str.charAt(0) == '\"') {
            quoteChar = "\"";
        }
        if (quoteChar.isEmpty()) {
            multiLine.append(str);
        } else {
            if (!quoteChar.isBlank() && str.endsWith(quoteChar)) {
                multiLine.append(str.substring(1, str.length() - 1));
                return multiLine.toString();
            }
            multiLine.append(str.substring(quoteChar.length()));
        }
        while (this.i + 1 < lines.length && (spaces = this.countSpaces(lines[this.i + 1])) > indent) {
            String line;
            if ((line = lines[++this.i]).isBlank()) {
                multiLine.append('\n');
                continue;
            }
            if (!quoteChar.isBlank() && line.endsWith(quoteChar)) {
                multiLine.append(" ").append(line.substring(spaces, line.length() - 1));
                break;
            }
            multiLine.append(" ").append(line.substring(spaces));
            boolean inList = this.i + 1 < lines.length && this.countSpaces(lines[this.i + 1]) > indent;
            if (inList) continue;
            break;
        }
        return multiLine.toString();
    }

    private int countSpaces(String line) {
        return IntStream.range(0, line.length()).filter(i -> line.charAt(i) != ' ').findFirst().orElse(0);
    }

    public void save(DataSection data, String path) {
        this.save(data, new File(path));
    }

    public void save(DataSection data, File file) {
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException("Couldn't save config to " + file.getName(), e);
            }
        }
        try (FileOutputStream out = new FileOutputStream(file);
             BufferedWriter write = new BufferedWriter(new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8));){
            this.save(data, write);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void save(DataSection data, BufferedWriter write) throws IOException {
        StringBuilder sb = new StringBuilder();
        this.dump(data, sb, 0, '\'');
        write.write(sb.toString());
    }

    public void dump(DataSection data, StringBuilder builder, int indent, char quote) {
        Object spacing = "";
        for (int i = 0; i < indent; ++i) {
            spacing = (String)spacing + " ";
        }
        for (String key : data.keys()) {
            if (data.hasComment(key)) {
                List<String> lines = data.getComments(key);
                for (String line : lines) {
                    if (line.length() == 0) {
                        builder.append('\n');
                        continue;
                    }
                    builder.append((String)spacing);
                    builder.append('#');
                    builder.append(line);
                    builder.append('\n');
                }
            }
            builder.append((String)spacing);
            if (key.matches("^[a-zA-Z0-9_]+$")) {
                builder.append(key);
            } else if (key.contains("" + quote)) {
                String tempKey = key;
                String tempQuote = "\"";
                if (tempKey.contains(tempQuote)) {
                    tempKey = tempKey.replace(tempQuote, "\\" + tempQuote);
                }
                builder.append(tempQuote).append(tempKey).append(tempQuote);
            } else {
                builder.append(quote).append(key).append(quote);
            }
            builder.append(": ");
            Object value = data.get(key);
            if (value == null) {
                builder.append("{}\n");
                continue;
            }
            if (value instanceof DataSection) {
                DataSection child = (DataSection)value;
                if (child.size() == 0) {
                    builder.append("{}\n");
                    continue;
                }
                builder.append('\n');
                this.dump(child, builder, indent + 2, quote);
                continue;
            }
            if (value instanceof List) {
                List list = (List)value;
                if (list.size() == 0) {
                    builder.append("[]");
                    builder.append('\n');
                    continue;
                }
                builder.append('\n');
                for (Object item : list) {
                    builder.append((String)spacing);
                    builder.append("- ");
                    this.writeValue(builder, item, quote);
                    builder.append('\n');
                }
                continue;
            }
            this.writeValue(builder, value, quote);
            builder.append('\n');
        }
    }

    private void writeValue(StringBuilder builder, Object value, char quote) {
        if (value instanceof Number) {
            builder.append(value);
        } else if (value.toString().contains("" + quote)) {
            builder.append('\"');
            builder.append(value);
            builder.append('\"');
        } else {
            builder.append(quote);
            builder.append(value);
            builder.append(quote);
        }
    }
}

