/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.mccore.chat;

import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.commands.api.ISubCommand;
import studio.magemonkey.codex.mccore.chat.Chat;
import studio.magemonkey.codex.mccore.chat.ChatData;
import studio.magemonkey.codex.mccore.chat.ChatNodes;
import studio.magemonkey.codex.mccore.chat.Prefix;

class ListCommand<P extends CodexPlugin<P>>
extends ISubCommand<P> {
    ListCommand(P plugin) {
        super(plugin, List.of("list"), ChatNodes.LIST.getNode());
    }

    @Override
    public void perform(@NotNull CommandSender sender, @NotNull String label, @NotNull String[] args) {
        ChatData data = Chat.getPlayerData(sender.getName());
        if (data != null) {
            StringBuilder message = new StringBuilder(String.valueOf(ChatColor.DARK_GREEN) + "Unlocked prefixes: ");
            if (!data.unlockedPrefixes.isEmpty()) {
                for (Prefix prefix : data.unlockedPrefixes) {
                    message.append(prefix.text).append(ChatColor.GRAY).append(", ");
                }
                message = new StringBuilder(message.substring(0, message.length() - 2));
            }
            sender.sendMessage(message.toString());
        } else {
            this.printUsage(sender);
        }
    }

    @Override
    @NotNull
    public String description() {
        return "Displays unlocked prefixes";
    }

    @Override
    @NotNull
    public String usage() {
        return "";
    }

    @Override
    public boolean playersOnly() {
        return true;
    }
}

