/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.util.eval.javaluator;

import java.util.Collections;
import studio.magemonkey.codex.util.eval.javaluator.BracketPair;
import studio.magemonkey.codex.util.eval.javaluator.Function;
import studio.magemonkey.codex.util.eval.javaluator.Operator;

public class Token {
    static final Token FUNCTION_ARG_SEPARATOR = new Token(Kind.FUNCTION_SEPARATOR, null);
    private Kind kind;
    private Object content;
    private String line;
    private int lineNum;
    private int startPosition;
    private static final int LINE_CHARS_TO_SHOW = 30;

    public static Token buildLiteral(String literal) {
        return new Token(Kind.LITERAL, literal);
    }

    public static Token buildOperator(Operator ope) {
        return new Token(Kind.OPERATOR, ope);
    }

    public static Token buildFunction(Function function) {
        return new Token(Kind.FUNCTION, function);
    }

    public static Token buildOpenToken(BracketPair pair) {
        return new Token(Kind.OPEN_BRACKET, pair);
    }

    public static Token buildCloseToken(BracketPair pair) {
        return new Token(Kind.CLOSE_BRACKET, pair);
    }

    public static Token buildArgumentSeparator(String strToken) {
        return new Token(Kind.FUNCTION_SEPARATOR, strToken);
    }

    public String appendTokenInfo(String msg) {
        msg = (String)msg + "\n";
        if (this.line.length() <= 30) {
            msg = (String)msg + String.format("At position %s of line number %s\n", this.startPosition, this.lineNum);
            msg = (String)msg + "   " + this.line + "\n";
            msg = (String)msg + "   " + String.join((CharSequence)"", Collections.nCopies(this.startPosition, " ")) + "^";
        }
        return (String)msg + "\n";
    }

    public Token setLineInfo(String line, int lineNum, int startPosition, int endPosition) {
        this.line = line;
        this.lineNum = lineNum;
        this.startPosition = startPosition;
        return this;
    }

    protected Token(Kind kind, Object content) {
        if (kind.equals((Object)Kind.OPERATOR) && !(content instanceof Operator) || kind.equals((Object)Kind.FUNCTION) && !(content instanceof Function) || kind.equals((Object)Kind.LITERAL) && !(content instanceof String)) {
            throw new IllegalArgumentException();
        }
        this.kind = kind;
        this.content = content;
    }

    public BracketPair getBrackets() {
        return (BracketPair)this.content;
    }

    public Operator getOperator() {
        return (Operator)this.content;
    }

    public Function getFunction() {
        return (Function)this.content;
    }

    public Kind getKind() {
        return this.kind;
    }

    public String getString() {
        if (this.kind.equals((Object)Kind.OPEN_BRACKET)) {
            return ((BracketPair)this.content).getOpen();
        }
        if (this.kind.equals((Object)Kind.CLOSE_BRACKET)) {
            return ((BracketPair)this.content).getClose();
        }
        return this.content.toString();
    }

    public boolean isOperator() {
        return this.kind.equals((Object)Kind.OPERATOR);
    }

    public boolean isFunction() {
        return this.kind.equals((Object)Kind.FUNCTION);
    }

    public boolean isOpenBracket() {
        return this.kind.equals((Object)Kind.OPEN_BRACKET);
    }

    public boolean isCloseBracket() {
        return this.kind.equals((Object)Kind.CLOSE_BRACKET);
    }

    public boolean isFunctionArgumentSeparator() {
        return this.kind.equals((Object)Kind.FUNCTION_SEPARATOR);
    }

    public boolean isLiteral() {
        return this.kind.equals((Object)Kind.LITERAL);
    }

    public Operator.Associativity getAssociativity() {
        return this.getOperator().getAssociativity();
    }

    public int getPrecedence() {
        return this.getOperator().getPrecedence();
    }

    public String getLiteral() {
        if (!this.kind.equals((Object)Kind.LITERAL)) {
            throw new IllegalArgumentException();
        }
        return this.getString();
    }

    public String toString() {
        return "Token [kind=" + String.valueOf((Object)this.kind) + ", content=" + String.valueOf(this.content) + "]";
    }

    public static enum Kind {
        OPEN_BRACKET,
        CLOSE_BRACKET,
        FUNCTION_SEPARATOR,
        FUNCTION,
        OPERATOR,
        LITERAL;

    }
}

