/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.util.eval.javaluator;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import studio.magemonkey.codex.util.eval.javaluator.AbstractVariableSet;
import studio.magemonkey.codex.util.eval.javaluator.BracketPair;
import studio.magemonkey.codex.util.eval.javaluator.Constant;
import studio.magemonkey.codex.util.eval.javaluator.EvaluationContext;
import studio.magemonkey.codex.util.eval.javaluator.Function;
import studio.magemonkey.codex.util.eval.javaluator.Operator;
import studio.magemonkey.codex.util.eval.javaluator.Parameters;
import studio.magemonkey.codex.util.eval.javaluator.Token;
import studio.magemonkey.codex.util.eval.javaluator.Tokenizer;

public abstract class AbstractEvaluator<T>
implements EvaluationContext {
    protected final Tokenizer tokenizer;
    protected final Map<String, Function> functions;
    protected final Map<String, List<Operator>> operators;
    protected final Map<String, Constant> constants;
    protected final String functionArgumentSeparator;
    protected final Map<String, BracketPair> functionBrackets;
    protected final Map<String, BracketPair> expressionBrackets;

    protected AbstractEvaluator(Parameters parameters) {
        ArrayList<String> tokenDelimitersBuilder = new ArrayList<String>();
        this.functions = new HashMap<String, Function>();
        this.operators = new HashMap<String, List<Operator>>();
        this.constants = new HashMap<String, Constant>();
        this.functionBrackets = new HashMap<String, BracketPair>();
        for (BracketPair pair : parameters.getFunctionBrackets()) {
            this.functionBrackets.put(pair.getOpen(), pair);
            this.functionBrackets.put(pair.getClose(), pair);
            tokenDelimitersBuilder.add(pair.getOpen());
            tokenDelimitersBuilder.add(pair.getClose());
        }
        this.expressionBrackets = new HashMap<String, BracketPair>();
        for (BracketPair pair : parameters.getExpressionBrackets()) {
            this.expressionBrackets.put(pair.getOpen(), pair);
            this.expressionBrackets.put(pair.getClose(), pair);
            tokenDelimitersBuilder.add(pair.getOpen());
            tokenDelimitersBuilder.add(pair.getClose());
        }
        if (this.operators != null) {
            for (Operator ope : parameters.getOperators()) {
                tokenDelimitersBuilder.add(ope.getSymbol());
                List<Operator> known = this.operators.get(ope.getSymbol());
                if (known == null) {
                    known = new ArrayList<Operator>();
                    this.operators.put(ope.getSymbol(), known);
                }
                known.add(ope);
                if (known.size() <= 1) continue;
                this.validateHomonyms(known);
            }
        }
        boolean needFunctionSeparator = false;
        if (parameters.getFunctions() != null) {
            for (Function function : parameters.getFunctions()) {
                this.functions.put(parameters.getTranslation(function.getName()), function);
                if (function.getMaximumArgumentCount() <= 1) continue;
                needFunctionSeparator = true;
            }
        }
        if (parameters.getConstants() != null) {
            for (Constant constant : parameters.getConstants()) {
                this.constants.put(parameters.getTranslation(constant.getName()), constant);
            }
        }
        this.functionArgumentSeparator = parameters.getFunctionArgumentSeparator();
        if (needFunctionSeparator) {
            tokenDelimitersBuilder.add(this.functionArgumentSeparator);
        }
        this.tokenizer = new Tokenizer(tokenDelimitersBuilder, this.functions, this.operators, this.constants, this.functionArgumentSeparator, this.functionBrackets, this.expressionBrackets);
    }

    private void validateHomonyms(List<Operator> operators) {
        if (operators.size() > 2) {
            throw new IllegalArgumentException();
        }
    }

    protected void output(Deque<T> values, Token token, EvaluationContext evaluationContext) {
        if (token.isLiteral()) {
            Object value;
            String literal = token.getLiteral();
            Constant ct = this.constants.get(literal);
            Object e = value = ct == null ? null : (Object)this.evaluate(ct, evaluationContext);
            if (value == null && evaluationContext != null && evaluationContext instanceof AbstractVariableSet) {
                value = ((AbstractVariableSet)evaluationContext).get(literal);
            }
            values.push(value != null ? value : (Object)this.toValue(token, evaluationContext));
        } else if (token.isOperator()) {
            Operator operator = token.getOperator();
            values.push(this.evaluate(operator, this.getArguments(values, operator.getOperandCount()), evaluationContext));
        } else {
            throw evaluationContext.getError("", token);
        }
    }

    protected T evaluate(Constant constant, EvaluationContext evaluationContext) {
        throw new RuntimeException("evaluate(Constant) is not implemented for " + constant.getName());
    }

    protected T evaluate(Operator operator, Iterator<T> operands, EvaluationContext evaluationContext) {
        throw new RuntimeException("evaluate(Operator, Iterator) is not implemented for " + operator.getSymbol());
    }

    protected T evaluate(Function function, Iterator<T> arguments, EvaluationContext evaluationContext) {
        throw new RuntimeException("evaluate(Function, Iterator) is not implemented for " + function.getName());
    }

    protected void doFunction(Deque<T> values, Token functionTok, int argCount, EvaluationContext evaluationContext) {
        Function function = functionTok.getFunction();
        if (function.getMinimumArgumentCount() > argCount || function.getMaximumArgumentCount() < argCount) {
            throw evaluationContext.getError("Invalid argument count for " + function.getName(), functionTok);
        }
        values.push(this.evaluate(function, this.getArguments(values, argCount), evaluationContext));
    }

    protected Iterator<T> getArguments(Deque<T> values, int nb) {
        if (values.size() < nb) {
            throw new IllegalArgumentException();
        }
        LinkedList<T> result = new LinkedList<T>();
        for (int i = 0; i < nb; ++i) {
            result.addFirst(values.pop());
        }
        return result.iterator();
    }

    protected abstract T toValue(Token var1, EvaluationContext var2);

    public T evaluate(String expression) {
        return this.evaluate(expression, (EvaluationContext)this);
    }

    public T evaluate(String expression, EvaluationContext evaluationContext) {
        ArrayDeque values = new ArrayDeque();
        ArrayDeque<Token> stack = new ArrayDeque<Token>();
        ArrayDeque<Integer> previousValuesSize = this.functions.isEmpty() ? null : new ArrayDeque<Integer>();
        Collection<Token> tokens = this.tokenize(expression);
        Token previous = null;
        for (Token token : tokens) {
            String strToken = token.toString();
            switch (token.getKind()) {
                case OPEN_BRACKET: {
                    stack.push(token);
                    if (previous != null && previous.isFunction()) {
                        if (this.functionBrackets.containsKey(token.getBrackets().getOpen())) break;
                        throw evaluationContext.getError("Invalid bracket after function: " + strToken, token);
                    }
                    if (this.expressionBrackets.containsKey(token.getBrackets().getOpen())) break;
                    throw evaluationContext.getError("Invalid bracket in expression: " + strToken, token);
                }
                case CLOSE_BRACKET: {
                    if (previous == null) {
                        throw evaluationContext.getError("expression can't start with a close bracket", token);
                    }
                    if (previous.isFunctionArgumentSeparator()) {
                        throw evaluationContext.getError("argument is missing", token);
                    }
                    BracketPair brackets = token.getBrackets();
                    boolean openBracketFound = false;
                    while (!stack.isEmpty()) {
                        Token sc = (Token)stack.pop();
                        if (sc.isOpenBracket()) {
                            if (sc.getBrackets().equals(brackets)) {
                                openBracketFound = true;
                                break;
                            }
                            throw evaluationContext.getError("Invalid parenthesis match " + sc.getBrackets().getOpen() + brackets.getClose(), token);
                        }
                        this.output(values, sc, evaluationContext);
                    }
                    if (!openBracketFound) {
                        throw evaluationContext.getError("Parentheses mismatched", token);
                    }
                    if (stack.isEmpty() || !((Token)stack.peek()).isFunction()) break;
                    int argCount = values.size() - (Integer)previousValuesSize.pop();
                    this.doFunction(values, (Token)stack.pop(), argCount, evaluationContext);
                    break;
                }
                case FUNCTION_SEPARATOR: {
                    if (previous == null) {
                        throw evaluationContext.getError("expression can't start with a function argument separator", token);
                    }
                    if (previous.isOpenBracket() || previous.isFunctionArgumentSeparator()) {
                        throw evaluationContext.getError("argument is missing", token);
                    }
                    boolean pe = false;
                    while (!stack.isEmpty()) {
                        if (((Token)stack.peek()).isOpenBracket()) {
                            pe = true;
                            break;
                        }
                        this.output(values, (Token)stack.pop(), evaluationContext);
                    }
                    if (!pe) {
                        throw evaluationContext.getError("Separator or parentheses mismatched", token);
                    }
                    Token openBracket = (Token)stack.pop();
                    Token scopeToken = (Token)stack.peek();
                    stack.push(openBracket);
                    if (scopeToken.isFunction()) break;
                    throw evaluationContext.getError("Argument separator used outside of function scope", token);
                }
                case FUNCTION: {
                    stack.push(token);
                    previousValuesSize.push(values.size());
                    break;
                }
                case OPERATOR: {
                    Token sc;
                    while (!stack.isEmpty() && (sc = (Token)stack.peek()).isOperator() && (token.getAssociativity().equals((Object)Operator.Associativity.LEFT) && token.getPrecedence() <= sc.getPrecedence() || token.getPrecedence() < sc.getPrecedence())) {
                        this.output(values, (Token)stack.pop(), evaluationContext);
                    }
                    stack.push(token);
                    break;
                }
                case LITERAL: {
                    if (previous != null && previous.isLiteral()) {
                        throw evaluationContext.getError("A literal can't follow another literal", token);
                    }
                    this.output(values, token, evaluationContext);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            previous = token;
        }
        while (!stack.isEmpty()) {
            Token sc = (Token)stack.pop();
            if (sc.isOpenBracket() || sc.isCloseBracket()) {
                throw evaluationContext.getError("Parentheses mismatched", sc);
            }
            this.output(values, sc, evaluationContext);
        }
        if (values.size() != 1) {
            throw new IllegalArgumentException();
        }
        return (T)values.pop();
    }

    protected BracketPair getBracketPair(String token) {
        BracketPair result = this.expressionBrackets.get(token);
        return result == null ? this.functionBrackets.get(token) : result;
    }

    public Collection<Operator> getOperators() {
        ArrayList<Operator> result = new ArrayList<Operator>();
        Collection<List<Operator>> values = this.operators.values();
        for (List<Operator> list : values) {
            result.addAll(list);
        }
        return result;
    }

    public Collection<Function> getFunctions() {
        return this.functions.values();
    }

    public Collection<Constant> getConstants() {
        return this.constants.values();
    }

    protected Collection<Token> tokenize(String expression) {
        return this.tokenizer.tokenize(expression);
    }
}

