/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.util.actions.conditions;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.util.actions.ActionManipulator;
import studio.magemonkey.codex.util.actions.Parametized;
import studio.magemonkey.codex.util.actions.params.IParamResult;

public abstract class IConditionValidator
extends Parametized {
    public IConditionValidator(@NotNull CodexPlugin<?> plugin, @NotNull String key) {
        super(plugin, key);
        this.registerParam("MESSAGE");
        this.registerParam("FILTER");
    }

    public abstract boolean mustHaveTarget();

    @Nullable
    protected abstract Predicate<Entity> validate(@NotNull Entity var1, @NotNull Set<Entity> var2, @NotNull IParamResult var3);

    public final boolean process(@NotNull Entity exe, @NotNull Map<String, Set<Entity>> targetMap, @NotNull String fullStr) {
        return this.process(exe, targetMap, fullStr, null);
    }

    public final boolean process(@NotNull Entity exe, @NotNull Map<String, Set<Entity>> targetMap, @NotNull String fullStr, @Nullable ActionManipulator manipulator) {
        String[] tsSplit;
        IParamResult result = this.getParamResult(fullStr);
        if (this.mustHaveTarget() && !result.hasParam("TARGET") && targetMap.isEmpty()) {
            this.plugin.warn("No Target specified for condition: " + fullStr);
            return false;
        }
        HashSet<Entity> targets = new HashSet<Entity>();
        for (String ts : tsSplit = result.getParamValue("TARGET").getString("").split(",")) {
            if (ts.isEmpty()) continue;
            if (targetMap.containsKey(ts = ts.toLowerCase())) {
                targets.addAll((Collection<Entity>)targetMap.get(ts));
                continue;
            }
            this.plugin.warn("Invalid Target specified for condition: " + fullStr);
        }
        if (targets.isEmpty()) {
            if (targetMap.containsKey("default")) {
                targets.addAll((Collection)targetMap.get("default"));
            } else {
                if (this.mustHaveTarget()) {
                    return false;
                }
                targets.add(exe);
            }
        }
        boolean isFilter = result.getParamValue("FILTER").getBoolean();
        Predicate<Entity> predicate = this.validate(exe, targets, result);
        if (predicate == null) {
            this.plugin.error("Could not validate condition: '" + fullStr + "'. Skipping...");
            return true;
        }
        String msg = result.getParamValue("MESSAGE").getString(null);
        if (isFilter) {
            targets.removeIf(target -> {
                if (!predicate.test((Entity)target)) {
                    if (msg != null) {
                        target.sendMessage(msg);
                    }
                    return true;
                }
                return false;
            });
        } else if (!targets.stream().allMatch(predicate)) {
            if (msg != null) {
                targets.forEach(target -> target.sendMessage(msg));
            }
            return false;
        }
        for (String targetId : tsSplit) {
            if (!targetMap.containsKey(targetId = targetId.toLowerCase())) continue;
            targetMap.get(targetId).removeIf(target2 -> !targets.contains(target2));
        }
        return true;
    }
}

