/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.util;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.Codex;
import studio.magemonkey.codex.adventure.adventure.text.serializer.legacy.LegacyComponentSerializer;
import studio.magemonkey.codex.util.ClickText;
import studio.magemonkey.codex.util.SoundUT;
import studio.magemonkey.codex.util.StringUT;

public class MsgUT {
    private static final Pattern PATTERN_JSON_FULL = Pattern.compile("(\\{json:)+(.)+?(\\})+(.*?)(\\{end-json\\})");
    private static final Pattern PATTERN_JSON_ARGUMENTS = Pattern.compile("(\\{json:)+(.)+?(\\})+(.*?)(\\})?");
    private static final String[] JSON_ARGUMENTS = new String[]{"hint", "chat-type", "chat-suggest", "url"};

    public static void sendActionBar(@NotNull Player player, @NotNull String msg) {
        boolean useLegacyActionBar = Codex.getPlugin().getConfig().getBoolean("action-bar-legacy", false);
        if (useLegacyActionBar) {
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)StringUT.color(msg)));
        } else {
            studio.magemonkey.codex.adventure.adventure.text.TextComponent component = LegacyComponentSerializer.legacySection().deserialize(msg);
            Codex.getAudience().player(player).sendActionBar(component);
        }
    }

    @Deprecated
    public static void sendTitles(@NotNull Player player, @NotNull String title, @NotNull String subtitle, int fadeIn, int stay, int fadeOut) {
        player.sendTitle(title, subtitle, fadeIn, stay, fadeOut);
    }

    public static void sound(@NotNull Player player, @NotNull String sound) {
        if (sound.isEmpty()) {
            return;
        }
        float pitch = 0.9f;
        if (sound.contains(":")) {
            pitch = (float)StringUT.getDouble(sound.split(":")[1], 0.9);
            sound = sound.split(":")[0];
        }
        try {
            Keyed s = SoundUT.getSound(sound.toUpperCase());
            player.playSound(player.getLocation(), s.getKey().toString(), pitch, pitch);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static void sound(@NotNull Player player, @NotNull Sound sound) {
        player.playSound(player.getLocation(), sound, 0.9f, 0.9f);
    }

    public static void sound(@NotNull Location loc, @NotNull String sound) {
        if (sound.isEmpty()) {
            return;
        }
        World w = loc.getWorld();
        if (w == null) {
            return;
        }
        float pitch = 0.9f;
        if (sound.contains(":")) {
            pitch = (float)StringUT.getDouble(sound.split(":")[1], 0.9);
            sound = sound.split(":")[0];
        }
        try {
            Keyed s = SoundUT.getSound(sound.toUpperCase());
            w.playSound(loc, s.getKey().toString(), pitch, pitch);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static boolean isJSON(@NotNull String str) {
        return str.contains("json:");
    }

    public static void sendWithJSON(@NotNull CommandSender p, @NotNull String orig) {
        if (!MsgUT.isJSON(orig = StringUT.color(orig))) {
            p.sendMessage(orig);
            return;
        }
        Matcher mFull = PATTERN_JSON_FULL.matcher(orig);
        if (!(p instanceof Player)) {
            while (mFull.find()) {
                String textToJS = mFull.group(4);
                String full = mFull.group(0);
                orig = orig.replace(full, textToJS);
            }
            p.sendMessage(orig);
            return;
        }
        HashMap<String[], ClickText.ClickWord> jsonMap = new HashMap<String[], ClickText.ClickWord>();
        while (mFull.find()) {
            String textToJS = mFull.group(4);
            String full = mFull.group(0);
            String textPlaceholder = "%" + textToJS.replace(" ", "__space__") + "%";
            orig = orig.replace(full, textPlaceholder);
            Matcher mArgs = PATTERN_JSON_ARGUMENTS.matcher(full);
            if (!mArgs.find()) continue;
            String arguments = mArgs.group(0).replace("{json:", "").replace("}", "").trim();
            ClickText.ClickWord cw = new ClickText(textToJS).createPlaceholder(textPlaceholder, textToJS);
            block14: for (String argType : JSON_ARGUMENTS) {
                Pattern pArgVal = Pattern.compile("(~)+(" + argType + ")+?(:)+(.*?)(;)");
                Matcher mArgVal = pArgVal.matcher(arguments);
                if (!mArgVal.find()) continue;
                String argValue = mArgVal.group(4).trim();
                switch (argType) {
                    case "hint": {
                        cw.hint(argValue.split("\\|"));
                        continue block14;
                    }
                    case "chat-type": {
                        cw.execCmd(argValue);
                        continue block14;
                    }
                    case "chat-suggest": {
                        cw.suggCmd(argValue);
                        continue block14;
                    }
                    case "url": {
                        cw.url(argValue);
                    }
                }
            }
            jsonMap.put(new String[]{textPlaceholder, textToJS}, cw);
        }
        ClickText clickText = new ClickText(orig);
        for (Map.Entry e : jsonMap.entrySet()) {
            String textPlaceholder = ((String[])e.getKey())[0];
            String textOriginal = ((String[])e.getKey())[1];
            ClickText.ClickWord jsonData = (ClickText.ClickWord)e.getValue();
            ClickText.ClickWord clickWord = clickText.createPlaceholder(textPlaceholder, textOriginal);
            clickWord.click = jsonData.click;
            clickWord.hover = jsonData.hover;
        }
        clickText.send(p);
    }
}

