/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.modules;

import java.io.File;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.core.config.CoreConfig;
import studio.magemonkey.codex.manager.api.Loadable;
import studio.magemonkey.codex.modules.IExternalModule;
import studio.magemonkey.codex.modules.IModule;
import studio.magemonkey.codex.util.FileUT;

public class ModuleManager<P extends CodexPlugin<P>>
implements Loadable {
    @NotNull
    private P plugin;
    private Map<String, IModule<P>> modules;
    private List<IExternalModule<P>> externalCache;

    public ModuleManager(@NotNull P plugin) {
        this.plugin = plugin;
    }

    @Override
    public void setup() {
        this.modules = new LinkedHashMap<String, IModule<P>>();
        this.externalCache = new ArrayList<IExternalModule<P>>();
        ((CodexPlugin)this.plugin).getConfigManager().extractFullPath(String.valueOf(this.plugin.getDataFolder()) + CoreConfig.MODULES_PATH_EXTERNAL, "jar");
        FileUT.getFiles(String.valueOf(this.plugin.getDataFolder()) + CoreConfig.MODULES_PATH_EXTERNAL, false).forEach(file -> {
            IExternalModule<P> module = this.loadFromFile((File)file);
            if (module != null) {
                this.externalCache.add(module);
            }
        });
        ((CodexPlugin)this.plugin).info("Found " + this.externalCache.size() + " external module(s).");
    }

    @Override
    public void shutdown() {
        for (IModule<P> module : new HashMap<String, IModule<P>>(this.modules).values()) {
            this.unregister(module);
        }
        this.modules.clear();
    }

    @Nullable
    public IModule<P> register(@NotNull IModule<P> module) {
        if (!module.isEnabled()) {
            return null;
        }
        String id = module.getId();
        if (this.modules.containsKey(id)) {
            ((CodexPlugin)this.plugin).error("Could not register " + id + " module! Module with such id already registered!");
            return null;
        }
        long loadTook = System.currentTimeMillis();
        module.load();
        loadTook = System.currentTimeMillis() - loadTook;
        if (!module.isLoaded()) {
            ((CodexPlugin)this.plugin).error("Failed module load: " + module.name() + " v" + module.version());
            return null;
        }
        ((CodexPlugin)this.plugin).info("Loaded module: " + module.name() + " v" + module.version() + " in " + loadTook + " ms.");
        this.modules.put(id, module);
        return module;
    }

    public void registerExternal(@NotNull IExternalModule.LoadPriority priority) {
        this.externalCache.removeIf(module -> {
            if (module.getPriority() == priority) {
                this.register((IModule<P>)module);
                return true;
            }
            return false;
        });
    }

    public void unregister(@NotNull IModule<?> module) {
        String id = module.getId();
        if (this.modules.remove(id) != null) {
            ((CodexPlugin)this.plugin).info("Unloaded module: " + module.name() + " v" + module.version());
        }
        module.unload();
    }

    @Nullable
    public <T extends IModule<P>> T getModule(@NotNull Class<T> clazz) {
        for (IModule<P> module : this.modules.values()) {
            if (!clazz.isAssignableFrom(module.getClass())) continue;
            return (T)module;
        }
        return null;
    }

    @Nullable
    public IModule<P> getModule(@NotNull String id) {
        return this.modules.get(id.toLowerCase());
    }

    @NotNull
    public Collection<IModule<P>> getModules() {
        return this.modules.values();
    }

    @Nullable
    public IExternalModule<P> loadFromFile(@NotNull File jar) {
        if (!jar.getName().endsWith(".jar")) {
            return null;
        }
        try {
            JarFile jarFile = new JarFile(jar);
            Enumeration<JarEntry> jarEntry = jarFile.entries();
            URL[] urls = new URL[]{new URL("jar:file:" + jar.getPath() + "!/")};
            URLClassLoader loader = URLClassLoader.newInstance(urls, ((CodexPlugin)this.plugin).getClazzLoader());
            while (jarEntry.hasMoreElements()) {
                Class<IExternalModule> mainClass;
                Constructor<IExternalModule> con;
                IExternalModule module;
                String className;
                Class<?> clazz;
                JarEntry entry = jarEntry.nextElement();
                if (entry.isDirectory() || !entry.getName().endsWith(".class") || !IExternalModule.class.isAssignableFrom(clazz = Class.forName(className = entry.getName().substring(0, entry.getName().length() - 6).replace('/', '.'), false, loader)) || (module = (con = (mainClass = clazz.asSubclass(IExternalModule.class)).getConstructor(this.plugin.getClass())).newInstance(this.plugin)) == null) continue;
                return module;
            }
        }
        catch (Exception e) {
            ((CodexPlugin)this.plugin).error("Could not load external module: " + jar.getName());
            e.printStackTrace();
        }
        return null;
    }
}

