/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.mccore.scoreboard;

import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.commands.api.ISubCommand;
import studio.magemonkey.codex.mccore.scoreboard.BoardManager;
import studio.magemonkey.codex.mccore.scoreboard.PlayerBoards;
import studio.magemonkey.codex.mccore.scoreboard.ScoreboardNodes;

public class CycleCommand<P extends CodexPlugin<P>>
extends ISubCommand<P> {
    CycleCommand(P plugin) {
        super(plugin, List.of("cycle"), ScoreboardNodes.CYCLE.getNode());
    }

    @Override
    public void perform(@NotNull CommandSender sender, @NotNull String label, @NotNull String[] args) {
        if (sender instanceof Player) {
            PlayerBoards board = BoardManager.getPlayerBoards(sender.getName());
            if (board.isCycling()) {
                sender.sendMessage(String.valueOf(ChatColor.DARK_RED) + "Your scoreboard is already cycling");
            } else {
                board.startCycling();
                sender.sendMessage(String.valueOf(ChatColor.DARK_GREEN) + "Your scoreboard is now cycling");
            }
        } else {
            this.printUsage(sender);
        }
    }

    @Override
    @NotNull
    public String usage() {
        return "";
    }

    @Override
    @NotNull
    public String description() {
        return "Makes the scoreboard cycle";
    }

    @Override
    public boolean playersOnly() {
        return true;
    }
}

