/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.mccore.gui;

import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import studio.magemonkey.codex.mccore.config.Config;
import studio.magemonkey.codex.mccore.gui.MapFont;
import studio.magemonkey.codex.mccore.gui.MapImage;
import studio.magemonkey.codex.mccore.gui.MapImageManager;

public class MapScheme {
    private static final HashMap<String, MapScheme> schemes = new HashMap();
    private static final String SCHEME_FILE = "schemes.yml";
    private static final String FONTS = "fonts";
    private static final String FAMILY = "family";
    private static final String SIZE = "size";
    private static final String STYLE = "style";
    private static final String SPACE = "space";
    private static final String COLORS = "colors";
    private HashMap<String, MapImage> images = new HashMap();
    private HashMap<String, MapFont> fonts = new HashMap();
    private HashMap<String, Byte> colors = new HashMap();
    private JavaPlugin plugin;
    private File root;
    private File folder;
    private String key = "default";
    private boolean finalized = false;

    private MapScheme(JavaPlugin plugin, File root) {
        this.plugin = plugin;
        this.root = root;
        schemes.put(plugin.getName() + "_" + this.key, this);
        this.folder = new File(root, "default");
        this.folder.mkdirs();
    }

    private MapScheme(String name, JavaPlugin plugin) {
        this.key = name;
        schemes.put(plugin.getName() + "_" + this.key, this);
    }

    public static MapScheme create(JavaPlugin plugin, File root) {
        return new MapScheme(plugin, root);
    }

    public static MapScheme get(JavaPlugin plugin, String name) {
        String key = plugin.getName() + "_" + name.toLowerCase();
        return schemes.containsKey(key) ? schemes.get(key) : schemes.get(plugin.getName() + "_default");
    }

    public static ArrayList<MapScheme> list(JavaPlugin plugin) {
        ArrayList<MapScheme> list = new ArrayList<MapScheme>();
        for (String key : schemes.keySet()) {
            if (!key.startsWith(plugin.getName() + "_")) continue;
            list.add(schemes.get(key));
        }
        return list;
    }

    public String getKey() {
        return this.key;
    }

    public MapImage getImage(String key) {
        return this.images.get(key);
    }

    public MapFont getFont(String key) {
        return this.fonts.get(key);
    }

    public byte getColor(String key) {
        return this.colors.get(key);
    }

    public void defineImg(String image) {
        this.defineImg(image, image);
    }

    public void defineImg(String key, String image) {
        if (this.finalized) {
            return;
        }
        try {
            image = (String)image + ".png";
            MapImageManager.copyImageResource(this.plugin, (String)image, this.folder.getAbsolutePath());
            this.images.put(key, new MapImage(new File(this.folder, (String)image)));
        }
        catch (Exception ex) {
            Bukkit.getLogger().warning("Invalid scheme image " + this.key + ":" + key);
        }
    }

    public void defineFont(String key, MapFont defaultFont) {
        if (this.finalized) {
            return;
        }
        if (defaultFont == null) {
            Bukkit.getLogger().warning("Invalid scheme font " + this.key + ":" + key);
        } else {
            this.fonts.put(key, defaultFont);
        }
    }

    public void defineColor(String key, String colorHex) {
        if (this.finalized) {
            return;
        }
        try {
            colorHex = ((String)colorHex).replace("#", "");
            if (!((String)colorHex).startsWith("0X")) {
                colorHex = "0X" + (String)colorHex;
            }
            this.colors.put(key, MapImage.matchColor(Color.decode((String)colorHex)));
        }
        catch (Exception ex) {
            Bukkit.getLogger().warning("Invalid scheme color " + this.key + ":" + key);
        }
    }

    public void finalize() {
        File[] files;
        if (this.finalized) {
            return;
        }
        this.finalized = true;
        for (File file : files = this.root.listFiles()) {
            if (file.getName().equals("default")) continue;
            this.load(file);
        }
        Config configFile = new Config(this.plugin, SCHEME_FILE);
        configFile.clear();
        this.save((ConfigurationSection)configFile.getConfig());
        for (File file : files) {
            if (file.getName().equals("default")) continue;
            MapScheme scheme = MapScheme.get(this.plugin, file.getName());
            scheme.save((ConfigurationSection)configFile.getConfig());
        }
        configFile.save();
    }

    private void save(ConfigurationSection config) {
        ConfigurationSection scheme = config.createSection(this.key);
        ConfigurationSection fontSection = scheme.createSection(FONTS);
        for (String s : this.fonts.keySet()) {
            MapFont font = this.fonts.get(s);
            ConfigurationSection fontData = fontSection.createSection(s);
            fontData.set(FAMILY, (Object)font.getFont().getFamily());
            fontData.set(SIZE, (Object)font.getFont().getSize());
            fontData.set(STYLE, (Object)font.getFont().getStyle());
            fontData.set(SPACE, (Object)font.getSpace());
        }
        ConfigurationSection colorSection = scheme.createSection(COLORS);
        for (String s : this.colors.keySet()) {
            colorSection.set(s, (Object)Integer.toHexString(MapImage.getColor(this.colors.get(s)).getRGB()));
        }
    }

    private MapScheme load(File folder) {
        try {
            String name = folder.getName();
            MapScheme scheme = new MapScheme(name, this.plugin);
            scheme.key = name.toLowerCase();
            for (String s : this.images.keySet()) {
                try {
                    File image = new File(folder, s + ".png");
                    scheme.images.put(s, image.exists() ? new MapImage(image) : this.images.get(s));
                }
                catch (Exception ex) {
                    Bukkit.getLogger().info("Invalid scheme image " + name + ":" + s);
                    scheme.images.put(s, this.images.get(s));
                }
            }
            Config configFile = new Config(scheme.plugin, SCHEME_FILE);
            FileConfiguration config = configFile.getConfig();
            if (config.contains(name)) {
                ConfigurationSection data = config.getConfigurationSection(name);
                if (data.contains(FONTS)) {
                    ConfigurationSection fonts = data.getConfigurationSection(FONTS);
                    for (String s : this.fonts.keySet()) {
                        try {
                            if (!fonts.contains(s)) continue;
                            ConfigurationSection fontData = fonts.getConfigurationSection(s);
                            MapFont d = this.fonts.get(s);
                            String family = fontData.getString(FAMILY, d.getFont().getFamily());
                            int size = fontData.getInt(SIZE, d.getFont().getSize());
                            int style = fontData.getInt(STYLE, d.getFont().getStyle());
                            int space = fontData.getInt(SPACE, d.getSpace());
                            scheme.fonts.put(s, new MapFont(new Font(family, style, size), space));
                        }
                        catch (Exception ex) {
                            Bukkit.getLogger().warning("Invalid scheme font " + name + ":" + s);
                            scheme.fonts.put(s, this.fonts.get(s));
                        }
                    }
                } else {
                    scheme.fonts = this.fonts;
                }
                if (data.contains(COLORS)) {
                    ConfigurationSection colorData = data.getConfigurationSection(COLORS);
                    for (String s : this.colors.keySet()) {
                        if (colorData.contains(s)) {
                            scheme.colors.put(s, MapImage.matchColor(Color.decode(colorData.getString(s))));
                            continue;
                        }
                        scheme.colors.put(s, this.colors.get(s));
                    }
                } else {
                    scheme.colors = this.colors;
                }
            }
            return scheme;
        }
        catch (Exception ex) {
            Bukkit.getLogger().info("Invalid scheme: " + folder.getName());
            return null;
        }
    }
}

