/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.mccore.gui;

import studio.magemonkey.codex.mccore.gui.MapImage;

public class MapObject {
    private static final int[] FLAG_BOUNDS = new int[4];
    protected MapImage img;
    protected int x;
    protected int y;
    protected boolean visible;
    private boolean first = true;
    private int lastX = 0;
    private int lastY = 0;
    private boolean lastVisible = false;

    public MapObject(MapImage img, int x, int y) {
        this(img, x, y, true);
    }

    public MapObject(MapImage img, int x, int y, boolean visible) {
        this.img = img;
        this.x = x;
        this.y = y;
        this.visible = visible;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.img.getWidth();
    }

    public int getHeight() {
        return this.img.getHeight();
    }

    public void hide() {
        this.visible = false;
    }

    public void show() {
        this.visible = true;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void move(int x, int y) {
        this.x += x;
        this.y += y;
    }

    public void moveTo(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public boolean isDirty() {
        return this.first && this.visible || this.x != this.lastX || this.y != this.lastY || this.visible != this.lastVisible;
    }

    public int[] getFlagBounds() {
        if (this.first || this.visible && !this.lastVisible) {
            MapObject.FLAG_BOUNDS[0] = this.x;
            MapObject.FLAG_BOUNDS[1] = this.y;
            MapObject.FLAG_BOUNDS[2] = this.x + this.img.getWidth() - 1;
            MapObject.FLAG_BOUNDS[3] = this.y + this.img.getHeight() - 1;
        } else if (this.visible && this.lastVisible) {
            MapObject.FLAG_BOUNDS[0] = Math.min(this.x, this.lastX);
            MapObject.FLAG_BOUNDS[1] = Math.min(this.y, this.lastY);
            MapObject.FLAG_BOUNDS[2] = Math.max(this.x, this.lastX) + this.img.getWidth() - 1;
            MapObject.FLAG_BOUNDS[3] = Math.max(this.y, this.lastY) + this.img.getHeight() - 1;
        } else if (this.lastVisible) {
            MapObject.FLAG_BOUNDS[0] = this.lastX;
            MapObject.FLAG_BOUNDS[1] = this.lastY;
            MapObject.FLAG_BOUNDS[2] = this.lastX + this.img.getWidth() - 1;
            MapObject.FLAG_BOUNDS[3] = this.lastY + this.img.getHeight() - 1;
        }
        MapObject.FLAG_BOUNDS[0] = Math.max(0, FLAG_BOUNDS[0]);
        MapObject.FLAG_BOUNDS[1] = Math.max(0, FLAG_BOUNDS[1]);
        MapObject.FLAG_BOUNDS[2] = Math.min(127, FLAG_BOUNDS[2]);
        MapObject.FLAG_BOUNDS[3] = Math.min(127, FLAG_BOUNDS[3]);
        return FLAG_BOUNDS;
    }

    public void clean() {
        this.first = false;
        this.lastX = this.x;
        this.lastY = this.y;
        this.lastVisible = this.visible;
    }
}

