/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.mccore.gui;

import java.util.HashMap;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;
import studio.magemonkey.codex.mccore.gui.MapBuffer;
import studio.magemonkey.codex.mccore.gui.MapMenu;

public class MapData
extends MapRenderer {
    private HashMap<String, MapMenu> current = new HashMap();
    private MapBuffer buffer;
    private MapMenu root;
    private MapView view;
    private ItemStack map;
    private boolean firstPass = true;

    public MapData(MapMenu root, MapView view) {
        this.root = root;
        this.view = view;
        this.buffer = new MapBuffer(view);
        this.map = new ItemStack(Material.MAP, 1, (short)view.getId());
        for (MapRenderer r : view.getRenderers()) {
            view.removeRenderer(r);
        }
        view.addRenderer((MapRenderer)this);
    }

    public void render(MapView mapView, MapCanvas mapCanvas, Player player) {
        ItemStack item = player.getItemInHand();
        if (item == null || item.getType() != Material.MAP || item.getDurability() != this.view.getId()) {
            return;
        }
        if (this.firstPass) {
            this.firstPass = false;
            player.sendMap(mapView);
            return;
        }
        this.firstPass = true;
        this.getMenu(player).render(this.buffer, player);
        this.buffer.drawTo(mapCanvas);
    }

    public ItemStack getMapItem() {
        return this.map;
    }

    public MapMenu getMenu(Player player) {
        if (!this.current.containsKey(player.getName())) {
            this.current.put(player.getName(), this.root);
            this.setup(this.root, player);
            return this.root;
        }
        return this.current.get(player.getName());
    }

    public void back(Player player) {
        if (!this.current.containsKey(player.getName())) {
            return;
        }
        MapMenu c = this.current.get(player.getName());
        if (c == this.root) {
            return;
        }
        this.current.put(player.getName(), c.getParent());
        this.setup(c.getParent(), player);
    }

    public void next(Player player, MapMenu menu) {
        if (this.getMenu(player) == menu.getParent()) {
            this.current.put(player.getName(), menu);
            this.setup(menu, player);
        }
    }

    private void setup(MapMenu menu, Player player) {
        MapMenu.setSelection(player, 0);
        MapMenu.getScene(player).clear();
        menu.setup(player);
    }

    public void clear(Player player) {
        this.current.remove(player.getName());
    }
}

