/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.mccore.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import studio.magemonkey.codex.mccore.config.ISavable;

public class Config {
    private final HashMap<ISavable, String> savables = new HashMap();
    private final String fileName;
    private final JavaPlugin plugin;
    private File configFile;
    private FileConfiguration fileConfiguration;

    public Config(JavaPlugin plugin, String name) {
        this.plugin = plugin;
        this.fileName = name + ".yml";
        this.configFile = new File(plugin.getDataFolder().getAbsolutePath() + "/" + this.fileName);
        try {
            String path = this.configFile.getAbsolutePath();
            if (new File(path.substring(0, path.lastIndexOf(File.separator))).mkdirs()) {
                plugin.getLogger().info("Created a new folder for config files");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Deprecated
    public static void setDefaults(ConfigurationSection config) {
    }

    public static void trim(ConfigurationSection config) {
        if (config.getDefaultSection() != null) {
            ConfigurationSection d = config.getDefaultSection();
            for (String key : config.getKeys(false)) {
                if (!d.contains(key)) {
                    config.set(key, null);
                    continue;
                }
                if (!config.isConfigurationSection(key)) continue;
                Config.trim(config.getConfigurationSection(key));
            }
        } else {
            for (String key : config.getKeys(false)) {
                config.set(key, null);
            }
        }
    }

    public static void clear(ConfigurationSection config) {
        for (String key : config.getKeys(false)) {
            config.set(key, null);
        }
    }

    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    public String getFile() {
        return this.fileName.replace(".yml", "");
    }

    public void clear() {
        Config.clear((ConfigurationSection)this.getConfig());
    }

    public void save() {
        if (this.savables.size() > 0) {
            for (Map.Entry<ISavable, String> entry : this.savables.entrySet()) {
                entry.getKey().save((ConfigurationSection)this.getConfig(), entry.getValue());
            }
        }
        this.saveConfig();
    }

    public void addSavable(ISavable savable, String basePath) {
        this.savables.put(savable, basePath);
    }

    public void deleteSavable(ISavable savable) {
        if (this.savables.containsKey(savable)) {
            String base = this.savables.get(savable);
            if (base.length() > 0 && base.charAt(base.length() - 1) == '.') {
                base = base.substring(0, base.length() - 1);
            }
            this.getConfig().set(base, null);
            this.savables.remove(savable);
        }
    }

    public void reloadConfig() {
        this.fileConfiguration = YamlConfiguration.loadConfiguration((File)this.configFile);
        InputStream defConfigStream = this.plugin.getResource(this.fileName);
        if (defConfigStream != null) {
            YamlConfiguration defConfig = null;
            defConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defConfigStream, StandardCharsets.UTF_8));
            this.fileConfiguration.setDefaults((Configuration)defConfig);
        }
    }

    public FileConfiguration getConfig() {
        if (this.fileConfiguration == null) {
            this.reloadConfig();
        }
        return this.fileConfiguration;
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public void saveConfig() {
        if (this.fileConfiguration != null || this.configFile != null) {
            try {
                this.getConfig().save(this.configFile);
            }
            catch (IOException ex) {
                this.plugin.getLogger().log(Level.SEVERE, "Could not save config to " + String.valueOf(this.configFile), ex);
            }
        }
    }

    public void saveDefaultConfig() {
        if (this.configFile == null) {
            this.configFile = new File(this.plugin.getDataFolder().getAbsolutePath() + "/" + this.fileName);
        }
        if (!this.configFile.exists()) {
            this.plugin.saveResource(this.fileName, false);
        }
    }

    public void checkDefaults() {
        FileConfiguration config = this.getConfig();
        Config.setDefaults((ConfigurationSection)config);
        this.saveConfig();
    }

    public void trim() {
        FileConfiguration config = this.getConfig();
        Config.trim((ConfigurationSection)config);
        this.saveConfig();
    }
}

