/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.manager.api.menu;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.Codex;
import studio.magemonkey.codex.compat.VersionManager;
import studio.magemonkey.codex.manager.api.menu.Slot;
import studio.magemonkey.codex.util.StringUT;

public abstract class Menu
implements InventoryHolder {
    private static final Map<Player, Menu> ACTIVE_MENUS = new HashMap<Player, Menu>();
    protected final Player player;
    protected final String title;
    protected final int rows;
    protected Inventory inventory;
    protected final TreeMap<Integer, Slot> slots = new TreeMap();
    private final Set<Listener> listeners = new HashSet<Listener>();
    private final Set<BukkitTask> tasks = new HashSet<BukkitTask>();
    private int page = 0;
    protected Menu parentMenu;
    protected boolean opening = false;
    protected boolean fakeClosing = false;

    @Nullable
    public static Menu getOpenMenu(Player player) {
        return ACTIVE_MENUS.get(player);
    }

    public Menu(Player player, int rows, String title) {
        this.player = player;
        this.title = StringUT.color(title);
        this.rows = rows;
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)(rows * 9), (String)title);
    }

    public Player getPlayer() {
        return this.player;
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    public int getPages() {
        try {
            return (this.slots.lastKey() - 1) / this.inventory.getSize() + 1;
        }
        catch (NoSuchElementException e) {
            return 1;
        }
    }

    public void setSlot(int i, @Nullable Slot slot) {
        if (slot == null) {
            this.slots.remove(i);
        } else {
            this.slots.put(i, slot);
            slot.setMenu(i, this);
        }
    }

    public void clearSlots() {
        this.slots.clear();
        this.inventory.clear();
    }

    public abstract void setContents();

    @Nullable
    public Slot getSlot(int i) {
        return this.slots.get(i);
    }

    public void openSync() {
        new BukkitRunnable(){

            public void run() {
                Menu.this.open();
            }
        }.runTask((Plugin)Codex.getPlugin());
    }

    public void open() {
        this.open(this.page);
    }

    public void open(int page) {
        Menu oldMenu = ACTIVE_MENUS.get(this.player);
        if (oldMenu != null && oldMenu != this && !oldMenu.isOpening()) {
            oldMenu.onClose();
        }
        ACTIVE_MENUS.put(this.player, this);
        this.slots.clear();
        this.setContents();
        int finalPage = page % this.getPages();
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)(this.rows * 9), (String)this.title.replace("%page%", String.valueOf(finalPage + 1)).replace("%pages%", String.valueOf(this.getPages())));
        int last = this.inventory.getSize();
        for (int i = 0; i < last; ++i) {
            Slot slot = this.slots.get(finalPage * this.inventory.getSize() + i);
            if (slot == null) continue;
            this.inventory.setItem(i, slot.getItemStack());
        }
        this.opening = true;
        this.player.openInventory(this.inventory);
        this.opening = false;
        this.page = finalPage;
    }

    public void openSubMenu(Menu menu) {
        menu.parentMenu = this;
        this.opening = true;
        menu.open();
        this.opening = false;
    }

    public void close() {
        this.close(1);
    }

    public void close(int layers) {
        for (int i = 1; i <= layers; ++i) {
            new BukkitRunnable(){

                public void run() {
                    Menu.this.player.closeInventory();
                }
            }.runTaskLater((Plugin)Codex.getPlugin(), (long)i);
        }
    }

    public void onClose() {
        if (this.fakeClosing) {
            this.fakeClosing = false;
            return;
        }
        for (Listener listener : this.listeners) {
            HandlerList.unregisterAll((Listener)listener);
        }
        this.listeners.clear();
        for (BukkitTask task : this.tasks) {
            if (task.isCancelled()) continue;
            task.cancel();
        }
        this.tasks.clear();
        ACTIVE_MENUS.remove(this.player);
        if (this.parentMenu != null && this.player.isOnline()) {
            this.parentMenu.open();
        }
    }

    public void fakeClose() {
        this.fakeClosing = true;
        this.player.closeInventory();
    }

    protected Slot getPrevButton() {
        ItemStack itemStack = new ItemStack(Material.PLAYER_HEAD);
        VersionManager.getNms().addSkullTexture(itemStack, "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZWE0YTliNzBhMjVhMjdkODE4OWU2MGQyN2VhOGNjOTYzMmMzNmI0NjkyODE1NWRlNzc1NWYzNjZlZjA0Yzg3NyJ9fX0=", UUID.randomUUID());
        ItemMeta meta = itemStack.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(String.valueOf(ChatColor.RESET) + "Previous Page");
            ArrayList<CallSite> lore = new ArrayList<CallSite>();
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.GREEN) + "Current Page: " + String.valueOf(ChatColor.WHITE) + this.getPages())));
            meta.setLore(lore);
            itemStack.setItemMeta(meta);
        }
        return new Slot(itemStack){

            @Override
            public void onLeftClick() {
                this.menu.open(this.menu.getPage() - 1);
            }
        };
    }

    protected Slot getNextButton() {
        ItemStack itemStack = new ItemStack(Material.PLAYER_HEAD);
        VersionManager.getNms().addSkullTexture(itemStack, "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNTkxNTJjMmU5MWY0NzA0ODViZTIyMmRiNWQyYTg5NWNhZGM5MDMzMjZmNWM2NzFiZjhhNTU5MTQ5NjczYmU4MCJ9fX0=", UUID.randomUUID());
        ItemMeta meta = itemStack.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(String.valueOf(ChatColor.RESET) + "Next Page");
            ArrayList<CallSite> lore = new ArrayList<CallSite>();
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.GREEN) + "Current Page: " + String.valueOf(ChatColor.WHITE) + this.getPages())));
            meta.setLore(lore);
            itemStack.setItemMeta(meta);
        }
        return new Slot(itemStack){

            @Override
            public void onLeftClick() {
                this.menu.open(this.menu.getPage() + 1);
            }
        };
    }

    public void registerListener(Listener listener) {
        Bukkit.getPluginManager().registerEvents(listener, (Plugin)Codex.getPlugin());
        this.listeners.add(listener);
    }

    public void unregisterListener(Listener listener) {
        if (this.listeners.remove(listener)) {
            HandlerList.unregisterAll((Listener)listener);
        }
    }

    public void registerTask(BukkitTask task) {
        this.tasks.add(task);
    }

    public void unregisterTask(BukkitTask task) {
        if (this.tasks.remove(task) && !task.isCancelled()) {
            task.cancel();
        }
    }

    @Generated
    public int getPage() {
        return this.page;
    }

    @Generated
    public boolean isOpening() {
        return this.opening;
    }

    public static class NextPageButton
    extends Slot {
        public NextPageButton(ItemStack itemStack) {
            super(itemStack);
        }

        @Override
        public void onLeftClick() {
            this.menu.open(this.menu.getPage() + 1);
        }
    }

    public static class PreviousPageButton
    extends Slot {
        public PreviousPageButton(ItemStack itemStack) {
            super(itemStack);
        }

        @Override
        public void onLeftClick() {
            this.menu.open(this.menu.getPage() - 1);
        }
    }
}

