/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.listeners;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import studio.magemonkey.codex.action.CommandBlock;
import studio.magemonkey.codex.api.Replacer;
import studio.magemonkey.codex.config.api.JYML;

public class InteractListener
implements Listener {
    private final List<CommandBlock> onInteract = new ArrayList<CommandBlock>();

    public InteractListener(JYML config) {
        List interactList = (List)config.get("onInteract");
        if (interactList != null) {
            for (Map cmd : interactList) {
                this.onInteract.add(new CommandBlock(cmd));
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onInteract(PlayerInteractEvent e) {
        Block block = e.getClickedBlock();
        if (block == null) {
            return;
        }
        this.getOnInteract(block.getType()).forEach(commandBlock -> commandBlock.invoke((PlayerEvent)e, new Replacer[0]));
    }

    private List<CommandBlock> getOnInteract(Material type) {
        return this.onInteract.stream().filter(cmd -> cmd.getMaterial() == type).collect(Collectors.toList());
    }
}

