/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.legacy.utils.serializers;

import com.google.common.base.Preconditions;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Arrays;
import java.util.HashSet;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import studio.magemonkey.codex.legacy.utils.serializers.ComponentSerializer;

public class BaseComponentSerializer {
    protected void deserialize(JsonObject object, BaseComponent component, JsonDeserializationContext context) {
        JsonObject event;
        if (object.has("color")) {
            component.setColor(ChatColor.valueOf((String)object.get("color").getAsString().toUpperCase()));
        }
        if (object.has("bold")) {
            component.setBold(Boolean.valueOf(object.get("bold").getAsBoolean()));
        }
        if (object.has("italic")) {
            component.setItalic(Boolean.valueOf(object.get("italic").getAsBoolean()));
        }
        if (object.has("underlined")) {
            component.setUnderlined(Boolean.valueOf(object.get("underlined").getAsBoolean()));
        }
        if (object.has("strikethrough")) {
            component.setStrikethrough(Boolean.valueOf(object.get("strikethrough").getAsBoolean()));
        }
        if (object.has("obfuscated")) {
            component.setObfuscated(Boolean.valueOf(object.get("obfuscated").getAsBoolean()));
        }
        if (object.has("extra")) {
            component.setExtra(Arrays.asList((BaseComponent[])context.deserialize(object.get("extra"), BaseComponent[].class)));
        }
        if (object.has("clickEvent")) {
            event = object.getAsJsonObject("clickEvent");
            component.setClickEvent(new ClickEvent(ClickEvent.Action.valueOf((String)event.get("action").getAsString().toUpperCase()), event.get("value").getAsString()));
        }
        if (object.has("hoverEvent")) {
            event = object.getAsJsonObject("hoverEvent");
            BaseComponent[] res = event.get("value").isJsonArray() ? (BaseComponent[])context.deserialize(event.get("value"), BaseComponent[].class) : new BaseComponent[]{(BaseComponent)context.deserialize(event.get("value"), BaseComponent.class)};
            component.setHoverEvent(new HoverEvent(HoverEvent.Action.valueOf((String)event.get("action").getAsString().toUpperCase()), res));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serialize(JsonObject object, BaseComponent component, JsonSerializationContext context) {
        boolean first = false;
        if (ComponentSerializer.serializedComponents.get() == null) {
            first = true;
            ComponentSerializer.serializedComponents.set(new HashSet(20));
        }
        try {
            JsonObject hoverEvent;
            Preconditions.checkArgument((!ComponentSerializer.serializedComponents.get().contains(component) ? 1 : 0) != 0, (Object)"Component loop");
            ComponentSerializer.serializedComponents.get().add(component);
            if (component.getColorRaw() != null) {
                object.addProperty("color", component.getColorRaw().getName());
            }
            if (component.isBoldRaw() != null) {
                object.addProperty("bold", component.isBoldRaw());
            }
            if (component.isItalicRaw() != null) {
                object.addProperty("italic", component.isItalicRaw());
            }
            if (component.isUnderlinedRaw() != null) {
                object.addProperty("underlined", component.isUnderlinedRaw());
            }
            if (component.isStrikethroughRaw() != null) {
                object.addProperty("strikethrough", component.isStrikethroughRaw());
            }
            if (component.isObfuscatedRaw() != null) {
                object.addProperty("obfuscated", component.isObfuscatedRaw());
            }
            if (component.getExtra() != null) {
                object.add("extra", context.serialize((Object)component.getExtra()));
            }
            if (component.getClickEvent() != null) {
                hoverEvent = new JsonObject();
                hoverEvent.addProperty("action", component.getClickEvent().getAction().toString().toLowerCase());
                hoverEvent.addProperty("value", component.getClickEvent().getValue());
                object.add("clickEvent", (JsonElement)hoverEvent);
            }
            if (component.getHoverEvent() != null) {
                hoverEvent = new JsonObject();
                hoverEvent.addProperty("action", component.getHoverEvent().getAction().toString().toLowerCase());
                object.add("hoverEvent", (JsonElement)hoverEvent);
            }
        }
        finally {
            ComponentSerializer.serializedComponents.get().remove(component);
            if (first) {
                ComponentSerializer.serializedComponents.set(null);
            }
        }
    }
}

