/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.legacy.item;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.inventory.meta.ItemMeta;
import studio.magemonkey.codex.legacy.item.BookDataBuilder;
import studio.magemonkey.codex.legacy.item.EnchantmentStorageBuilder;
import studio.magemonkey.codex.legacy.item.FireworkBuilder;
import studio.magemonkey.codex.legacy.item.FireworkEffectBuilder;
import studio.magemonkey.codex.legacy.item.LeatherArmorBuilder;
import studio.magemonkey.codex.legacy.item.MapBuilder;
import studio.magemonkey.codex.legacy.item.PotionDataBuilder;
import studio.magemonkey.codex.legacy.item.SkullBuilder;
import studio.magemonkey.codex.util.SerializationBuilder;

public abstract class DataBuilder
implements ConfigurationSerializable {
    private static final Map<String, Function<Map<String, Object>, DataBuilder>> builders = new HashMap<String, Function<Map<String, Object>, DataBuilder>>(15);

    public static DataBuilder build(Map<String, Object> data) {
        if (data == null || data.isEmpty() || !data.containsKey("TYPE")) {
            return null;
        }
        Function<Map<String, Object>, DataBuilder> func = builders.get(data.get("TYPE").toString().toLowerCase());
        return func == null ? null : func.apply(data);
    }

    public abstract void apply(ItemMeta var1);

    public abstract DataBuilder use(ItemMeta var1);

    public abstract String getType();

    public Map<String, Object> serialize() {
        return SerializationBuilder.start(1).append("TYPE", (Object)this.getType()).build();
    }

    static {
        builders.put("book", BookDataBuilder::new);
        builders.put("enchantment_book", EnchantmentStorageBuilder::new);
        builders.put("firework", FireworkBuilder::new);
        builders.put("firework_effect", FireworkEffectBuilder::new);
        builders.put("leather", LeatherArmorBuilder::new);
        builders.put("map", MapBuilder::new);
        builders.put("potion", PotionDataBuilder::new);
        builders.put("skull", SkullBuilder::new);
    }
}

