/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.hooks.external;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.serialize.Position;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.SkillMetadataImpl;
import io.lumine.mythic.core.skills.SkillTriggers;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.hooks.HookState;
import studio.magemonkey.codex.hooks.NHook;
import studio.magemonkey.codex.hooks.external.IMythicHook;

public class MythicMobsHKv5
extends NHook<CodexEngine>
implements IMythicHook {
    private MythicBukkit mm;

    public MythicMobsHKv5(CodexEngine plugin) {
        super(plugin);
    }

    @Override
    @NotNull
    protected HookState setup() {
        this.mm = MythicBukkit.inst();
        return HookState.SUCCESS;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public boolean isMythicMob(@NotNull Entity entity) {
        return this.getMythicInstance(entity) != null;
    }

    @Override
    @NotNull
    public String getMythicNameByEntity(@NotNull Entity entity) {
        MythicMob mob = this.getMythicInstance(entity);
        return mob == null ? null : mob.getInternalName();
    }

    public MythicMob getMythicInstance(@NotNull Entity entity) {
        ActiveMob mob = this.getActiveMythicInstance(entity);
        return mob != null ? mob.getType() : null;
    }

    @Override
    public boolean isDropTable(@NotNull String table) {
        return this.mm.getDropManager().getDropTable(table) != null && this.mm.getDropManager().getDropTable(table).isPresent();
    }

    @Override
    public double getLevel(@NotNull Entity e) {
        ActiveMob mob = this.getActiveMythicInstance(e);
        return mob != null ? mob.getLevel() : 1.0;
    }

    @Override
    @NotNull
    public List<String> getMythicIds() {
        return new ArrayList<String>(this.mm.getMobManager().getMobNames());
    }

    @Override
    public void setSkillDamage(@NotNull Entity entity, double amount) {
        if (!this.isMythicMob(entity)) {
            return;
        }
        ActiveMob am1 = this.getActiveMythicInstance(entity);
        am1.setLastDamageSkillAmount(amount);
    }

    @Override
    public void castSkill(@NotNull Entity e, @NotNull String skill) {
        ActiveMob mob = this.getActiveMythicInstance(e);
        if (mob == null) {
            return;
        }
        this.mm.getSkillManager().getSkill(skill).ifPresent(sk -> sk.execute((SkillMetadata)new SkillMetadataImpl(SkillTriggers.API, (SkillCaster)mob, mob.getEntity())));
    }

    @Override
    public void killMythic(@NotNull Entity e) {
        ActiveMob mob = this.getActiveMythicInstance(e);
        if (mob == null || mob.isDead()) {
            return;
        }
        mob.setDead();
        e.remove();
    }

    @Override
    public boolean isValid(@NotNull String name) {
        Optional koke = this.mm.getMobManager().getMythicMob(name);
        return koke.isPresent();
    }

    @Override
    @NotNull
    public String getName(@NotNull String mobId) {
        Optional koke = this.mm.getMobManager().getMythicMob(mobId);
        return koke.isPresent() ? ((MythicMob)koke.get()).getDisplayName().get() : mobId;
    }

    @Override
    @Nullable
    public Entity spawnMythicMob(@NotNull String name, @NotNull Location loc, int level) {
        Optional koke = this.mm.getMobManager().getMythicMob(name);
        if (koke.isPresent()) {
            MythicMob mob = (MythicMob)koke.get();
            ActiveMob e = mob.spawn(new AbstractLocation(Position.of((Location)loc)), (double)level);
            return e.getEntity().getBukkitEntity();
        }
        return null;
    }

    @Override
    public void taunt(LivingEntity target, LivingEntity source, double amount) {
        AbstractEntity abs = BukkitAdapter.adapt((Entity)source);
        ActiveMob mob = this.getActiveMythicInstance((Entity)target);
        if (!mob.hasThreatTable()) {
            if (amount > 0.0) {
                mob.setTarget(abs);
            } else if (amount < 0.0) {
                mob.getNewTarget();
            }
            return;
        }
        ActiveMob.ThreatTable table = mob.getThreatTable();
        if (amount > 0.0) {
            table.threatGain(abs, amount);
        } else if (amount < 0.0) {
            table.threatLoss(abs, -amount);
        }
    }

    public ActiveMob getActiveMythicInstance(@NotNull Entity entity) {
        Optional mob = this.mm.getMobManager().getActiveMob(entity.getUniqueId());
        return mob.isPresent() ? (ActiveMob)mob.get() : null;
    }
}

