/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.config;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.config.ResourceExtractor;
import studio.magemonkey.codex.config.api.JYML;

public class ConfigManager<P extends CodexPlugin<P>> {
    @NotNull
    private P plugin;
    public JYML configMain;
    public JYML configLang;
    public static JYML configTemp;

    public ConfigManager(@NotNull P plugin) {
        this.plugin = plugin;
    }

    public void setup() throws InvalidConfigurationException {
        this.extract("lang");
        try {
            this.configMain = JYML.loadOrExtract(this.plugin, "config.yml");
        }
        catch (InvalidConfigurationException e) {
            ((CodexPlugin)this.plugin).error("Configuration error in " + this.plugin.getName() + "/config.yml");
            throw e;
        }
        try {
            this.configLang = JYML.loadOrExtract(this.plugin, "/lang/messages_" + this.configMain.getString("general.lang", "en").toLowerCase() + ".yml");
        }
        catch (InvalidConfigurationException e) {
            ((CodexPlugin)this.plugin).error("Configuration error in " + this.plugin.getName() + "/lang/messages_" + this.configMain.getString("general.lang", "en").toLowerCase() + ".yml");
            throw e;
        }
        ((CodexPlugin)this.plugin).setConfig();
        if (((CodexPlugin)this.plugin).isEngine()) {
            try {
                configTemp = JYML.loadOrExtract(this.plugin, "temp.yml");
            }
            catch (InvalidConfigurationException e) {
                ((CodexPlugin)this.plugin).error("Configuration error in " + this.plugin.getName() + "/temp.yml");
                throw e;
            }
        }
    }

    public void extract(@NotNull String folder) {
        if (!((String)folder).startsWith("/")) {
            folder = "/" + (String)folder;
        }
        if (!((String)folder).endsWith("/")) {
            folder = (String)folder + "/";
        }
        this.extractFullPath(String.valueOf(this.plugin.getDataFolder()) + (String)folder);
    }

    public void extractFullPath(@NotNull String path) {
        this.extractFullPath(path, "yml", false);
    }

    public void extractFullPath(@NotNull String path, boolean override) {
        this.extractFullPath(path, "yml", override);
    }

    public void extractFullPath(@NotNull String path, @NotNull String extension) {
        this.extractFullPath(path, extension, false);
    }

    public void extractFullPath(@NotNull String path, @NotNull String extension, boolean override) {
        File f = new File(path);
        String jarPath = path.replace(String.valueOf(this.plugin.getDataFolder()), "");
        if (jarPath.startsWith("/")) {
            jarPath = jarPath.substring(1, jarPath.length());
        }
        if (jarPath.endsWith("/")) {
            jarPath = jarPath.substring(0, jarPath.length() - 1);
        }
        if (!f.exists()) {
            ResourceExtractor extract = new ResourceExtractor((JavaPlugin)this.plugin, f, jarPath, ".*\\.(" + extension + ")$");
            try {
                extract.extract(override, true);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Nullable
    public static UUID getTempUUID(@NotNull String id) {
        if (id.isEmpty()) {
            return null;
        }
        configTemp.addMissing(id, UUID.randomUUID().toString());
        configTemp.saveChanges();
        try {
            return UUID.fromString(configTemp.getString(id));
        }
        catch (IllegalArgumentException ex) {
            UUID uid = UUID.randomUUID();
            configTemp.set(id, uid.toString());
            configTemp.saveChanges();
            return uid;
        }
    }
}

