/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.compat;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import io.netty.channel.Channel;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.UUID;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.TranslatableComponent;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.Block;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.Codex;

public interface NMS {
    public String getVersion();

    @NotNull
    public Object getConnection(Player var1);

    @NotNull
    public Channel getChannel(@NotNull Player var1);

    public void sendPacket(@NotNull Player var1, @NotNull Object var2);

    public void openChestAnimation(@NotNull Block var1, boolean var2);

    public void sendAttackPacket(@NotNull Player var1, int var2);

    @NotNull
    public String fixColors(@NotNull String var1);

    public double getDefaultDamage(@NotNull ItemStack var1);

    public double getDefaultSpeed(@NotNull ItemStack var1);

    public double getDefaultArmor(@NotNull ItemStack var1);

    public double getDefaultToughness(@NotNull ItemStack var1);

    public boolean isWeapon(@NotNull ItemStack var1);

    public boolean isArmor(@NotNull ItemStack var1);

    public boolean isTool(@NotNull ItemStack var1);

    public String toJson(@NotNull ItemStack var1);

    public void setKiller(@NotNull LivingEntity var1, @NotNull Player var2);

    public void changeSkull(@NotNull Block var1, @NotNull String var2);

    default public void addSkullTexture(@NotNull ItemStack item, @NotNull String value, @NotNull UUID uuid) {
        if (item.getType() != Material.PLAYER_HEAD) {
            return;
        }
        SkullMeta meta = (SkullMeta)item.getItemMeta();
        if (meta == null) {
            return;
        }
        try {
            GameProfile profile = new GameProfile(uuid, uuid.toString().substring(0, 16));
            profile.getProperties().put((Object)"textures", (Object)new Property("textures", value));
            this.getField(meta.getClass(), "profile").set(meta, profile);
        }
        catch (IllegalAccessException | NoSuchFieldException setException) {
            Codex.warn("Could not set player skull texture. " + setException.getMessage());
        }
        item.setItemMeta((ItemMeta)meta);
    }

    default public GameProfile getNonPlayerProfile(String hash) {
        UUID uid = UUID.randomUUID();
        GameProfile profile = new GameProfile(uid, uid.toString().substring(0, 8));
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", hash));
        return profile;
    }

    default public double getAttributeValue(@NotNull ItemStack item, @NotNull Attribute attribute) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return 0.0;
        }
        if (meta.getAttributeModifiers() == null || meta.getAttributeModifiers().isEmpty()) {
            return 0.0;
        }
        Collection modifiers = meta.getAttributeModifiers(attribute);
        if (modifiers == null || modifiers.isEmpty()) {
            return 0.0;
        }
        return modifiers.stream().mapToDouble(AttributeModifier::getAmount).sum();
    }

    @NotNull
    default public Attribute getAttribute(String name) {
        Attribute attr = null;
        try {
            attr = Attribute.valueOf((String)name);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (attr == null) {
            try {
                attr = Attribute.valueOf((String)("GENERIC_" + name));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (attr == null) {
            try {
                attr = Attribute.valueOf((String)("PLAYER_" + name));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (attr == null) {
            throw new IllegalArgumentException("Unknown attribute: " + name);
        }
        return attr;
    }

    public Object getNMSCopy(@NotNull ItemStack var1);

    public Material getMaterial(Boat var1);

    default public HoverEvent getHoverEvent(@NotNull ItemStack itemStack) {
        String json = this.toJson(itemStack);
        if (json != null) {
            new HoverEvent(HoverEvent.Action.SHOW_ITEM, TextComponent.fromLegacyText((String)json));
        }
        return new HoverEvent(HoverEvent.Action.SHOW_ITEM, new BaseComponent[0]);
    }

    default public Objective registerNewObjective(Scoreboard scoreboard, Objective objective) {
        return scoreboard.registerNewObjective(objective.getName(), objective.getCriteria(), objective.getDisplayName());
    }

    default public BaseComponent getTranslatedComponent(@NotNull ItemStack itemStack) {
        TextComponent baseComponent;
        ItemMeta meta = itemStack.getItemMeta();
        String string = null;
        if (meta != null && (string = meta.getDisplayName()).isEmpty() && meta.hasLocalizedName()) {
            string = meta.getLocalizedName();
        }
        if (string == null || string.isEmpty()) {
            Object id = itemStack.getType().getKey().getKey();
            if (itemStack.getType().isBlock()) {
                id = "block.minecraft" + (String)id;
            } else if (itemStack.getType().isItem()) {
                id = "item.minecraft" + (String)id;
            }
            baseComponent = new TranslatableComponent((String)id, new Object[0]);
        } else {
            baseComponent = new TextComponent(string);
        }
        return baseComponent;
    }

    default public EntityDamageByEntityEvent createEntityDamageEvent(@NotNull Entity entity, @NotNull Entity attacker, @NotNull EntityDamageEvent.DamageCause cause, double damage) {
        return new EntityDamageByEntityEvent(attacker, entity, cause, damage);
    }

    @NotNull
    default public Field getField(@NotNull Class<?> clazz, @NotNull String fieldName) throws NoSuchFieldException {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            Class<?> superClass = clazz.getSuperclass();
            if (superClass == null) {
                throw e;
            }
            return this.getField(superClass, fieldName);
        }
    }
}

