/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.util.actions.targets;

import java.util.Set;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Projectile;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.util.actions.Parametized;
import studio.magemonkey.codex.util.actions.params.IAutoValidated;
import studio.magemonkey.codex.util.actions.params.IParam;
import studio.magemonkey.codex.util.actions.params.IParamResult;

public abstract class ITargetSelector
extends Parametized {
    public ITargetSelector(@NotNull CodexPlugin<?> plugin, @NotNull String key) {
        super(plugin, key);
        this.registerParam("NAME");
    }

    public final void select(@NotNull Entity exe, @NotNull Set<Entity> targets, @NotNull String fullStr) {
        IParamResult result = this.getParamResult(fullStr);
        this.validateTarget(exe, targets, result);
        this.autoValidate(exe, targets, result);
    }

    protected abstract void validateTarget(@NotNull Entity var1, @NotNull Set<Entity> var2, @NotNull IParamResult var3);

    private final void autoValidate(@NotNull Entity exe, @NotNull Set<Entity> targets, @NotNull IParamResult result) {
        Projectile pj;
        ProjectileSource ps;
        Entity executor = exe;
        if (exe instanceof Projectile && (ps = (pj = (Projectile)exe).getShooter()) instanceof Entity) {
            executor = (Entity)ps;
        }
        for (IParam param : this.getParams()) {
            if (!result.hasParam(param.getKey()) || !(param instanceof IAutoValidated)) continue;
            IAutoValidated auto = (IAutoValidated)((Object)param);
            auto.autoValidate(executor, targets, result.getParamValue(param.getKey()));
        }
    }
}

