/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.util.actions.conditions.list;

import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.hooks.external.VaultHK;
import studio.magemonkey.codex.util.actions.conditions.IConditionValidator;
import studio.magemonkey.codex.util.actions.params.IParamResult;
import studio.magemonkey.codex.util.actions.params.IParamValue;

public class Condition_VaultBalance
extends IConditionValidator {
    private VaultHK vault;

    public Condition_VaultBalance(@NotNull CodexPlugin<?> plugin) {
        super(plugin, "VAULT_BALANCE");
        this.vault = plugin.getVault();
    }

    @Override
    @NotNull
    public List<String> getDescription() {
        return this.plugin.lang().Codex_Editor_Actions_Condition_VaultBalance_Desc.asList();
    }

    @Override
    public void registerParams() {
        this.registerParam("TARGET");
        this.registerParam("AMOUNT");
    }

    @Override
    public boolean mustHaveTarget() {
        return true;
    }

    @Override
    @Nullable
    protected Predicate<Entity> validate(@NotNull Entity exe, @NotNull Set<Entity> targets, @NotNull IParamResult result) {
        if (this.vault == null) {
            return null;
        }
        IParamValue val = result.getParamValue("AMOUNT");
        double amount = val.getDouble(-1.0);
        if (amount == -1.0) {
            return null;
        }
        IParamValue.IOperator oper = val.getOperator();
        return target -> {
            if (target.getType() == EntityType.PLAYER) {
                Player p = (Player)target;
                double balance = this.vault.getBalance((OfflinePlayer)p);
                return oper.check(balance, amount);
            }
            return false;
        };
    }
}

