/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.util.actions;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.manager.IManager;
import studio.magemonkey.codex.util.actions.ActionCategory;
import studio.magemonkey.codex.util.actions.ActionManipulator;
import studio.magemonkey.codex.util.actions.Parametized;
import studio.magemonkey.codex.util.actions.actions.IActionExecutor;
import studio.magemonkey.codex.util.actions.actions.list.Action_ActionBar;
import studio.magemonkey.codex.util.actions.actions.list.Action_Broadcast;
import studio.magemonkey.codex.util.actions.actions.list.Action_Burn;
import studio.magemonkey.codex.util.actions.actions.list.Action_CommandConsole;
import studio.magemonkey.codex.util.actions.actions.list.Action_CommandOp;
import studio.magemonkey.codex.util.actions.actions.list.Action_CommandPlayer;
import studio.magemonkey.codex.util.actions.actions.list.Action_Damage;
import studio.magemonkey.codex.util.actions.actions.list.Action_Firework;
import studio.magemonkey.codex.util.actions.actions.list.Action_Goto;
import studio.magemonkey.codex.util.actions.actions.list.Action_Health;
import studio.magemonkey.codex.util.actions.actions.list.Action_Hook;
import studio.magemonkey.codex.util.actions.actions.list.Action_Hunger;
import studio.magemonkey.codex.util.actions.actions.list.Action_Lightning;
import studio.magemonkey.codex.util.actions.actions.list.Action_Message;
import studio.magemonkey.codex.util.actions.actions.list.Action_ParticleSimple;
import studio.magemonkey.codex.util.actions.actions.list.Action_Potion;
import studio.magemonkey.codex.util.actions.actions.list.Action_ProgressBar;
import studio.magemonkey.codex.util.actions.actions.list.Action_Projectile;
import studio.magemonkey.codex.util.actions.actions.list.Action_Saturation;
import studio.magemonkey.codex.util.actions.actions.list.Action_Sound;
import studio.magemonkey.codex.util.actions.actions.list.Action_Teleport;
import studio.magemonkey.codex.util.actions.actions.list.Action_Throw;
import studio.magemonkey.codex.util.actions.actions.list.Action_Titles;
import studio.magemonkey.codex.util.actions.conditions.IConditionValidator;
import studio.magemonkey.codex.util.actions.conditions.list.Condition_EntityHealth;
import studio.magemonkey.codex.util.actions.conditions.list.Condition_EntityType;
import studio.magemonkey.codex.util.actions.conditions.list.Condition_Permission;
import studio.magemonkey.codex.util.actions.conditions.list.Condition_VaultBalance;
import studio.magemonkey.codex.util.actions.conditions.list.Condition_WorldTime;
import studio.magemonkey.codex.util.actions.params.IParam;
import studio.magemonkey.codex.util.actions.params.defaults.IParamBoolean;
import studio.magemonkey.codex.util.actions.params.defaults.IParamNumber;
import studio.magemonkey.codex.util.actions.params.defaults.IParamString;
import studio.magemonkey.codex.util.actions.params.list.AllowSelfParam;
import studio.magemonkey.codex.util.actions.params.list.AttackableParam;
import studio.magemonkey.codex.util.actions.params.list.LocationParam;
import studio.magemonkey.codex.util.actions.params.list.OffsetParam;
import studio.magemonkey.codex.util.actions.targets.ITargetSelector;
import studio.magemonkey.codex.util.actions.targets.list.Target_FromSight;
import studio.magemonkey.codex.util.actions.targets.list.Target_Radius;
import studio.magemonkey.codex.util.actions.targets.list.Target_Self;

public class ActionsManager
extends IManager<CodexEngine> {
    private Map<String, IActionExecutor> actionExecutors;
    private Map<String, IConditionValidator> conditionValidators;
    private Map<String, ITargetSelector> targetSelectors;
    private Map<String, IParam> params;
    private Map<String, ActionManipulator> manipulators;

    public ActionsManager(@NotNull CodexEngine plugin) {
        super(plugin);
    }

    @Override
    public void setup() {
        this.actionExecutors = new HashMap<String, IActionExecutor>();
        this.conditionValidators = new HashMap<String, IConditionValidator>();
        this.params = new HashMap<String, IParam>();
        this.targetSelectors = new HashMap<String, ITargetSelector>();
        this.manipulators = new HashMap<String, ActionManipulator>();
        this.setupDefaults();
    }

    @Override
    public void shutdown() {
        if (this.manipulators != null) {
            this.manipulators.clear();
            this.manipulators = null;
        }
        if (this.actionExecutors != null) {
            this.actionExecutors.clear();
            this.actionExecutors = null;
        }
        if (this.conditionValidators != null) {
            this.conditionValidators.clear();
            this.conditionValidators = null;
        }
        if (this.targetSelectors != null) {
            this.targetSelectors.clear();
            this.targetSelectors = null;
        }
        if (this.params != null) {
            this.params.clear();
            this.params = null;
        }
    }

    @NotNull
    public Collection<IActionExecutor> getExecutors() {
        return this.actionExecutors.values();
    }

    @NotNull
    public Collection<IConditionValidator> getConditionValidators() {
        return this.conditionValidators.values();
    }

    @NotNull
    public Collection<IParam> getParams() {
        return this.params.values();
    }

    @NotNull
    public Collection<ITargetSelector> getTargetSelectors() {
        return this.targetSelectors.values();
    }

    @NotNull
    public Collection<IActionExecutor> getActionExecutors() {
        return this.actionExecutors.values();
    }

    public void registerExecutor(@NotNull IActionExecutor executor) {
        if (this.actionExecutors.put(executor.getKey(), executor) != null) {
            ((CodexEngine)this.plugin).info("[Actions Engine] Replaced registered action executor '" + executor.getKey() + "' with a new one.");
        }
    }

    public void registerCondition(@NotNull IConditionValidator conditionValidator) {
        if (this.conditionValidators.put(conditionValidator.getKey(), conditionValidator) != null) {
            ((CodexEngine)this.plugin).info("[Actions Engine] Replaced registered condition validator '" + conditionValidator.getKey() + "' with a new one.");
        }
    }

    public void registerParam(@NotNull IParam param) {
        if (this.params.put(param.getKey(), param) != null) {
            ((CodexEngine)this.plugin).info("[Actions Engine] Replaced registered param '" + param.getKey() + "' with a new one.");
        }
    }

    public void registerTargetSelector(@NotNull ITargetSelector selector) {
        if (this.targetSelectors.put(selector.getKey(), selector) != null) {
            ((CodexEngine)this.plugin).info("[Actions Engine] Replaced registered target selector '" + selector.getKey() + "' with a new one.");
        }
    }

    public void registerManipulator(@NotNull String id, @NotNull ActionManipulator manipulator) {
        if (this.manipulators.put(id.toLowerCase(), manipulator) != null) {
            ((CodexEngine)this.plugin).info("[Actions Engine] Replaced registered Action Manipulator '" + id + "' with a new one.");
        }
    }

    @Nullable
    public ActionManipulator getManipulator(@NotNull String id) {
        return this.manipulators.getOrDefault(id.toLowerCase(), null);
    }

    public void unregisterManipulator(@NotNull String id) {
        this.manipulators.remove(id.toLowerCase());
    }

    @Nullable
    public Parametized getParametized(@NotNull ActionCategory category, @NotNull String key) {
        if (category == ActionCategory.TARGETS) {
            return this.getTargetSelector(key);
        }
        if (category == ActionCategory.CONDITIONS) {
            return this.getConditionValidator(key);
        }
        if (category == ActionCategory.ACTIONS) {
            return this.getActionExecutor(key);
        }
        return null;
    }

    @Nullable
    public Collection<? extends Parametized> getParametized(@NotNull ActionCategory category) {
        if (category == ActionCategory.TARGETS) {
            return this.getTargetSelectors();
        }
        if (category == ActionCategory.CONDITIONS) {
            return this.getConditionValidators();
        }
        if (category == ActionCategory.ACTIONS) {
            return this.getActionExecutors();
        }
        return Collections.emptySet();
    }

    @Nullable
    public IActionExecutor getActionExecutor(@NotNull String key) {
        return this.actionExecutors.getOrDefault(key.toUpperCase(), null);
    }

    @Nullable
    public IConditionValidator getConditionValidator(@NotNull String key) {
        return this.conditionValidators.getOrDefault(key.toUpperCase(), null);
    }

    @Nullable
    public ITargetSelector getTargetSelector(@NotNull String key) {
        return this.targetSelectors.getOrDefault(key.toUpperCase(), null);
    }

    @Nullable
    public IParam getParam(@NotNull String key) {
        return this.params.getOrDefault(key.toUpperCase(), null);
    }

    private final void setupDefaults() {
        this.registerParam(new AllowSelfParam());
        this.registerParam(new AttackableParam());
        this.registerParam(new IParamNumber("AMOUNT", "amount"));
        this.registerParam(new IParamNumber("DELAY", "delay"));
        this.registerParam(new IParamNumber("DISTANCE", "distance"));
        this.registerParam(new IParamNumber("DURATION", "duration"));
        this.registerParam(new IParamBoolean("FILTER", "filter"));
        this.registerParam(new IParamString("MESSAGE", "message"));
        this.registerParam(new IParamString("NAME", "name"));
        this.registerParam(new IParamNumber("SPEED", "speed"));
        this.registerParam(new IParamString("TARGET", "target"));
        this.registerParam(new IParamString("TITLES_TITLE", "title"));
        this.registerParam(new IParamString("TITLES_SUBTITLE", "subtitle"));
        this.registerParam(new IParamNumber("TITLES_FADE_IN", "fadeIn"));
        this.registerParam(new IParamNumber("TITLES_STAY", "stay"));
        this.registerParam(new IParamNumber("TITLES_FADE_OUT", "fadeOut"));
        this.registerParam(new IParamString("BAR_COLOR_EMPTY", "color-empty"));
        this.registerParam(new IParamString("BAR_COLOR_FILL", "color-fill"));
        this.registerParam(new LocationParam());
        this.registerParam(new OffsetParam());
        this.registerCondition(new Condition_WorldTime((CodexPlugin)this.plugin));
        this.registerCondition(new Condition_Permission((CodexPlugin)this.plugin));
        this.registerCondition(new Condition_VaultBalance((CodexPlugin)this.plugin));
        this.registerCondition(new Condition_EntityHealth((CodexPlugin)this.plugin));
        this.registerCondition(new Condition_EntityType((CodexPlugin)this.plugin));
        this.registerExecutor(new Action_ActionBar((CodexPlugin)this.plugin));
        this.registerExecutor(new Action_Broadcast((CodexPlugin)this.plugin));
        this.registerExecutor(new Action_Burn((CodexPlugin)this.plugin));
        this.registerExecutor(new Action_Damage((CodexPlugin)this.plugin));
        this.registerExecutor(new Action_Health((CodexPlugin)this.plugin));
        this.registerExecutor(new Action_Message((CodexPlugin)this.plugin));
        this.registerExecutor(new Action_CommandPlayer((CodexPlugin)this.plugin));
        this.registerExecutor(new Action_CommandConsole((CodexPlugin)this.plugin));
        this.registerExecutor(new Action_CommandOp((CodexPlugin)this.plugin));
        this.registerExecutor(new Action_Firework((CodexPlugin)this.plugin));
        this.registerExecutor(new Action_Hook((CodexPlugin)this.plugin));
        this.registerExecutor(new Action_Lightning((CodexPlugin)this.plugin));
        this.registerExecutor(new Action_ParticleSimple((CodexPlugin)this.plugin));
        this.registerExecutor(new Action_Potion((CodexPlugin)this.plugin));
        this.registerExecutor(new Action_ProgressBar((CodexPlugin)this.plugin));
        this.registerExecutor(new Action_Projectile((CodexPlugin)this.plugin));
        this.registerExecutor(new Action_Throw((CodexPlugin)this.plugin));
        this.registerExecutor(new Action_Saturation((CodexPlugin)this.plugin));
        this.registerExecutor(new Action_Hunger((CodexPlugin)this.plugin));
        this.registerExecutor(new Action_Sound((CodexPlugin)this.plugin));
        this.registerExecutor(new Action_Teleport((CodexPlugin)this.plugin));
        this.registerExecutor(new Action_Titles((CodexPlugin)this.plugin));
        this.registerExecutor(new Action_Goto((CodexPlugin)this.plugin));
        this.registerTargetSelector(new Target_FromSight((CodexPlugin)this.plugin));
        this.registerTargetSelector(new Target_Self((CodexPlugin)this.plugin));
        this.registerTargetSelector(new Target_Radius((CodexPlugin)this.plugin));
    }
}

