/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.DoubleRange;
import org.apache.commons.lang3.IntegerRange;
import org.apache.commons.lang3.LongRange;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.bukkit.Location;
import org.bukkit.configuration.serialization.ConfigurationSerializable;

public final class SerializationBuilder {
    private final Map<String, Object> data;

    private SerializationBuilder(int size) {
        this.data = new LinkedHashMap<String, Object>(size);
    }

    public SerializationBuilder append(Object str, Enum<?> object) {
        this.data.put(str.toString(), object.name());
        return this;
    }

    public SerializationBuilder append(String str, Enum<?> object) {
        this.data.put(str, object.name());
        return this;
    }

    public SerializationBuilder append(Object str, Object object) {
        return this.append(str.toString(), object);
    }

    public <T> SerializationBuilder append(String str, Map<T, ?> object, Function<T, String> keyToString) {
        SerializationBuilder sb = SerializationBuilder.start(object.size());
        for (Map.Entry<T, ?> entry : object.entrySet()) {
            sb.append(keyToString.apply(entry.getKey()), entry.getValue());
        }
        return this.append(str, sb);
    }

    public SerializationBuilder appendMap(String str, Map<?, ?> object) {
        SerializationBuilder sb = SerializationBuilder.start(object.size());
        for (Map.Entry<?, ?> entry : object.entrySet()) {
            sb.append(entry.getKey().toString(), entry.getValue());
        }
        return this.append(str, sb);
    }

    public SerializationBuilder append(String str, Object object) {
        if (object instanceof Enum) {
            return this.append(str, (Enum)((Object)object));
        }
        if (object instanceof IntegerRange) {
            return this.append(str, (Object)(String.valueOf(((IntegerRange)object).getMinimum()) + "-" + String.valueOf(((IntegerRange)object).getMaximum())));
        }
        if (object instanceof LongRange) {
            return this.append(str, (Object)(String.valueOf(((LongRange)object).getMinimum()) + "-" + String.valueOf(((LongRange)object).getMaximum())));
        }
        if (object instanceof DoubleRange) {
            return this.append(str, (Object)(String.valueOf(((DoubleRange)object).getMinimum()) + "-" + String.valueOf(((DoubleRange)object).getMaximum())));
        }
        if (object instanceof ConfigurationSerializable) {
            this.data.put(str, object);
            return this;
        }
        if (object instanceof Iterable) {
            Iterable iterable = object;
            ArrayList<Object> objects = new ArrayList<Object>(iterable instanceof Collection ? ((Collection)iterable).size() : 10);
            for (Object o : iterable) {
                if (o instanceof ConfigurationSerializable) {
                    objects.add(o);
                    continue;
                }
                if (o instanceof Enum) {
                    objects.add(((Enum)o).name());
                    continue;
                }
                objects.add(o);
            }
            object = objects;
        }
        this.data.put(str, object);
        return this;
    }

    public SerializationBuilder append(String str, SerializationBuilder object) {
        this.data.put(str, object.data);
        return this;
    }

    public SerializationBuilder append(Object str, SerializationBuilder object) {
        this.data.put(str.toString(), object.data);
        return this;
    }

    public SerializationBuilder appendCollection(String str, Collection<? extends ConfigurationSerializable> objects) {
        return this.append(str, objects.stream().map(ConfigurationSerializable::serialize).collect(Collectors.toList()));
    }

    public SerializationBuilder appendLoc(String str, Location location) {
        return this.append(str, SerializationBuilder.start(6).append("x", (Object)location.getX()).append("y", (Object)location.getY()).append("z", (Object)location.getZ()).append("world", location.getWorld() == null ? null : location.getWorld().getName()).append("pitch", (Object)Float.valueOf(location.getPitch())).append("yaw", (Object)Float.valueOf(location.getYaw())).build());
    }

    public SerializationBuilder append(Map<String, Object> object) {
        this.data.putAll(object);
        return this;
    }

    public Map<String, Object> build() {
        return this.data;
    }

    public static SerializationBuilder start(int size) {
        return new SerializationBuilder(size);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).appendSuper(super.toString()).append("data", this.data).toString();
    }
}

