/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.util;

import com.mojang.authlib.GameProfile;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.UnaryOperator;
import lombok.Generated;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.compat.VersionManager;
import studio.magemonkey.codex.config.ConfigManager;
import studio.magemonkey.codex.hooks.Hooks;
import studio.magemonkey.codex.util.DataUT;
import studio.magemonkey.codex.util.Reflex;
import studio.magemonkey.codex.util.StringUT;

public class ItemUT {
    public static CodexEngine engine;
    public static final String LORE_FIX_PREFIX = "fogus_loren-";
    public static final String NAME_FIX_PREFIX = "fogus_namel-";
    public static final String TAG_SPLITTER = "__x__";

    public static int addToLore(@NotNull List<String> lore, int pos, @NotNull String value) {
        if (pos >= lore.size() || pos < 0) {
            lore.add(value);
        } else {
            lore.add(pos, value);
        }
        return pos + 1;
    }

    public static void addLore(@NotNull ItemStack item, @NotNull String id, @NotNull String text, int pos) {
        String[] lines = text.split(TAG_SPLITTER);
        ItemUT.addLore(item, id, Arrays.asList(lines), pos);
    }

    public static void addLore(@NotNull ItemStack item, @NotNull String id, @NotNull List<String> text, int pos) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        ArrayList<String> lore = meta.getLore();
        if (lore == null) {
            lore = new ArrayList<String>();
        }
        text = StringUT.color(text);
        StringBuilder loreTag = new StringBuilder();
        ItemUT.delLore(item, id);
        for (String line : text) {
            pos = ItemUT.addToLore(lore, pos, line);
            if (loreTag.length() > 0) {
                loreTag.append(TAG_SPLITTER);
            }
            loreTag.append(line);
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        ItemUT.addLoreTag(item, id, loreTag.toString());
    }

    public static void delLore(@NotNull ItemStack item, @NotNull String id) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        List lore = meta.getLore();
        if (lore == null) {
            return;
        }
        int index = ItemUT.getLoreIndex(item, id, 0);
        if (index < 0) {
            return;
        }
        int lastIndex = ItemUT.getLoreIndex(item, id, 1);
        int diff = lastIndex - index;
        for (int i = 0; i < diff + 1; ++i) {
            lore.remove(index);
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        ItemUT.delLoreTag(item, id);
    }

    public static int getLoreIndex(@NotNull ItemStack item, @NotNull String id) {
        return ItemUT.getLoreIndex(item, id, 0);
    }

    public static int getLoreIndex(@NotNull ItemStack item, @NotNull String id, int type) {
        NamespacedKey key;
        String storedText = null;
        Iterator<NamespacedKey> iterator = ItemUT.getLoreKeys(id).iterator();
        while (iterator.hasNext() && (storedText = DataUT.getStringData(item, key = iterator.next())) == null) {
        }
        if (storedText == null) {
            return -1;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return -1;
        }
        List lore = meta.getLore();
        if (lore == null) {
            return -1;
        }
        String[] lines = storedText.split(TAG_SPLITTER);
        String lastText = null;
        int count = 0;
        if (type == 0) {
            String line;
            String[] stringArray = lines;
            int n = stringArray.length;
            for (int i = 0; i < n && StringUT.colorOff(lastText = (line = stringArray[i])).isEmpty(); ++i) {
                --count;
            }
        } else {
            for (int i = lines.length; i > 0 && StringUT.colorOff(lastText = lines[i - 1]).isEmpty(); --i) {
                ++count;
            }
        }
        if (lastText == null) {
            return -1;
        }
        int index = lore.indexOf(lastText) + count;
        if (index < 0) {
            ItemUT.delLoreTag(item, id);
        }
        return index;
    }

    @NotNull
    private static List<NamespacedKey> getLoreKeys(@NotNull String id) {
        return List.of(new NamespacedKey((Plugin)engine, LORE_FIX_PREFIX + id.toLowerCase()), Objects.requireNonNull(NamespacedKey.fromString((String)("codex:fogus_loren-" + id.toLowerCase()))), Objects.requireNonNull(NamespacedKey.fromString((String)("promccore:fogus_loren-" + id.toLowerCase()))), Objects.requireNonNull(NamespacedKey.fromString((String)("nexengine:fogus_loren-" + id.toLowerCase()))));
    }

    @NotNull
    private static List<NamespacedKey> getNameKeys(@NotNull String id) {
        return List.of(new NamespacedKey((Plugin)engine, NAME_FIX_PREFIX + id.toLowerCase()), Objects.requireNonNull(NamespacedKey.fromString((String)("codex:fogus_namel-" + id.toLowerCase()))), Objects.requireNonNull(NamespacedKey.fromString((String)("promccore:fogus_namel-" + id.toLowerCase()))), Objects.requireNonNull(NamespacedKey.fromString((String)("nexengine:fogus_namel-" + id.toLowerCase()))));
    }

    public static void addLoreTag(@NotNull ItemStack item, @NotNull String id, @NotNull String text) {
        DataUT.setData(item, ItemUT.getLoreKeys(id).get(0), (Object)text);
    }

    public static void delLoreTag(@NotNull ItemStack item, @NotNull String id) {
        for (NamespacedKey key : ItemUT.getLoreKeys(id)) {
            DataUT.removeData(item, key);
        }
    }

    @Nullable
    public static String getLoreTag(@NotNull ItemStack item, @NotNull String id) {
        for (NamespacedKey key : ItemUT.getLoreKeys(id)) {
            String data = DataUT.getStringData(item, key);
            if (data == null) continue;
            return data;
        }
        return null;
    }

    public static void addNameTag(@NotNull ItemStack item, @NotNull String id, @NotNull String text) {
        DataUT.setData(item, ItemUT.getNameKeys(id).get(0), (Object)text);
    }

    public static void delNameTag(@NotNull ItemStack item, @NotNull String id) {
        for (NamespacedKey key : ItemUT.getLoreKeys(id)) {
            DataUT.removeData(item, key);
        }
    }

    @Nullable
    public static String getNameTag(@NotNull ItemStack item, @NotNull String id) {
        for (NamespacedKey key : ItemUT.getNameKeys(id)) {
            String data = DataUT.getStringData(item, key);
            if (data == null) continue;
            return data;
        }
        return null;
    }

    @NotNull
    public static String getItemName(@NotNull ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        return meta != null && meta.hasDisplayName() ? meta.getDisplayName() : ItemUT.getEngine().lang().getEnum((Enum<?>)item.getType());
    }

    public static void addSkullTexture(@NotNull ItemStack item, @NotNull String value) {
        ItemUT.addSkullTexture(item, value, "");
    }

    public static void addSkullTexture(@NotNull ItemStack item, @NotNull String value, @NotNull String id) {
        UUID uuid = ConfigManager.getTempUUID(id);
        if (uuid == null) {
            uuid = UUID.randomUUID();
        }
        VersionManager.getNms().addSkullTexture(item, value, uuid);
    }

    @Nullable
    public static String getSkullTexture(@NotNull ItemStack item) {
        if (item.getType() != Material.PLAYER_HEAD) {
            return null;
        }
        SkullMeta meta = (SkullMeta)item.getItemMeta();
        if (meta == null) {
            return null;
        }
        GameProfile profile = (GameProfile)Reflex.getFieldValue(meta, "profile");
        if (profile == null) {
            return null;
        }
        Collection properties = profile.getProperties().get((Object)"textures");
        Optional<String> opt = properties.stream().map(property -> {
            try {
                return new String[]{property.name(), property.signature(), property.value()};
            }
            catch (NoSuchMethodError ex) {
                try {
                    Method getName = property.getClass().getMethod("getName", new Class[0]);
                    Method getSignature = property.getClass().getMethod("getSignature", new Class[0]);
                    Method getValue = property.getClass().getMethod("getValue", new Class[0]);
                    String name = (String)getName.invoke(property, new Object[0]);
                    String signature = (String)getSignature.invoke(property, new Object[0]);
                    String value = (String)getValue.invoke(property, new Object[0]);
                    return new String[]{name, signature, value};
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    return new String[]{null, null, null};
                }
            }
        }).filter(fields -> fields[0].equalsIgnoreCase("textures") || fields[1].equalsIgnoreCase("textures")).map(fields -> fields[2]).findFirst();
        return opt.orElse(null);
    }

    public static void applyPlaceholderAPI(@NotNull Player player, @NotNull ItemStack item) {
        if (!Hooks.hasPlaceholderAPI()) {
            return;
        }
        ItemUT.replace(item, str -> PlaceholderAPI.setPlaceholders((Player)player, (String)str));
    }

    public static void replace(@NotNull ItemStack item, @NotNull UnaryOperator<String> cs) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        String name = (String)cs.apply(meta.hasDisplayName() ? meta.getDisplayName() : "");
        meta.setDisplayName(name);
        List lore = meta.getLore();
        if (lore != null) {
            lore.replaceAll(cs);
            meta.setLore(lore);
        }
        item.setItemMeta(meta);
    }

    public static void replaceLore(@NotNull ItemStack item, @NotNull String placeholder, @NotNull List<String> r) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        List lore = meta.getLore();
        if (lore == null) {
            return;
        }
        meta.setLore(StringUT.replace((List<String>)lore, placeholder, r));
        item.setItemMeta(meta);
    }

    public static void replaceLore(@NotNull ItemStack item, @NotNull String placeholder, @NotNull String r) {
        ItemUT.replaceLore(item, placeholder, List.of(r));
    }

    public static void addItem(@NotNull Player player, ItemStack ... items) {
        PlayerInventory inv = player.getInventory();
        World world = player.getWorld();
        for (ItemStack item : items) {
            if (ItemUT.isAir(item)) continue;
            if (inv.firstEmpty() == -1) {
                world.dropItem(player.getLocation(), item);
                continue;
            }
            inv.addItem(new ItemStack[]{item});
        }
    }

    public static boolean isAir(@Nullable ItemStack item) {
        if (item == null) {
            return true;
        }
        return item.getType() == Material.AIR || item.getType().isAir();
    }

    public static boolean isWeapon(@NotNull ItemStack item) {
        return VersionManager.getNms().isWeapon(item);
    }

    public static boolean isTool(@NotNull ItemStack item) {
        return VersionManager.getNms().isTool(item);
    }

    public static boolean isArmor(@NotNull ItemStack item) {
        return VersionManager.getNms().isArmor(item);
    }

    public static boolean isBow(@NotNull ItemStack item) {
        return item.getType() == Material.BOW || item.getType() == Material.CROSSBOW;
    }

    @NotNull
    public static EquipmentSlot[] getItemSlots(@NotNull ItemStack item) {
        if (ItemUT.isArmor(item)) {
            return new EquipmentSlot[]{ItemUT.getEquipmentSlotByItemType(item)};
        }
        return new EquipmentSlot[]{EquipmentSlot.HAND, EquipmentSlot.OFF_HAND};
    }

    @NotNull
    public static EquipmentSlot getEquipmentSlotByItemType(@NotNull ItemStack item) {
        String raw = item.getType().name();
        if (raw.contains("HELMET") || raw.contains("SKULL") || raw.contains("HEAD")) {
            return EquipmentSlot.HEAD;
        }
        if (raw.endsWith("CHESTPLATE") || raw.endsWith("ELYTRA")) {
            return EquipmentSlot.CHEST;
        }
        if (raw.endsWith("LEGGINGS")) {
            return EquipmentSlot.LEGS;
        }
        if (raw.endsWith("BOOTS")) {
            return EquipmentSlot.FEET;
        }
        if (item.getType() == Material.SHIELD) {
            return EquipmentSlot.OFF_HAND;
        }
        return EquipmentSlot.HAND;
    }

    @Generated
    public static void setEngine(CodexEngine engine) {
        ItemUT.engine = engine;
    }

    @Generated
    public static CodexEngine getEngine() {
        return engine;
    }
}

