/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.mccore.util;

import java.util.ArrayList;

public class TextSplitter {
    private static final int MIN_WRAP = 4;
    private static final int SPACE = 1;
    private static final int DASH = 1;

    public static ArrayList<String> getLines(String message, int maxLength) {
        if (message == null) {
            throw new IllegalArgumentException("Null string");
        }
        ArrayList<String> lines = new ArrayList<String>();
        String[] pieces = message.contains(" ") ? message.split(" ") : new String[]{message};
        Object line = "";
        int offset = 0;
        for (int i = 0; i < pieces.length; ++i) {
            if (((String)line).length() == 0) {
                if (pieces[i].length() - offset > maxLength) {
                    lines.add(pieces[i].substring(offset, maxLength - 1 + offset) + "-");
                    offset += maxLength - 1;
                    --i;
                    continue;
                }
                line = (String)line + pieces[i].substring(offset);
                offset = 0;
                continue;
            }
            if (pieces[i].length() + ((String)line).length() > maxLength - 1) {
                if (((String)line).length() > maxLength - 4 || ((String)line).length() + pieces[i].length() < maxLength - 1 - 1 + 4) {
                    lines.add((String)line);
                    line = "";
                    --i;
                    continue;
                }
                offset = maxLength - 1 - 1 - ((String)line).length();
                line = (String)line + " " + pieces[i].substring(0, maxLength - 1 - 1 - ((String)line).length()) + "-";
                lines.add((String)line);
                line = "";
                --i;
                continue;
            }
            line = (String)line + " " + pieces[i].substring(offset);
        }
        lines.add((String)line);
        return lines;
    }
}

