/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.mccore.sql.direct;

import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import studio.magemonkey.codex.mccore.sql.ColumnType;
import studio.magemonkey.codex.mccore.sql.direct.ISQLEntryData;
import studio.magemonkey.codex.mccore.sql.direct.SQLDatabase;
import studio.magemonkey.codex.mccore.sql.direct.SQLEntry;

public class SQLTable {
    private final Map<String, SQLEntry> entries = new HashMap<String, SQLEntry>();
    private final PreparedStatement QUERY_NAME;
    private final PreparedStatement QUERY_ALL;
    private final PreparedStatement CREATE_ENTRY;
    private final PreparedStatement DELETE_ENTRY;
    private SQLDatabase database;
    private String name;

    public SQLTable(SQLDatabase sql, String name) {
        this.database = sql;
        this.name = name;
        this.QUERY_NAME = sql.getStatement("SELECT * FROM " + name + " WHERE Name = ?");
        this.QUERY_ALL = sql.getStatement("SELECT * FROM " + name);
        this.CREATE_ENTRY = sql.getStatement("INSERT INTO " + name + " (Name) VALUES (?)");
        this.DELETE_ENTRY = sql.getStatement("DELETE FROM " + name + " WHERE Name=?");
    }

    public String getName() {
        return this.name;
    }

    public boolean columnExists(String name) {
        try {
            DatabaseMetaData meta = this.database.getMeta();
            ResultSet result = meta.getColumns(null, null, this.name, name);
            boolean exists = result.next();
            result.close();
            return exists;
        }
        catch (Exception ex) {
            this.database.getLogger().severe("Unable to validate table: " + ex.getMessage());
            return false;
        }
    }

    public String getColumnType(String name) {
        try {
            DatabaseMetaData meta = this.database.getMeta();
            ResultSet result = meta.getColumns(null, null, this.name, name);
            if (result.next()) {
                return result.getString("TYPE_NAME");
            }
        }
        catch (Exception ex) {
            this.database.getLogger().severe("Unable to validate table: " + ex.getMessage());
        }
        return null;
    }

    public void createColumn(String name, ColumnType type) {
        if (this.columnExists(name)) {
            String baseType;
            String colType = this.getColumnType(name);
            if (colType.equals(baseType = type.toString().split(" ")[0])) {
                return;
            }
            this.database.getLogger().warning("Column \"" + name + "\" already exists in the table \"" + this.name + "\", but with a different type (" + colType + "). Attempting to update to " + String.valueOf((Object)type) + ".");
            try {
                PreparedStatement statement = this.database.getStatement("ALTER TABLE " + this.name + " MODIFY " + name + " " + String.valueOf((Object)type));
                statement.executeUpdate();
            }
            catch (Exception ex) {
                this.database.getLogger().severe("Failed to update the column \"" + name + "\" in the table \"" + this.name + "\" - " + ex.getMessage());
            }
            return;
        }
        try {
            PreparedStatement statement = this.database.getStatement("ALTER TABLE " + this.name + " ADD " + name + " " + String.valueOf((Object)type));
            statement.executeUpdate();
        }
        catch (Exception ex) {
            this.database.getLogger().severe("Failed to add the column \"" + name + "\" to the table \"" + this.name + "\" - " + ex.getMessage());
        }
    }

    public ResultSet query(String name) {
        try {
            this.QUERY_NAME.setString(1, name);
            return this.QUERY_NAME.executeQuery();
        }
        catch (Exception ex) {
            this.database.getLogger().severe("Failed to query SQL database: " + ex.getMessage());
            return null;
        }
    }

    public ResultSet queryAll() {
        try {
            return this.QUERY_ALL.executeQuery();
        }
        catch (Exception ex) {
            this.database.getLogger().severe("Failed to query SQL database: " + ex.getMessage());
            return null;
        }
    }

    public <T extends ISQLEntryData> List<T> getAllData(Class<T> c) {
        ArrayList<ISQLEntryData> list = new ArrayList<ISQLEntryData>();
        try {
            ResultSet set = this.queryAll();
            while (set.next()) {
                ISQLEntryData container = (ISQLEntryData)c.newInstance();
                container.loadData(set);
                list.add(container);
            }
            set.close();
            return list;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public boolean entryExists(String name) {
        if (this.entries.containsKey(name)) {
            return true;
        }
        ResultSet result = this.query(name);
        if (result != null) {
            try {
                boolean exists = result.next();
                result.close();
                return exists;
            }
            catch (Exception ex) {
                this.database.getLogger().severe("Failed to check for an existing entry: " + ex.getMessage());
            }
        }
        return false;
    }

    public SQLEntry createEntry(String name) {
        if (!this.database.isConnected()) {
            return null;
        }
        if (this.entries.containsKey(name)) {
            return this.entries.get(name);
        }
        if (this.entryExists(name)) {
            return new SQLEntry(this.database, this, name);
        }
        try {
            this.CREATE_ENTRY.setString(1, name);
            this.CREATE_ENTRY.execute();
            SQLEntry entry = new SQLEntry(this.database, this, name);
            this.entries.put(name, entry);
            this.database.getLogger().info("Created a new MySQL table with the name: " + name);
            return entry;
        }
        catch (Exception ex) {
            this.database.getLogger().severe("Failed to create entry \"" + name + "\" - " + ex.getMessage());
            return null;
        }
    }

    public boolean deleteEntry(String name) {
        if (this.database.isConnected()) {
            try {
                this.DELETE_ENTRY.setString(1, name);
                this.DELETE_ENTRY.execute();
                this.entries.remove(name);
                return true;
            }
            catch (Exception ex) {
                this.database.getLogger().severe("Failed to delete table \"" + name + "\" - " + ex.getMessage());
            }
        }
        return false;
    }
}

