/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.mccore.sql;

public enum ColumnType {
    STRING_16("VARCHAR(16)"),
    STRING_32("VARCHAR(32)"),
    STRING_64("VARCHAR(64)"),
    STRING_128("VARCHAR(128)"),
    STRING_255("VARCHAR(255)"),
    TEXT("TEXT"),
    MEDIUM_TEXT("MEDIUMTEXT"),
    INT("INT"),
    LONG("BIGINT"),
    FLOAT("FLOAT(24)"),
    DOUBLE("FLOAT(53)"),
    INCREMENT("INT KEY AUTO_INCREMENT"),
    DATE_TIME("DATETIME");

    private final String key;

    private ColumnType(String key) {
        this.key = key;
    }

    public static ColumnType getByValues(String type, int size) {
        if (type.equalsIgnoreCase("VARCHAR")) {
            switch (size) {
                case 16: {
                    return STRING_16;
                }
                case 32: {
                    return STRING_32;
                }
                case 64: {
                    return STRING_64;
                }
                case 128: {
                    return STRING_128;
                }
                case 255: {
                    return STRING_255;
                }
                case 65535: {
                    return TEXT;
                }
            }
            if (size > 255) {
                return TEXT;
            }
            if (size > 128) {
                return STRING_255;
            }
            if (size > 64) {
                return STRING_128;
            }
            if (size > 32) {
                return STRING_64;
            }
            if (size > 16) {
                return STRING_32;
            }
            return STRING_16;
        }
        if (type.equals("TEXT")) {
            return TEXT;
        }
        if (type.equalsIgnoreCase("INT")) {
            return INT;
        }
        if (type.equals("FLOAT")) {
            return FLOAT;
        }
        if (type.equals("DOUBLE")) {
            return DOUBLE;
        }
        if (type.equals("DATETIME")) {
            return DATE_TIME;
        }
        if (type.equals("BIGINT")) {
            return LONG;
        }
        return null;
    }

    public String toString() {
        return this.key;
    }
}

