/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.mccore.scoreboard;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.mccore.scoreboard.Board;
import studio.magemonkey.codex.mccore.scoreboard.BoardManager;

public class PlayerBoards {
    private final List<Board> boards = new ArrayList<Board>();
    private final String playerName;
    protected boolean cycling;
    private Board currentBoard;
    private boolean enabled = true;
    private int current = 0;

    public PlayerBoards(String playerName) {
        this.playerName = playerName;
        this.cycling = true;
    }

    public void toggle() {
        if (this.currentBoard != null) {
            if (this.enabled) {
                this.currentBoard.clearDisplay();
            } else {
                this.currentBoard.showPlayer();
            }
        }
        this.enabled = !this.enabled;
    }

    public Player getPlayer() {
        return Bukkit.getPlayer((String)this.playerName);
    }

    public void addBoard(Board board) {
        Player player = this.getPlayer();
        if (player == null) {
            throw new IllegalStateException("Cannot add boards when no player is present");
        }
        board.setPlayer(player);
        this.boards.add(board);
        if (this.currentBoard == null) {
            this.showNextBoard();
        }
    }

    public void removeBoard(Board board) {
        if (!this.boards.contains(board)) {
            return;
        }
        this.boards.remove(board);
        if (this.currentBoard == board) {
            this.clear();
            this.showNextBoard();
        }
    }

    public void removeBoards(String plugin) {
        this.boards.stream().filter(board -> board.plugin.equalsIgnoreCase(plugin)).collect(Collectors.toSet()).forEach(this::removeBoard);
        this.clear();
    }

    private void clear() {
        if (this.currentBoard != null) {
            this.currentBoard.clearDisplay();
        }
        this.current = -1;
        this.currentBoard = null;
    }

    public boolean showBoard(String name) {
        for (int i = 0; i < this.boards.size(); ++i) {
            if (!this.format(this.boards.get(i).getName()).equals(name)) continue;
            this.show(i);
        }
        return false;
    }

    private void show(int index) {
        if (this.currentBoard != null) {
            this.currentBoard.clearDisplay();
        }
        this.current = index;
        this.currentBoard = this.boards.get(index);
        this.currentBoard.showPlayer();
    }

    public void showNextBoard() {
        if (this.boards.isEmpty() || !this.enabled) {
            return;
        }
        int next = (this.current + 1) % this.boards.size();
        if (next != this.current) {
            this.show(next);
        }
    }

    private String format(String name) {
        return ChatColor.stripColor((String)name.toLowerCase());
    }

    public Board getBoard(String name) {
        return this.boards.stream().filter(board -> this.format(board.getName()).equals(name)).findFirst().orElse(null);
    }

    @Nullable
    public Board getActiveBoard() {
        return this.currentBoard;
    }

    public boolean hasActiveBoard() {
        return !this.boards.isEmpty() && this.enabled;
    }

    public void startCycling() {
        this.cycling = true;
    }

    public void stopCycling() {
        this.cycling = false;
    }

    @Deprecated
    public void setHealthLabel(String label) {
        BoardManager.setTextBelowNames(label);
    }

    @Generated
    public List<Board> getBoards() {
        return this.boards;
    }

    @Generated
    public String getPlayerName() {
        return this.playerName;
    }

    @Generated
    public boolean isCycling() {
        return this.cycling;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }
}

